/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.labeled;

import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import com.ibm.wala.util.graph.labeled.LabeledGraph;
import com.ibm.wala.util.graph.labeled.NumberedLabeledEdgeManager;
import com.ibm.wala.util.graph.labeled.SparseNumberedLabeledEdgeManager;

public class SlowSparseNumberedLabeledGraph<T, U>
extends AbstractNumberedLabeledGraph<T, U> {
    private final SlowNumberedNodeManager<T> nodeManager;
    private final SparseNumberedLabeledEdgeManager<T, U> edgeManager;

    public static <T, U> SlowSparseNumberedLabeledGraph<T, U> duplicate(LabeledGraph<T, U> g2) {
        SlowSparseNumberedLabeledGraph result = new SlowSparseNumberedLabeledGraph(g2.getDefaultLabel());
        SlowSparseNumberedLabeledGraph.copyInto(g2, result);
        return result;
    }

    public static <T, U> void copyInto(LabeledGraph<T, U> g2, LabeledGraph<T, U> into) {
        if (g2 == null) {
            throw new IllegalArgumentException("g is null");
        }
        for (Object name : g2) {
            into.addNode(name);
        }
        for (Object n : g2) {
            for (Object s2 : Iterator2Iterable.make(g2.getSuccNodes(n))) {
                for (Object l : g2.getEdgeLabels(n, s2)) {
                    into.addEdge(n, s2, l);
                }
            }
        }
    }

    public SlowSparseNumberedLabeledGraph(U defaultLabel) {
        if (defaultLabel == null) {
            throw new IllegalArgumentException("null default label");
        }
        this.nodeManager = new SlowNumberedNodeManager();
        this.edgeManager = new SparseNumberedLabeledEdgeManager<T, U>(this.nodeManager, defaultLabel);
    }

    @Override
    protected NumberedLabeledEdgeManager<T, U> getEdgeManager() {
        return this.edgeManager;
    }

    @Override
    protected NumberedNodeManager<T> getNodeManager() {
        return this.nodeManager;
    }
}

