/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.DFSDiscoverTimeIterator;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import com.ibm.wala.util.graph.traverse.NumberedDFSDiscoverTimeIterator;
import com.ibm.wala.util.graph.traverse.NumberedDFSFinishTimeIterator;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import com.ibm.wala.util.graph.traverse.SlowDFSFinishTimeIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;

public class DFS {
    public static <T> Collection<T> getReachableNodes(final Graph<T> G, Collection<? extends T> C2, final Predicate<? super T> filter) {
        if (C2 == null) {
            throw new IllegalArgumentException("C is null");
        }
        SlowDFSFinishTimeIterator dfs = new SlowDFSFinishTimeIterator<T>(G, C2.iterator()){

            @Override
            protected Iterator<T> getConnected(T n) {
                return new FilterIterator(G.getSuccNodes(n), filter);
            }
        };
        return Iterator2Collection.toSet(dfs);
    }

    public static <T> Set<T> getReachableNodes(Graph<T> G, Collection<? extends T> C2) {
        if (C2 == null) {
            throw new IllegalArgumentException("C is null");
        }
        HashSet result = HashSetFactory.make();
        DFSFinishTimeIterator<T> dfs = DFS.iterateFinishTime(G, C2.iterator());
        while (dfs.hasNext()) {
            result.add(dfs.next());
        }
        return result;
    }

    public static <T> Set<T> getReachableNodes(Graph<T> G) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G == null");
        }
        HashSet result = HashSetFactory.make();
        DFSFinishTimeIterator<T> dfs = DFS.iterateFinishTime(G);
        while (dfs.hasNext()) {
            result.add(dfs.next());
        }
        return result;
    }

    public static <T> SortedSet<T> sortByDepthFirstOrder(Graph<T> G, T n) {
        HashMap order = HashMapFactory.make();
        TreeSet result = new TreeSet(new DFSComparator(order));
        DFSFinishTimeIterator<T> dfs = DFS.iterateFinishTime(G, new NonNullSingletonIterator<T>(n));
        int i = 0;
        while (dfs.hasNext()) {
            Object nxt = dfs.next();
            order.put(nxt, i++);
            result.add(nxt);
        }
        return result;
    }

    public static <T> DFSDiscoverTimeIterator<T> iterateDiscoverTime(Graph<T> G) {
        if (G instanceof NumberedGraph) {
            return new NumberedDFSDiscoverTimeIterator((NumberedGraph)G);
        }
        return new SlowDFSDiscoverTimeIterator<T>(G);
    }

    public static <T> Iterator<T> iterateDiscoverTime(Graph<T> G, Iterator<T> roots) throws IllegalArgumentException {
        if (roots == null) {
            throw new IllegalArgumentException("roots == null");
        }
        if (G instanceof NumberedGraph) {
            return new NumberedDFSDiscoverTimeIterator<T>((NumberedGraph)G, roots);
        }
        return new SlowDFSDiscoverTimeIterator<T>(G, roots);
    }

    public static <T> DFSDiscoverTimeIterator<T> iterateDiscoverTime(Graph<T> G, T N) {
        if (G == null) {
            throw new IllegalArgumentException("G == null");
        }
        if (G instanceof NumberedGraph) {
            return new NumberedDFSDiscoverTimeIterator<T>((NumberedGraph)G, N);
        }
        return new SlowDFSDiscoverTimeIterator<T>(G, N);
    }

    public static <T> DFSFinishTimeIterator<T> iterateFinishTime(Graph<T> G) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G == null");
        }
        if (G instanceof NumberedGraph) {
            return new NumberedDFSFinishTimeIterator((NumberedGraph)G);
        }
        return new SlowDFSFinishTimeIterator<T>(G);
    }

    public static <T> DFSFinishTimeIterator<T> iterateFinishTime(Graph<T> G, Iterator<? extends T> ie) {
        if (ie == null) {
            throw new IllegalArgumentException("null ie");
        }
        if (G instanceof NumberedGraph) {
            return new NumberedDFSFinishTimeIterator<T>((NumberedGraph)G, ie);
        }
        return new SlowDFSFinishTimeIterator<T>(G, ie);
    }

    static class DFSComparator<T>
    implements Comparator<T> {
        private final Map<T, Integer> order;

        DFSComparator(Map<T, Integer> order) {
            this.order = order;
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            Integer t1 = this.order.get(o1);
            Integer t2 = this.order.get(o2);
            return t1 - t2;
        }
    }
}

