/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.HashSet;

class DebuggingMutableIntSet
implements MutableIntSet {
    private static final long serialVersionUID = 6879912730471879687L;
    final MutableIntSet primaryImpl;
    final MutableIntSet secondaryImpl;

    DebuggingMutableIntSet(MutableIntSet p, MutableIntSet s2) {
        this.primaryImpl = p;
        this.secondaryImpl = s2;
    }

    private void assertEquiv() {
        assert (this.primaryImpl.sameValue(this.secondaryImpl));
    }

    @Override
    public void clear() {
        this.primaryImpl.clear();
        this.secondaryImpl.clear();
    }

    @Override
    public boolean contains(int i) {
        assert (this.primaryImpl.contains(i) == this.secondaryImpl.contains(i));
        return this.primaryImpl.contains(i);
    }

    @Override
    public boolean isEmpty() {
        if (this.primaryImpl.isEmpty() != this.secondaryImpl.isEmpty()) {
            System.err.println(this.primaryImpl + ".isEmpty() = " + this.primaryImpl.isEmpty() + " and " + this.secondaryImpl + ".isEmpty() = " + this.secondaryImpl.isEmpty());
            Assertions.UNREACHABLE();
        }
        return this.primaryImpl.isEmpty();
    }

    @Override
    public int size() {
        if (this.primaryImpl.size() != this.secondaryImpl.size()) assert (this.primaryImpl.size() == this.secondaryImpl.size()) : "size " + this.primaryImpl.size() + " of " + this.primaryImpl + " differs from size " + this.secondaryImpl.size() + " of " + this.secondaryImpl;
        return this.primaryImpl.size();
    }

    @Override
    public int max() {
        assert (this.primaryImpl.max() == this.secondaryImpl.max());
        return this.primaryImpl.max();
    }

    @Override
    public boolean add(int i) {
        boolean sr;
        boolean pr = this.primaryImpl.add(i);
        if (pr != (sr = this.secondaryImpl.add(i))) assert (pr == sr) : "adding " + i + " to " + this.primaryImpl + " returns " + pr + ", but adding " + i + " to " + this.secondaryImpl + " returns " + sr;
        return pr;
    }

    @Override
    public boolean remove(int i) {
        boolean result = this.primaryImpl.remove(i);
        this.secondaryImpl.remove(i);
        this.assertEquiv();
        return result;
    }

    @Override
    public boolean containsAny(IntSet set) {
        if (set instanceof DebuggingMutableIntSet) {
            boolean ssr;
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)set;
            boolean ppr = this.primaryImpl.containsAny(db.primaryImpl);
            if (ppr != (ssr = this.secondaryImpl.containsAny(db.secondaryImpl))) assert (ppr == ssr) : "containsAny " + this + ' ' + set + ' ' + ppr + ' ' + ssr;
            return ppr;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public IntSet intersection(IntSet that) {
        if (that instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)that;
            IntSet ppr = this.primaryImpl.intersection(db.primaryImpl);
            IntSet ssr = this.secondaryImpl.intersection(db.secondaryImpl);
            assert (ppr.sameValue(ssr));
            return ppr;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet union(IntSet that) {
        MutableSparseIntSet temp = new MutableSparseIntSet();
        temp.addAll(this);
        temp.addAll(that);
        return temp;
    }

    @Override
    public boolean sameValue(IntSet that) {
        if (that instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)that;
            boolean ppr = this.primaryImpl.sameValue(db.primaryImpl);
            boolean ssr = this.secondaryImpl.sameValue(db.secondaryImpl);
            assert (ppr == ssr);
            return ppr;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public boolean isSubset(IntSet that) {
        if (that instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)that;
            boolean ppr = this.primaryImpl.isSubset(db.primaryImpl);
            boolean ssr = this.secondaryImpl.isSubset(db.secondaryImpl);
            assert (ppr == ssr);
            return ppr;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void copySet(IntSet set) {
        if (set instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)set;
            this.primaryImpl.copySet(db.primaryImpl);
            this.secondaryImpl.copySet(db.secondaryImpl);
            assert (this.primaryImpl.sameValue(this.secondaryImpl));
        } else {
            Assertions.UNREACHABLE();
        }
    }

    @Override
    public boolean addAll(IntSet set) {
        if (set instanceof DebuggingMutableIntSet) {
            boolean ssr;
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)set;
            int ps = this.primaryImpl.size();
            int ss = this.secondaryImpl.size();
            boolean ppr = this.primaryImpl.addAll(db.primaryImpl);
            if (ppr != (ssr = this.secondaryImpl.addAll(db.secondaryImpl))) {
                System.err.println("ppr was " + ppr + " (should be " + (ps != this.primaryImpl.size()) + ") but ssr was " + ssr + " (should be " + (ss != this.secondaryImpl.size()) + ')');
                System.err.println("adding " + set + " to " + this + " failed");
                Assertions.UNREACHABLE();
            }
            return ppr;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void intersectWith(IntSet set) {
        if (set instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)set;
            this.primaryImpl.intersectWith(db.primaryImpl);
            this.secondaryImpl.intersectWith(db.secondaryImpl);
            if (!this.primaryImpl.sameValue(this.secondaryImpl)) assert (false) : this + " (" + this.primaryImpl.size() + ", " + this.secondaryImpl.size() + ") inconsistent after intersecting with " + set;
        } else {
            Assertions.UNREACHABLE();
        }
    }

    @Override
    public boolean addAllInIntersection(IntSet other, IntSet filter) {
        if (other instanceof DebuggingMutableIntSet && filter instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)other;
            DebuggingMutableIntSet df = (DebuggingMutableIntSet)filter;
            boolean pr = this.primaryImpl.addAllInIntersection(db.primaryImpl, df.primaryImpl);
            boolean sr = this.secondaryImpl.addAllInIntersection(db.secondaryImpl, df.secondaryImpl);
            assert (pr == sr);
            return pr;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public IntIterator intIterator() {
        int x;
        MutableSparseIntSet bits = MutableSparseIntSet.makeEmpty();
        IntIterator pi = this.primaryImpl.intIterator();
        while (pi.hasNext()) {
            x = pi.next();
            assert (!bits.contains(x));
            bits.add(x);
        }
        IntIterator si = this.secondaryImpl.intIterator();
        while (si.hasNext()) {
            x = si.next();
            assert (bits.contains(x));
            bits.remove(x);
        }
        assert (bits.isEmpty());
        return this.primaryImpl.intIterator();
    }

    @Override
    public void foreach(IntSetAction action) {
        HashSet bits = HashSetFactory.make();
        this.primaryImpl.foreach(x -> {
            assert (!bits.contains(x));
            bits.add(x);
        });
        this.secondaryImpl.foreach(x -> {
            assert (bits.contains(x));
            bits.remove(x);
        });
        assert (bits.isEmpty());
        this.primaryImpl.foreach(action);
    }

    @Override
    public void foreachExcluding(IntSet X, IntSetAction action) {
        HashSet bits = HashSetFactory.make();
        this.primaryImpl.foreachExcluding(X, x -> {
            assert (!bits.contains(x));
            bits.add(x);
        });
        this.secondaryImpl.foreachExcluding(X, x -> {
            assert (bits.contains(x));
            bits.remove(x);
        });
        assert (bits.isEmpty());
        this.primaryImpl.foreachExcluding(X, action);
    }

    public String toString() {
        return "[[P " + this.primaryImpl.toString() + ", S " + this.secondaryImpl.toString() + " ]]";
    }
}

