/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.DebuggingMutableIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.SparseIntSet;

public class DebuggingMutableIntSetFactory
implements MutableIntSetFactory<DebuggingMutableIntSet> {
    private MutableIntSetFactory<?> primary;
    private MutableIntSetFactory<?> secondary;

    public DebuggingMutableIntSetFactory(MutableIntSetFactory<?> p, MutableIntSetFactory<?> s2) {
        this.primary = p;
        this.secondary = s2;
        if (p == null) {
            throw new IllegalArgumentException("null p");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("null s");
        }
    }

    public DebuggingMutableIntSetFactory() {
        this(new MutableSparseIntSetFactory(), new MutableSharedBitVectorIntSetFactory());
    }

    @Override
    public DebuggingMutableIntSet make(int[] set) {
        if (set == null) {
            throw new IllegalArgumentException("null set");
        }
        return new DebuggingMutableIntSet((MutableIntSet)this.primary.make(set), (MutableIntSet)this.secondary.make(set));
    }

    @Override
    public DebuggingMutableIntSet parse(String string) {
        int[] backingStore = SparseIntSet.parseIntArray(string);
        return this.make(backingStore);
    }

    @Override
    public DebuggingMutableIntSet makeCopy(IntSet x) throws UnimplementedError {
        if (x == null) {
            throw new IllegalArgumentException("null x");
        }
        if (x instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet db = (DebuggingMutableIntSet)x;
            Object pr = this.primary.makeCopy(db.primaryImpl);
            Object sr = this.secondary.makeCopy(db.secondaryImpl);
            assert (pr.sameValue(db.primaryImpl));
            assert (sr.sameValue(db.secondaryImpl));
            assert (pr.sameValue((IntSet)sr));
            return new DebuggingMutableIntSet((MutableIntSet)pr, (MutableIntSet)sr);
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public DebuggingMutableIntSet make() {
        return new DebuggingMutableIntSet((MutableIntSet)this.primary.make(), (MutableIntSet)this.secondary.make());
    }

    public void setPrimaryFactory(MutableIntSetFactory<?> x) {
        if (x == null) {
            throw new IllegalArgumentException("null x");
        }
        if (x == this) {
            throw new IllegalArgumentException("bad recursion");
        }
        this.primary = x;
    }

    public void setSecondaryFactory(MutableIntSetFactory<?> x) {
        if (x == null) {
            throw new IllegalArgumentException("null x");
        }
        if (x == this) {
            throw new IllegalArgumentException("bad recursion");
        }
        this.secondary = x;
    }
}

