/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.LongIterator;
import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.MutableLongSetFactory;
import com.ibm.wala.util.intset.MutableSparseLongSet;
import com.ibm.wala.util.intset.MutableSparseLongSetFactory;
import com.ibm.wala.util.intset.SparseLongSet;

public class LongSetUtil {
    public static final String INT_SET_FACTORY_CONFIG_PROPERTY_NAME = "com.ibm.wala.mutableLongSetFactory";
    private static MutableLongSetFactory defaultLongSetFactory;
    private static final boolean DEBUG = false;

    public static MutableLongSet make() {
        return defaultLongSetFactory.make();
    }

    public static MutableLongSet makeMutableCopy(LongSet set) throws IllegalArgumentException, UnimplementedError {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof SparseLongSet) {
            return MutableSparseLongSet.make(set);
        }
        Assertions.UNREACHABLE(set.getClass().toString());
        return null;
    }

    public static LongSet diff(LongSet A2, LongSet B) {
        if (A2 == null) {
            throw new IllegalArgumentException("null A");
        }
        if (B == null) {
            throw new IllegalArgumentException("null B");
        }
        return LongSetUtil.diff(A2, B, LongSetUtil.getDefaultLongSetFactory());
    }

    private static LongSet defaultSlowDiff(LongSet A2, LongSet B, MutableLongSetFactory factory) {
        MutableLongSet result = factory.makeCopy(A2);
        LongIterator it = B.longIterator();
        while (it.hasNext()) {
            long I2 = it.next();
            result.remove(I2);
        }
        return result;
    }

    public static LongSet diff(LongSet A2, LongSet B, MutableLongSetFactory factory) {
        if (A2 == null) {
            throw new IllegalArgumentException("null A");
        }
        if (B == null) {
            throw new IllegalArgumentException("null B");
        }
        if (A2 instanceof SparseLongSet && B instanceof SparseLongSet) {
            return SparseLongSet.diff((SparseLongSet)A2, (SparseLongSet)B);
        }
        return LongSetUtil.defaultSlowDiff(A2, B, factory);
    }

    public static MutableLongSet removeAll(MutableLongSet A2, LongSet B) throws IllegalArgumentException {
        if (A2 == null) {
            throw new IllegalArgumentException("A == null");
        }
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        LongIterator it = B.longIterator();
        while (it.hasNext()) {
            long I2 = it.next();
            A2.remove(I2);
        }
        return A2;
    }

    public static int binarySearch(long[] data, long key, int low, int high) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("null array");
        }
        if (data.length == 0) {
            return -1;
        }
        if (low <= high && (low < 0 || high < 0)) {
            throw new IllegalArgumentException("can't search negative indices");
        }
        if (high > data.length - 1) {
            high = data.length - 1;
        }
        if (low <= high) {
            int mid = (low + high) / 2;
            long midValue = data[mid];
            if (midValue == key) {
                return mid;
            }
            if (midValue > key) {
                return LongSetUtil.binarySearch(data, key, low, mid - 1);
            }
            return LongSetUtil.binarySearch(data, key, mid + 1, high);
        }
        return -1;
    }

    public static MutableLongSetFactory getDefaultLongSetFactory() {
        return defaultLongSetFactory;
    }

    public static void setDefaultLongSetFactory(MutableLongSetFactory defaultLongSetFactory) {
        if (defaultLongSetFactory == null) {
            throw new IllegalArgumentException("null defaultLongSetFactory");
        }
        LongSetUtil.defaultLongSetFactory = defaultLongSetFactory;
    }

    public static LongSet add(LongSet s2, int j) throws IllegalArgumentException {
        if (s2 == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (s2 instanceof SparseLongSet) {
            SparseLongSet sis = (SparseLongSet)s2;
            return SparseLongSet.add(sis, j);
        }
        MutableSparseLongSet result = MutableSparseLongSet.make(s2);
        result.add(j);
        return result;
    }

    static {
        MutableSparseLongSetFactory defaultFactory = new MutableSparseLongSetFactory();
        if (System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME) != null) {
            try {
                Class<?> intSetFactoryClass = Class.forName(System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                MutableLongSetFactory intSetFactory = (MutableLongSetFactory)intSetFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LongSetUtil.setDefaultLongSetFactory(intSetFactory);
            }
            catch (Exception e) {
                System.err.println("Cannot use int set factory " + System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                LongSetUtil.setDefaultLongSetFactory(defaultFactory);
            }
        } else {
            LongSetUtil.setDefaultLongSetFactory(defaultFactory);
        }
        assert (defaultLongSetFactory != null);
    }
}

