/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.MutableLongSetFactory;
import com.ibm.wala.util.intset.MutableSparseLongSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Arrays;
import java.util.TreeSet;

public class MutableSparseLongSetFactory
implements MutableLongSetFactory {
    @Override
    public MutableLongSet make(long[] set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (set.length == 0) {
            return new MutableSparseLongSet();
        }
        TreeSet<Long> T = new TreeSet<Long>();
        for (long element : set) {
            T.add(element);
        }
        long[] copy = new long[T.size()];
        int i = 0;
        for (Long I2 : T) {
            copy[i++] = I2;
        }
        MutableSparseLongSet result = new MutableSparseLongSet(copy);
        return result;
    }

    @Override
    public MutableLongSet parse(String string) throws NumberFormatException {
        int[] backingStore = SparseIntSet.parseIntArray(string);
        long[] bs = Arrays.stream(backingStore).asLongStream().toArray();
        return new MutableSparseLongSet(bs);
    }

    @Override
    public MutableLongSet makeCopy(LongSet x) throws IllegalArgumentException {
        if (x == null) {
            throw new IllegalArgumentException("x == null");
        }
        return MutableSparseLongSet.make(x);
    }

    @Override
    public MutableLongSet make() {
        return new MutableSparseLongSet();
    }
}

