/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public class OffsetOrdinalSetMapping<T>
implements OrdinalSetMapping<T> {
    private final OrdinalSetMapping<T> delegate;
    private final int offset;

    private OffsetOrdinalSetMapping(OrdinalSetMapping<T> delegate, int offset) {
        this.delegate = delegate;
        this.offset = offset;
    }

    @Override
    public int getMaximumIndex() {
        return this.offset + this.delegate.getMaximumIndex();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    public static <T> OffsetOrdinalSetMapping<T> make(OrdinalSetMapping<T> delegate, int offset) {
        if (delegate == null) {
            throw new IllegalArgumentException("null delegate");
        }
        return new OffsetOrdinalSetMapping<T>(delegate, offset);
    }

    public static <T> OffsetOrdinalSetMapping<T> make(int offset) {
        MutableMapping m3 = MutableMapping.make();
        return new OffsetOrdinalSetMapping(m3, offset);
    }

    @Override
    public int add(T o) {
        return this.offset + this.delegate.add(o);
    }

    @Override
    public int getMappedIndex(Object o) {
        if (this.delegate.getMappedIndex(o) == -1) {
            return -1;
        }
        return this.offset + this.delegate.getMappedIndex(o);
    }

    @Override
    public T getMappedObject(int n) throws NoSuchElementException {
        return this.delegate.getMappedObject(n - this.offset);
    }

    @Override
    public boolean hasMappedIndex(T o) {
        return this.delegate.hasMappedIndex(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Stream<T> stream() {
        return this.delegate.stream();
    }
}

