/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SparseIntSet
implements IntSet {
    private static final long serialVersionUID = 2394141733718319022L;
    private static final int SINGLETON_CACHE_SIZE = 5000;
    private static final SparseIntSet[] singletonCache = new SparseIntSet[5000];
    protected int[] elements;
    protected int size = 0;

    protected SparseIntSet(int size) {
        this.elements = new int[size];
        this.size = size;
    }

    protected SparseIntSet(int[] backingArray) {
        if (backingArray == null) {
            throw new IllegalArgumentException("backingArray is null");
        }
        this.elements = backingArray;
        this.size = backingArray.length;
    }

    public SparseIntSet() {
        this.elements = null;
        this.size = 0;
    }

    protected SparseIntSet(SparseIntSet S) {
        this.cloneState(S);
    }

    private void cloneState(SparseIntSet S) {
        this.elements = (int[])(S.elements != null ? (int[])S.elements.clone() : null);
        this.size = S.size;
    }

    public SparseIntSet(IntSet S) throws IllegalArgumentException {
        if (S == null) {
            throw new IllegalArgumentException("S == null");
        }
        if (S instanceof SparseIntSet) {
            this.cloneState((SparseIntSet)S);
        } else {
            this.elements = new int[S.size()];
            this.size = S.size();
            S.foreach(new IntSetAction(){
                private int index = 0;

                @Override
                public void act(int i) {
                    SparseIntSet.this.elements[this.index++] = i;
                }
            });
        }
    }

    @Override
    public final boolean contains(int x) {
        if (this.elements == null) {
            return false;
        }
        return IntSetUtil.binarySearch(this.elements, x, 0, this.size - 1) >= 0;
    }

    public final int getIndex(int x) {
        if (this.elements == null) {
            return -1;
        }
        return IntSetUtil.binarySearch(this.elements, x, 0, this.size - 1);
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int elementAt(int idx) throws NoSuchElementException {
        if (idx < 0) {
            throw new IllegalArgumentException("invalid idx: " + idx);
        }
        if (this.elements == null || idx >= this.size) {
            throw new NoSuchElementException("Index: " + idx);
        }
        return this.elements[idx];
    }

    private boolean sameValueInternal(SparseIntSet that) {
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == that.elements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean sameValue(IntSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseIntSet) {
            return this.sameValueInternal((SparseIntSet)that);
        }
        if (that instanceof BimodalMutableIntSet) {
            return that.sameValue(this);
        }
        if (that instanceof BitVectorIntSet) {
            return that.sameValue(this);
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            return this.sameValue(((MutableSharedBitVectorIntSet)that).makeSparseCopy());
        }
        Assertions.UNREACHABLE(that.getClass().toString());
        return false;
    }

    private boolean isSubsetInternal(SparseIntSet that) {
        if (this.elements == null) {
            return true;
        }
        if (that.elements == null) {
            return false;
        }
        if (this.equals(that)) {
            return true;
        }
        if (this.sameValue(that)) {
            return true;
        }
        int[] ar = this.elements;
        int ai = 0;
        int al = this.size;
        int[] br = that.elements;
        int bi = 0;
        int bl = that.size;
        while (ai < al && bi < bl) {
            int cmp = ar[ai] - br[bi];
            if (cmp > 0) {
                ++bi;
                continue;
            }
            if (cmp < 0) {
                return false;
            }
            ++ai;
            ++bi;
        }
        return bi != bl || ai >= al;
    }

    public static SparseIntSet diff(SparseIntSet A2, SparseIntSet B) {
        return new SparseIntSet(SparseIntSet.diffInternal(A2, B));
    }

    public static int[] diffInternal(SparseIntSet A2, SparseIntSet B) {
        if (A2 == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (B == null) {
            throw new IllegalArgumentException("B is null");
        }
        if (A2.isEmpty()) {
            return new int[0];
        }
        if (B.isEmpty()) {
            int[] newElts = new int[A2.size];
            System.arraycopy(A2.elements, 0, newElts, 0, A2.size);
            return newElts;
        }
        if (A2.equals(B)) {
            return new int[0];
        }
        if (A2.sameValue(B)) {
            return new int[0];
        }
        int[] ar = A2.elements;
        int ai = 0;
        int al = A2.size;
        int[] br = B.elements;
        int bi = 0;
        int bl = B.size;
        int[] cr = new int[al];
        int ci = 0;
        while (ai < al && bi < bl) {
            int cmp = ar[ai] - br[bi];
            if (cmp > 0) {
                ++bi;
                continue;
            }
            if (cmp < 0) {
                cr[ci++] = ar[ai];
                ++ai;
                continue;
            }
            ++ai;
            ++bi;
        }
        if (ai < al) {
            int tail = al - ai;
            System.arraycopy(ar, ai, cr, ci, tail);
            ci += tail;
        }
        ar = new int[ci];
        System.arraycopy(cr, 0, ar, 0, ci);
        return ar;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(6 * this.size);
        sb.append("{ ");
        if (this.elements != null) {
            for (int ii = 0; ii < this.size; ++ii) {
                sb.append(this.elements[ii]);
                sb.append(' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public static int[] parseIntArray(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        int len = str.length();
        if (len == 0 || str.charAt(0) != '{' || str.charAt(len - 1) != '}') {
            throw new IllegalArgumentException(str);
        }
        str = str.substring(1, len - 1);
        StringTokenizer tok = new StringTokenizer(str, " ,");
        TreeSet<Integer> set = new TreeSet<Integer>();
        while (tok.hasMoreTokens()) {
            set.add(Integer.decode(tok.nextToken()));
        }
        int[] result = new int[set.size()];
        int i = 0;
        for (Integer I2 : set) {
            result[i++] = I2;
        }
        return result;
    }

    public static SparseIntSet singleton(int i) {
        if (i >= 0 && i < 5000) {
            return singletonCache[i];
        }
        return new SparseIntSet(new int[]{i});
    }

    public static SparseIntSet pair(int i, int j) {
        if (i == j) {
            return SparseIntSet.singleton(i);
        }
        if (j > i) {
            return new SparseIntSet(new int[]{i, j});
        }
        return new SparseIntSet(new int[]{j, i});
    }

    @Override
    public IntSet intersection(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseIntSet) {
            MutableSparseIntSet temp = MutableSparseIntSet.make(this);
            temp.intersectWith((SparseIntSet)that);
            return temp;
        }
        if (that instanceof BitVectorIntSet) {
            SparseIntSet s2 = ((BitVectorIntSet)that).toSparseIntSet();
            MutableSparseIntSet temp = MutableSparseIntSet.make(this);
            temp.intersectWith(s2);
            return temp;
        }
        if (that instanceof MutableSharedBitVectorIntSet) {
            MutableSparseIntSet temp = MutableSparseIntSet.make(this);
            temp.intersectWith(that);
            return temp;
        }
        MutableSparseIntSet temp = MutableSparseIntSet.makeEmpty();
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            int x = it.next();
            if (!that.contains(x)) continue;
            temp.add(x);
        }
        return temp;
    }

    @Override
    public IntSet union(IntSet that) {
        MutableSparseIntSet temp = new MutableSparseIntSet();
        temp.addAll(this);
        temp.addAll(that);
        return temp;
    }

    @Override
    public IntIterator intIterator() {
        return new IntIterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SparseIntSet.this.size;
            }

            @Override
            public int next() throws NoSuchElementException {
                if (SparseIntSet.this.elements == null) {
                    throw new NoSuchElementException();
                }
                return SparseIntSet.this.elements[this.i++];
            }
        };
    }

    @Override
    public final int max() throws IllegalStateException {
        if (this.elements == null) {
            throw new IllegalStateException("Illegal to ask max() on an empty int set");
        }
        return this.size > 0 ? this.elements[this.size - 1] : -1;
    }

    @Override
    public void foreach(IntSetAction action) {
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        for (int i = 0; i < this.size; ++i) {
            action.act(this.elements[i]);
        }
    }

    @Override
    public void foreachExcluding(IntSet X, IntSetAction action) {
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        for (int i = 0; i < this.size; ++i) {
            if (X.contains(this.elements[i])) continue;
            action.act(this.elements[i]);
        }
    }

    public static SparseIntSet add(SparseIntSet s2, int j) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s2.elements == null) {
            return SparseIntSet.singleton(j);
        }
        SparseIntSet result = new SparseIntSet(s2.size + 1);
        int k = 0;
        int m3 = 0;
        while (k < s2.elements.length && s2.elements[k] < j) {
            result.elements[k++] = s2.elements[m3++];
        }
        if (k == s2.size) {
            result.elements[k] = j;
        } else {
            if (s2.elements[k] == j) {
                --result.size;
            } else {
                result.elements[k++] = j;
            }
            while (k < result.size) {
                result.elements[k++] = s2.elements[m3++];
            }
        }
        return result;
    }

    @Override
    public boolean isSubset(IntSet that) {
        if (that == null) {
            throw new IllegalArgumentException("null that");
        }
        if (that instanceof SparseIntSet) {
            return this.isSubsetInternal((SparseIntSet)that);
        }
        if (that instanceof BitVectorIntSet) {
            return this.isSubsetInternal((BitVectorIntSet)that);
        }
        IntIterator it = this.intIterator();
        while (it.hasNext()) {
            if (that.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSubsetInternal(BitVectorIntSet set) {
        for (int i = 0; i < this.size; ++i) {
            if (set.contains(this.elements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(IntSet set) {
        if (set instanceof SparseIntSet) {
            return this.containsAny((SparseIntSet)set);
        }
        if (set instanceof BimodalMutableIntSet) {
            return set.containsAny(this);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!set.contains(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(SparseIntSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        int i = 0;
        for (int j = 0; j < set.size; ++j) {
            int x = set.elements[j];
            while (i < this.size && this.elements[i] < x) {
                ++i;
            }
            if (i == this.size) {
                return false;
            }
            if (this.elements[i] != x) continue;
            return true;
        }
        return false;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size];
        if (this.size > 0) {
            System.arraycopy(this.elements, 0, result, 0, this.size);
        }
        return result;
    }

    static {
        for (int i = 0; i < 5000; ++i) {
            SparseIntSet.singletonCache[i] = new SparseIntSet(new int[]{i});
        }
    }
}

