/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.processes;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;

public abstract class Launcher {
    private static final int BUFFER_SIZE = 32768;
    protected File workingDir = null;
    protected Map<String, String> env = null;
    protected byte[] stdOut = null;
    protected byte[] stdErr = null;
    private byte[] input = null;
    private final boolean captureOutput;
    private final boolean captureErr;
    private final Logger logger;

    protected Launcher(Logger logger) {
        this.captureOutput = false;
        this.captureErr = false;
        this.logger = logger;
    }

    protected Launcher(boolean captureOutput, boolean captureErr, Logger logger) {
        this.captureOutput = captureOutput;
        this.captureErr = captureErr;
        this.logger = logger;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File newWorkingDir) {
        this.workingDir = newWorkingDir;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> newEnv) {
        this.env = newEnv;
    }

    public String toString() {
        return super.toString() + " (workingDir: " + this.workingDir + ", env: " + this.env + ')';
    }

    protected Process spawnProcess(String cmd) throws IllegalArgumentException, IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("cmd cannot be null");
        }
        if (this.logger != null) {
            this.logger.info("spawning process " + cmd);
        }
        String[] ev = this.getEnv() == null ? null : Launcher.buildEnv(this.getEnv());
        Process p = Runtime.getRuntime().exec(cmd, ev, this.getWorkingDir());
        return p;
    }

    protected Process spawnProcess(String[] cmd) throws IllegalArgumentException, IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("cmd cannot be null");
        }
        if (this.logger != null) {
            this.logger.info("spawning process " + Arrays.toString(cmd));
        }
        String[] ev = this.getEnv() == null ? null : Launcher.buildEnv(this.getEnv());
        Process p = Runtime.getRuntime().exec(cmd, ev, this.getWorkingDir());
        return p;
    }

    private static String[] buildEnv(Map<String, String> ev) {
        String[] result = new String[ev.size()];
        int i = 0;
        for (Map.Entry<String, String> e : ev.entrySet()) {
            result[i++] = e.getKey() + '=' + e.getValue();
        }
        return result;
    }

    protected Thread drainStdOut(Process p) {
        final BufferedInputStream out = new BufferedInputStream(p.getInputStream(), 32768);
        Drainer result = new Drainer(p){

            @Override
            void drain() throws IOException {
                Launcher.drainAndPrint(out, System.out);
            }

            @Override
            void blockingDrain() throws IOException {
                Launcher.blockingDrainAndPrint(out, System.out);
            }
        };
        result.start();
        return result;
    }

    protected Drainer captureStdOut(Process p) {
        final BufferedInputStream out = new BufferedInputStream(p.getInputStream(), 32768);
        final ByteArrayOutputStream b = new ByteArrayOutputStream(32768);
        Drainer result = new Drainer(p){

            @Override
            void drain() throws IOException {
                Launcher.drainAndCatch(out, b);
            }

            @Override
            void blockingDrain() throws IOException {
                Launcher.blockingDrainAndCatch(out, b);
            }
        };
        result.setCapture(b);
        result.start();
        return result;
    }

    protected Thread drainStdErr(Process p) {
        final BufferedInputStream err = new BufferedInputStream(p.getErrorStream(), 32768);
        Drainer result = new Drainer(p){

            @Override
            void drain() throws IOException {
                Launcher.drainAndPrint(err, System.err);
            }

            @Override
            void blockingDrain() throws IOException {
                Launcher.blockingDrainAndPrint(err, System.err);
            }
        };
        result.start();
        return result;
    }

    protected Drainer captureStdErr(Process p) {
        final BufferedInputStream out = new BufferedInputStream(p.getErrorStream(), 32768);
        final ByteArrayOutputStream b = new ByteArrayOutputStream(32768);
        Drainer result = new Drainer(p){

            @Override
            void drain() throws IOException {
                Launcher.drainAndCatch(out, b);
            }

            @Override
            void blockingDrain() throws IOException {
                Launcher.blockingDrainAndCatch(out, b);
            }
        };
        result.setCapture(b);
        result.start();
        return result;
    }

    private static void drainAndPrint(BufferedInputStream s2, PrintStream p) {
        try {
            while (s2.available() > 0) {
                byte[] data = new byte[s2.available()];
                s2.read(data);
                p.print(new String(data, StandardCharsets.UTF_8));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void blockingDrainAndPrint(BufferedInputStream s2, PrintStream p) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            int next = s2.read();
            while (next != -1) {
                b.write(next);
                next = s2.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        p.print(b.toString());
    }

    private static void drainAndCatch(BufferedInputStream s2, ByteArrayOutputStream b) {
        try {
            while (s2.available() > 0) {
                byte[] data = new byte[s2.available()];
                int nRead = s2.read(data);
                b.write(data, 0, nRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void blockingDrainAndCatch(BufferedInputStream s2, ByteArrayOutputStream b) {
        try {
            int next = s2.read();
            while (next != -1) {
                b.write(next);
                next = s2.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isCaptureOutput() {
        return this.captureOutput;
    }

    public boolean isCaptureErr() {
        return this.captureErr;
    }

    public byte[] getStdOut() {
        return this.stdOut;
    }

    public byte[] getStderr() {
        return this.stdErr;
    }

    protected void setStdOut(byte[] newOutput) {
        this.stdOut = newOutput;
    }

    protected void setStdErr(byte[] newErr) {
        this.stdErr = newErr;
    }

    public byte[] getInput() {
        return this.input;
    }

    public void setInput(byte[] input) {
        this.input = input;
    }

    protected abstract class Drainer
    extends Thread {
        private static final int SLEEP_MS = 5;
        private final Process p;
        private ByteArrayOutputStream capture;

        abstract void drain() throws IOException;

        abstract void blockingDrain() throws IOException;

        Drainer(Process p) {
            this.p = p;
        }

        @Override
        public void run() {
            try {
                boolean repeat = true;
                while (repeat) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.drain();
                    try {
                        this.p.exitValue();
                        repeat = false;
                        this.blockingDrain();
                        if (Launcher.this.logger == null) continue;
                        Launcher.this.logger.fine("process terminated with exit code " + this.p.exitValue());
                    }
                    catch (IllegalThreadStateException e) {
                        repeat = true;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public ByteArrayOutputStream getCapture() {
            return this.capture;
        }

        public void setCapture(ByteArrayOutputStream capture) {
            this.capture = capture;
        }
    }
}

