/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.ref;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.lang.ref.WeakReference;

public class ReferenceCleanser {
    private static final float OCCUPANCY_TRIGGER = 0.5f;
    private static WeakReference<IClassHierarchy> cha;
    private static WeakReference<AnalysisCacheImpl> cache;

    public static void registerClassHierarchy(IClassHierarchy cha) {
        ReferenceCleanser.cha = new WeakReference<IClassHierarchy>(cha);
    }

    private static IClassHierarchy getClassHierarchy() {
        IClassHierarchy result = null;
        if (cha != null) {
            result = (IClassHierarchy)cha.get();
        }
        return result;
    }

    public static void registerCache(IAnalysisCacheView cache) {
        if (cache instanceof AnalysisCacheImpl) {
            ReferenceCleanser.cache = new WeakReference<AnalysisCacheImpl>((AnalysisCacheImpl)cache);
        }
    }

    private static AnalysisCacheImpl getAnalysisCache() {
        AnalysisCacheImpl result = null;
        if (cache != null) {
            result = (AnalysisCacheImpl)cache.get();
        }
        return result;
    }

    public static void clearSoftCaches() {
        IClassHierarchy cha;
        float occupancy = 1.0f - (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory();
        if (occupancy < 0.5f) {
            return;
        }
        AnalysisCacheImpl cache = ReferenceCleanser.getAnalysisCache();
        if (cache != null) {
            cache.getSSACache().wipe();
        }
        if ((cha = ReferenceCleanser.getClassHierarchy()) != null) {
            for (IClass klass : cha) {
                if (klass instanceof ShrikeClass) {
                    ShrikeClass c = (ShrikeClass)klass;
                    c.clearSoftCaches();
                    continue;
                }
                if (klass.getDeclaredMethods() == null) continue;
                for (IMethod iMethod : klass.getDeclaredMethods()) {
                    if (!(iMethod instanceof ShrikeCTMethod)) continue;
                    ((ShrikeCTMethod)iMethod).clearCaches();
                }
            }
        }
    }
}

