/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ssa.ClassLookupException;
import com.ibm.wala.util.ssa.ParameterAccessor;
import com.ibm.wala.util.ssa.SSAValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TypeSafeInstructionFactory {
    private static final boolean DEBUG = false;
    protected final JavaLanguage.JavaInstructionFactory insts;
    protected final IClassHierarchy cha;

    public TypeSafeInstructionFactory(IClassHierarchy cha) {
        this.cha = cha;
        this.insts = new JavaLanguage.JavaInstructionFactory();
    }

    public SSAAbstractInvokeInstruction InvokeInstruction(int iindex, SSAValue result, List<? extends SSAValue> params, SSAValue exception, CallSiteReference site) {
        TypeReference retType;
        TypeSafeInstructionFactory.info("Now: InvokeInstruction to {} using {}", site, params);
        if (iindex < 0) {
            throw new IllegalArgumentException("The iIndex may not be negative");
        }
        if (result == null) {
            throw new IllegalArgumentException("The result may not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("The parameter exception may not be null");
        }
        if (params == null) {
            params = Collections.emptyList();
        }
        if (site == null) {
            throw new IllegalArgumentException("The CallSite may not be null");
        }
        ParameterAccessor acc = new ParameterAccessor(site.getDeclaredTarget(), this.cha);
        if (acc.hasImplicitThis()) {
            if (params.size() != acc.getNumberOfParameters() + 1) {
                throw new IllegalArgumentException("The callee takes " + acc.getNumberOfParameters() + " + 1 (implicit this) parameters. The given parameter-list has length " + params.size() + ". They are: " + params);
            }
            if (site.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC) {
                throw new IllegalArgumentException("A function expecting an implicit this can not be invoked static.");
            }
        } else {
            if (params.size() != acc.getNumberOfParameters()) {
                throw new IllegalArgumentException("The callee takes " + acc.getNumberOfParameters() + " parameters (no implicit this).The given parameter-list has length " + params.size() + ". They are: " + params);
            }
            if (site.getInvocationCode() != IInvokeInstruction.Dispatch.STATIC) {
                throw new IllegalArgumentException("A function without implicit this can only be invoked static.");
            }
        }
        if (!this.isAssignableFrom(retType = acc.getReturnType(), result.getType())) {
            throw new IllegalArgumentException("The return-value does not stand the TypeCheck! " + retType + " is not assignable to " + result);
        }
        int[] aParams = new int[params.size()];
        if (acc.hasImplicitThis()) {
            ParameterAccessor.Parameter targetThis = acc.getThis();
            SSAValue givenThis = params.get(0);
            aParams[0] = givenThis.getNumber();
            if (!this.isAssignableFrom(givenThis.getType(), targetThis.getType())) {
                throw new IllegalArgumentException("Parameter 'this' is not assignable from\n\t" + givenThis + " to\n\t" + targetThis + "\n----------");
            }
            for (int i = 1; i < params.size(); ++i) {
                SSAValue givenParam = params.get(i);
                ParameterAccessor.Parameter targetParam = acc.getParameter(i);
                aParams[i] = givenParam.getNumber();
                if (!this.isAssignableFrom(givenParam.getType(), targetParam.getType())) {
                    throw new IllegalArgumentException("Parameter " + i + " is not assignable from " + givenParam + " to " + targetParam);
                }
                if (!result.equals(givenParam)) continue;
                throw new IllegalArgumentException(result.toString() + " can't be the result and parameter " + i + " at the same time in " + site);
            }
        } else {
            for (int i = 0; i < params.size(); ++i) {
                SSAValue givenParam = params.get(i);
                ParameterAccessor.Parameter targetParam = acc.getParameter(i + 1);
                aParams[i] = givenParam.getNumber();
                if (!this.isAssignableFrom(givenParam.getType(), targetParam.getType())) {
                    throw new IllegalArgumentException("Parameter " + (i + 1) + " is not assignable from " + givenParam + " to " + targetParam + " in call " + site);
                }
                if (!result.equals(givenParam)) continue;
                throw new IllegalArgumentException(result.toString() + " can't be the result and parameter " + i + " at the same time in " + site);
            }
        }
        result.setAssigned();
        return this.insts.InvokeInstruction(iindex, result.getNumber(), aParams, exception.getNumber(), site, null);
    }

    public SSAAbstractInvokeInstruction InvokeInstruction(int iindex, List<? extends SSAValue> params, SSAValue exception, CallSiteReference site) {
        TypeSafeInstructionFactory.info("Now: InvokeInstruction to {} using {}", site, params);
        if (iindex < 0) {
            throw new IllegalArgumentException("The iIndex may not be negative");
        }
        if (exception == null) {
            throw new IllegalArgumentException("The parameter exception may not be null");
        }
        if (params == null) {
            params = Collections.emptyList();
        }
        if (site == null) {
            throw new IllegalArgumentException("The CallSite may not be null");
        }
        ParameterAccessor acc = new ParameterAccessor(site.getDeclaredTarget(), this.cha);
        if (acc.hasImplicitThis()) {
            if (params.size() != acc.getNumberOfParameters() + 1) {
                throw new IllegalArgumentException("The callee takes " + acc.getNumberOfParameters() + " + 1 (implicit this) parameters. The given parameter-list has length " + params.size() + ". They are: " + params);
            }
            if (site.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC) {
                throw new IllegalArgumentException("A function expecting an implicit this can not be invoked static.");
            }
        } else {
            if (params.size() != acc.getNumberOfParameters()) {
                throw new IllegalArgumentException("The callee takes " + acc.getNumberOfParameters() + " parameters (no implicit this).The given parameter-list has length " + params.size() + ". They are: " + params);
            }
            if (site.getInvocationCode() != IInvokeInstruction.Dispatch.STATIC) {
                throw new IllegalArgumentException("A function without implicit this can only be invoked static.");
            }
        }
        MethodReference mRef = site.getDeclaredTarget();
        if (acc.hasReturn()) {
            throw new IllegalArgumentException("This InvokeInstruction only works on void-functions but " + mRef + " returns a value.");
        }
        int[] aParams = new int[params.size()];
        if (acc.hasImplicitThis()) {
            SSAValue givenThis = params.get(0);
            aParams[0] = givenThis.getNumber();
            for (int i = 1; i < params.size(); ++i) {
                SSAValue givenParam = params.get(i);
                ParameterAccessor.Parameter targetParam = acc.getParameter(i);
                aParams[i] = givenParam.getNumber();
                if (this.isAssignableFrom(givenParam.getType(), targetParam.getType())) continue;
                throw new IllegalArgumentException("Parameter " + i + " is not assignable from\n\t" + givenParam + " to\n\t" + targetParam + "\nin call " + site + "\n---------");
            }
        } else {
            for (int i = 0; i < params.size(); ++i) {
                SSAValue givenParam = params.get(i);
                ParameterAccessor.Parameter targetParam = acc.getParameter(i + 1);
                aParams[i] = givenParam.getNumber();
                if (this.isAssignableFrom(givenParam.getType(), targetParam.getType())) continue;
                throw new IllegalArgumentException("Parameter " + (i + 1) + " is not assignable from " + givenParam + " to " + targetParam);
            }
        }
        return this.insts.InvokeInstruction(iindex, aParams, exception.getNumber(), site, null);
    }

    public SSAReturnInstruction ReturnInstruction(int iindex, SSAValue result) {
        TypeSafeInstructionFactory.info("Now: ReturnInstruction using {}", result);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (!this.isAssignableFrom(result.getType(), result.getValidIn().getReturnType())) {
            throw new IllegalArgumentException("Return type not assignable from " + result.getType() + " to " + result.getValidIn().getReturnType());
        }
        return this.insts.ReturnInstruction(iindex, result.getNumber(), result.getType().isPrimitiveType());
    }

    public SSAGetInstruction GetInstruction(int iindex, SSAValue targetValue, SSAValue containingInstance, FieldReference field) {
        TypeSafeInstructionFactory.info("Now: Get {} from {} into {}", field, containingInstance, targetValue);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (targetValue == null) {
            throw new IllegalArgumentException("targetValue may not be null");
        }
        if (containingInstance == null) {
            throw new IllegalArgumentException("containingInstance may not be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field may not be null");
        }
        if (!TypeSafeInstructionFactory.isSuperclassOf(field.getDeclaringClass(), containingInstance.getType())) {
            throw new IllegalArgumentException("The targetInstance " + containingInstance + " is not equal or a  super-class of " + field.getDeclaringClass());
        }
        if (!this.isAssignableFrom(field.getFieldType(), targetValue.getType())) {
            throw new IllegalArgumentException("The field " + targetValue + " is not assignable from " + field);
        }
        MethodReference targetValueValidIn = targetValue.getValidIn();
        MethodReference instValidIn = containingInstance.getValidIn();
        if (targetValueValidIn != null && instValidIn != null && !targetValueValidIn.equals(instValidIn)) {
            throw new IllegalArgumentException("containingInstance " + containingInstance + "and targetValue " + targetValue + " are valid in different scopes");
        }
        targetValue.setAssigned();
        return this.insts.GetInstruction(iindex, targetValue.getNumber(), containingInstance.getNumber(), field);
    }

    public SSAGetInstruction GetInstruction(int iindex, SSAValue targetValue, FieldReference field) {
        TypeSafeInstructionFactory.info("Now: Get {} into {}", field, targetValue);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (targetValue == null) {
            throw new IllegalArgumentException("targetValue may not be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field may not be null");
        }
        if (!this.isAssignableFrom(field.getFieldType(), targetValue.getType())) {
            throw new IllegalArgumentException("The field " + targetValue + " is not assignable from " + field);
        }
        targetValue.setAssigned();
        return this.insts.GetInstruction(iindex, targetValue.getNumber(), field);
    }

    public SSAPutInstruction PutInstruction(int iindex, SSAValue targetInstance, SSAValue newValue, FieldReference field) {
        TypeSafeInstructionFactory.info("Now: Put {} to {}", newValue, field);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (targetInstance == null) {
            throw new IllegalArgumentException("targetInstance may not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("newValue may not be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field may not be null");
        }
        if (!TypeSafeInstructionFactory.isSuperclassOf(field.getDeclaringClass(), targetInstance.getType())) {
            throw new IllegalArgumentException("The targetInstance " + targetInstance + " is not equal or a  super-class of " + field.getDeclaringClass());
        }
        if (!this.isAssignableFrom(newValue.getType(), field.getFieldType())) {
            throw new IllegalArgumentException("The field " + field + " is not assignable from " + newValue);
        }
        MethodReference newValueValidIn = newValue.getValidIn();
        MethodReference instValidIn = targetInstance.getValidIn();
        if (newValueValidIn != null && instValidIn != null && !newValueValidIn.equals(instValidIn)) {
            throw new IllegalArgumentException("targetInstance " + targetInstance + "and newValue " + newValue + " are valid in different scopes");
        }
        return this.insts.PutInstruction(iindex, targetInstance.getNumber(), newValue.getNumber(), field);
    }

    public SSAPutInstruction PutInstruction(int iindex, SSAValue newValue, FieldReference field) {
        TypeSafeInstructionFactory.info("Now: Put {} to {}", newValue, field);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("newValue may not be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field may not be null");
        }
        if (!this.isAssignableFrom(newValue.getType(), field.getFieldType())) {
            throw new IllegalArgumentException("The field " + field + " is not assignable from " + newValue);
        }
        return this.insts.PutInstruction(iindex, newValue.getNumber(), field);
    }

    public SSANewInstruction NewInstruction(int iindex, SSAValue result, NewSiteReference site) {
        TypeSafeInstructionFactory.info("Now: New {}", result);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (result == null) {
            throw new IllegalArgumentException("result may not be null");
        }
        if (site == null) {
            throw new IllegalArgumentException("site may not be null");
        }
        if (!this.isAssignableFrom(site.getDeclaredType(), result.getType())) {
            throw new IllegalArgumentException("type mismatch");
        }
        result.setAssigned();
        return this.insts.NewInstruction(iindex, result.getNumber(), site);
    }

    public SSANewInstruction NewInstruction(int iindex, SSAValue result, NewSiteReference site, Collection<? extends SSAValue> params) {
        TypeSafeInstructionFactory.info("Now: New {}", result);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (result == null) {
            throw new IllegalArgumentException("result may not be null");
        }
        if (site == null) {
            throw new IllegalArgumentException("site may not be null");
        }
        if (!this.isAssignableFrom(site.getDeclaredType(), result.getType())) {
            throw new IllegalArgumentException("type mismatch");
        }
        MethodReference resultValidIn = result.getValidIn();
        int[] aParams = new int[params.size()];
        int i = 0;
        for (SSAValue sSAValue : params) {
            MethodReference paramValidIn = sSAValue.getValidIn();
            if (resultValidIn != null && paramValidIn != null && !paramValidIn.equals(resultValidIn)) {
                throw new IllegalArgumentException("The parameter " + sSAValue + " is valid in another scope than" + result);
            }
            aParams[i] = sSAValue.getNumber();
            ++i;
        }
        result.setAssigned();
        return this.insts.NewInstruction(iindex, result.getNumber(), site, aParams);
    }

    public SSAPhiInstruction PhiInstruction(int iindex, SSAValue result, Collection<? extends SSAValue> params) {
        TypeSafeInstructionFactory.info("Now: Phi into {} from {}", result, params);
        if (iindex < 0) {
            throw new IllegalArgumentException("iIndex may not be negative");
        }
        if (result == null) {
            throw new IllegalArgumentException("result may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params may not be null");
        }
        if (params.size() < 1) {
            throw new IllegalArgumentException("Phi needs at least one source value. Type is " + result.getType());
        }
        MethodReference resultValidIn = result.getValidIn();
        TypeReference resultType = result.getType();
        int[] aParams = new int[params.size()];
        int i = 0;
        for (SSAValue sSAValue : params) {
            MethodReference paramValidIn = sSAValue.getValidIn();
            if (resultValidIn != null && paramValidIn != null && !paramValidIn.equals(resultValidIn)) {
                throw new IllegalArgumentException("The parameter " + sSAValue + " is valid in another scope than" + result);
            }
            if (!this.isAssignableFrom(sSAValue.getType(), resultType)) {
                throw new IllegalArgumentException("Param " + sSAValue + " is not assignable to " + result);
            }
            if (result.equals(sSAValue)) {
                throw new IllegalArgumentException("Cannot phi to myself: " + result);
            }
            aParams[i] = sSAValue.getNumber();
            ++i;
        }
        result.setAssigned();
        return this.insts.PhiInstruction(iindex, result.getNumber(), aParams);
    }

    private static boolean isSuperclassOf(TypeReference superClass, TypeReference subClass) {
        return true;
    }

    public boolean isAssignableFrom(TypeReference from, TypeReference to) {
        try {
            return ParameterAccessor.isAssignable(from, to, this.cha);
        }
        catch (ClassLookupException e) {
            return true;
        }
    }

    public SSAReturnInstruction ReturnInstruction(int iindex) {
        if (iindex < 0) {
            throw new IllegalArgumentException("The iindex may not be negative");
        }
        return this.insts.ReturnInstruction(iindex);
    }

    public SSAGotoInstruction GotoInstruction(int iindex, int target) {
        if (iindex < 0) {
            throw new IllegalArgumentException("The iindex may not be negative");
        }
        if (target < 0) {
            throw new IllegalArgumentException("The target-iindex may not be negative");
        }
        return this.insts.GotoInstruction(iindex, target);
    }

    public SSAConditionalBranchInstruction ConditionalBranchInstruction(int iindex, IConditionalBranchInstruction.IOperator operator, TypeReference type, int val1, int val2, int target) {
        return this.insts.ConditionalBranchInstruction(iindex, operator, type, val1, val2, target);
    }

    public SSAArrayLoadInstruction ArrayLoadInstruction(int iindex, SSAValue result, SSAValue array, int index) {
        if (iindex < 0) {
            throw new IllegalArgumentException("The iindex may not be negative. It's " + iindex);
        }
        if (result == null) {
            throw new IllegalArgumentException("Can't use null for the result");
        }
        if (array == null) {
            throw new IllegalArgumentException("Can't load from array null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("The index in the array may not be negative. It's " + index);
        }
        if (!array.getType().isArrayType()) {
            throw new IllegalArgumentException("The array to read from is expected to be ... well ... an array. The given value was " + array);
        }
        TypeReference innerType = array.getType().getArrayElementType();
        if (!this.isAssignableFrom(innerType, result.getType())) {
            throw new IllegalArgumentException("Can't assign from an array of " + innerType.getName() + " to " + result.getType().getName());
        }
        result.setAssigned();
        return this.insts.ArrayLoadInstruction(iindex, result.getNumber(), array.getNumber(), index, innerType);
    }

    public SSAArrayStoreInstruction ArrayStoreInstruction(int iindex, SSAValue array, int index, SSAValue value) {
        if (iindex < 0) {
            throw new IllegalArgumentException("The iindex may not be negative. It's " + iindex);
        }
        if (value == null) {
            throw new IllegalArgumentException("Can't use null for the value to put");
        }
        if (array == null) {
            throw new IllegalArgumentException("Can't write to array null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("The index in the array may not be negative. It's " + index);
        }
        if (!array.getType().isArrayType()) {
            throw new IllegalArgumentException("The array to write to is expected to be ... well ... an array. The given value was " + array);
        }
        TypeReference innerType = array.getType().getArrayElementType();
        if (!this.isAssignableFrom(value.getType(), innerType)) {
            throw new IllegalArgumentException("Can't assign to an array of " + innerType.getName() + " from " + value.getType().getName());
        }
        return this.insts.ArrayStoreInstruction(iindex, array.getNumber(), index, value.getNumber(), innerType);
    }

    private static void info(String s2, Object ... args) {
    }
}

