/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.io.UTFDataFormatException;

public abstract class UTF8Convert {
    static final boolean STRICTLY_CHECK_FORMAT = false;
    static final boolean ALLOW_NORMAL_UTF8 = false;
    static final boolean ALLOW_PSEUDO_UTF8 = true;
    static final boolean WRITE_PSEUDO_UTF8 = true;

    public static String fromUTF8(byte[] utf8) throws UTFDataFormatException {
        if (utf8 == null) {
            throw new IllegalArgumentException("utf8 is null");
        }
        char[] result = new char[utf8.length];
        int result_index = 0;
        int i = 0;
        int n = utf8.length;
        while (i < n) {
            byte b;
            if ((b = utf8[i++]) >= 0) {
                result[result_index++] = (char)b;
                continue;
            }
            try {
                byte nb = utf8[i++];
                if (b < -32) {
                    int n2 = result_index++;
                    char c = (char)((b & 0x1F) << 6 | nb & 0x3F);
                    result[n2] = c;
                    char c2 = c;
                    continue;
                }
                byte nnb = utf8[i++];
                int n3 = result_index++;
                char c = (char)((b & 0xF) << 12 | (nb & 0x3F) << 6 | nnb & 0x3F);
                result[n3] = c;
                char c3 = c;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new UTFDataFormatException("unexpected end at location " + i);
            }
        }
        return new String(result, 0, result_index);
    }

    public static byte[] toUTF8(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] result = new byte[UTF8Convert.utfLength(s2)];
        int result_index = 0;
        int n = s2.length();
        for (int i = 0; i < n; ++i) {
            char c = s2.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                result[result_index++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                result[result_index++] = (byte)(0xE0 | (byte)(c >> 12));
                result[result_index++] = (byte)(0x80 | (c & 0xFC0) >> 6);
                result[result_index++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            result[result_index++] = (byte)(0xC0 | (byte)(c >> 6));
            result[result_index++] = (byte)(0x80 | c & 0x3F);
        }
        return result;
    }

    public static int utfLength(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        int utflen = 0;
        int n = s2.length();
        for (int i = 0; i < n; ++i) {
            char c = s2.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static boolean check(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        int i = 0;
        int n = bytes.length;
        while (i < n) {
            byte b;
            if ((b = bytes[i++]) == 0) {
                return false;
            }
            if (b >= 0) continue;
            try {
                byte nb = bytes[i++];
                if (b < -32) {
                    char c = (char)((b & 0x1F) << 6 | nb & 0x3F);
                    if ((b & 0xE0) != 192 || (nb & 0xC0) != 128) {
                        return false;
                    }
                    if (!(c < '\u0080' ? c != '\u0000' : c > '\u07ff')) continue;
                    return false;
                }
                byte nnb = bytes[i++];
                char c = (char)((b & 0xF) << 12 | (nb & 0x3F) << 6 | nnb & 0x3F);
                if ((b & 0xF0) != 224 || (nb & 0xC0) != 128 || (nnb & 0xC0) != 128) {
                    return false;
                }
                if (c >= '\u0800') continue;
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
        }
        return true;
    }

    public static String fromUTF8(ImmutableByteArray s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("s is null");
        }
        try {
            return UTF8Convert.fromUTF8(s2.b);
        }
        catch (UTFDataFormatException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

