/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.cfg.CFGSanitizer;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import com.ibm.wala.viz.PDFViewLauncher;
import java.util.HashMap;

public class PDFViewUtil {
    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String pdfFile, String dotFile, String dotExe, String pdfViewExe) throws WalaException {
        return PDFViewUtil.ghostviewIR(cha, ir, pdfFile, dotFile, dotExe, pdfViewExe, null);
    }

    public static Process ghostviewIR(IClassHierarchy cha, IR ir, String pdfFile, String dotFile, String dotExe, String pdfViewExe, NodeDecorator<ISSABasicBlock> annotations) throws WalaException {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        Graph<ISSABasicBlock> g2 = ir.getControlFlowGraph();
        NodeDecorator<ISSABasicBlock> labels = PDFViewUtil.makeIRDecorator(ir);
        if (annotations != null) {
            labels = new ConcatenatingNodeDecorator<ISSABasicBlock>(annotations, labels);
        }
        g2 = CFGSanitizer.sanitize(ir, cha);
        DotUtil.dotify(g2, labels, dotFile, pdfFile, dotExe);
        return PDFViewUtil.launchPDFView(pdfFile, pdfViewExe);
    }

    public static NodeDecorator<ISSABasicBlock> makeIRDecorator(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        HashMap<SSACFG.BasicBlock, String> labelMap = HashMapFactory.make();
        for (ISSABasicBlock issaBasicBlock : ir.getControlFlowGraph()) {
            SSACFG.BasicBlock bb = (SSACFG.BasicBlock)issaBasicBlock;
            labelMap.put(bb, PDFViewUtil.getNodeLabel(ir, bb));
        }
        NodeDecorator<ISSABasicBlock> labels = labelMap::get;
        return labels;
    }

    private static String getNodeLabel(IR ir, SSACFG.BasicBlock bb) {
        StringBuilder result = new StringBuilder();
        int start = bb.getFirstInstructionIndex();
        int end = bb.getLastInstructionIndex();
        result.append("BB").append(bb.getNumber());
        if (bb.isEntryBlock()) {
            result.append(" (en)\\n");
        } else if (bb.isExitBlock()) {
            result.append(" (ex)\\n");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            result.append("<Handler>");
        }
        result.append("\\n");
        for (SSAPhiInstruction phi : Iterator2Iterable.make(bb.iteratePhis())) {
            if (phi == null) continue;
            result.append("           ").append(phi.toString(ir.getSymbolTable())).append("\\l");
        }
        if (bb instanceof SSACFG.ExceptionHandlerBasicBlock) {
            SSACFG.ExceptionHandlerBasicBlock ebb = (SSACFG.ExceptionHandlerBasicBlock)bb;
            SSAGetCaughtExceptionInstruction s2 = ebb.getCatchInstruction();
            if (s2 != null) {
                result.append("           ").append(s2.toString(ir.getSymbolTable())).append("\\l");
            } else {
                result.append("            No catch instruction. Unreachable?\\l");
            }
        }
        SSAInstruction[] instructions = ir.getInstructions();
        for (int j = start; j <= end; ++j) {
            if (instructions[j] == null) continue;
            StringBuilder x = new StringBuilder(j + "   " + instructions[j].toString(ir.getSymbolTable()));
            StringStuff.padWithSpaces(x, 35);
            result.append((CharSequence)x);
            result.append("\\l");
        }
        for (SSAPiInstruction pi : Iterator2Iterable.make(bb.iteratePis())) {
            if (pi == null) continue;
            result.append("           ").append(pi.toString(ir.getSymbolTable())).append("\\l");
        }
        return result.toString();
    }

    public static Process launchPDFView(String pdfFile, String gvExe) throws WalaException {
        if (gvExe == null) {
            throw new IllegalArgumentException("null gvExe");
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException("null psFile");
        }
        PDFViewLauncher gv = new PDFViewLauncher();
        gv.setGvExe(gvExe);
        gv.setPDFFile(pdfFile);
        gv.run();
        if (gv.getProcess() == null) {
            throw new WalaException(" problem spawning process ");
        }
        return gv.getProcess();
    }

    private static final class ConcatenatingNodeDecorator<T>
    implements NodeDecorator<T> {
        private final NodeDecorator<T> A;
        private final NodeDecorator<T> B;

        ConcatenatingNodeDecorator(NodeDecorator<T> A2, NodeDecorator<T> B) {
            this.A = A2;
            this.B = B;
        }

        @Override
        public String getLabel(T n) throws WalaException {
            return this.A.getLabel(n) + this.B.getLabel(n);
        }
    }
}

