/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.viz.viewer.DualTreeCellRenderer;
import com.ibm.wala.viz.viewer.IrAndSourceViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PaPanel
extends JSplitPane {
    private static final long serialVersionUID = 8120735305334110889L;
    protected final PointerAnalysis<InstanceKey> pa;
    protected final CallGraph cg;
    private JTextField fullName;
    private IrAndSourceViewer irViewer;
    private final MutableMapping<List<LocalPointerKey>> cgNodeIdToLocalPointers = MutableMapping.make();
    private final MutableMapping<List<ReturnValueKey>> cgNodeIdToReturnValue = MutableMapping.make();
    private final MutableMapping<List<InstanceFieldPointerKey>> instanceKeyIdToInstanceFieldPointers = MutableMapping.make();

    public PaPanel(CallGraph cg, PointerAnalysis<InstanceKey> pa) {
        super(1);
        this.pa = pa;
        this.cg = cg;
        this.initDataStructures(pa);
    }

    public void init() {
        this.setDividerLocation(250);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Object rootChildNode : this.getRootNodes()) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(rootChildNode);
            root.add(n);
            this.expandNodeRec(n, 1);
        }
        JTree heapTree = new JTree(root);
        heapTree.setCellRenderer(new DualTreeCellRenderer());
        this.setLeftComponent(new JScrollPane(heapTree));
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.setRightComponent(rightPanel);
        this.fullName = new JTextField("");
        rightPanel.add((Component)this.fullName, "First");
        this.irViewer = new IrAndSourceViewer();
        rightPanel.add(this.irViewer.getComponent(), "Center");
        heapTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                PaPanel.this.expandNodeRec(lastNode, 2);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        heapTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
                if (null == newLeadSelectionPath) {
                    return;
                }
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)newLeadSelectionPath.getLastPathComponent();
                Object userObject = treeNode.getUserObject();
                PaPanel.this.fullName.setText(userObject.toString());
                if (userObject instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)userObject;
                    IR ir1 = lpk.getNode().getIR();
                    SSAInstruction def = lpk.getNode().getDU().getDef(lpk.getValueNumber());
                    int pc1 = -1;
                    if (def != null) {
                        SSAInstruction[] instructions = ir1.getInstructions();
                        for (int i = 0; i < instructions.length; ++i) {
                            SSAInstruction instruction = instructions[i];
                            if (def != instruction) continue;
                            pc1 = i;
                        }
                    }
                    PaPanel.this.irViewer.setIRAndPc(ir1, pc1);
                } else if (userObject instanceof InstanceFieldPointerKey) {
                    InstanceKey ik = ((InstanceFieldPointerKey)userObject).getInstanceKey();
                    if (ik instanceof NormalAllocationInNode) {
                        NormalAllocationInNode normalIk1 = (NormalAllocationInNode)ik;
                        IR ir2 = normalIk1.getNode().getIR();
                        int pc2 = normalIk1.getSite().getProgramCounter();
                        PaPanel.this.irViewer.setIRAndPc(ir2, pc2);
                    }
                } else if (userObject instanceof NormalAllocationInNode) {
                    NormalAllocationInNode normalIk2 = (NormalAllocationInNode)userObject;
                    IR ir3 = normalIk2.getNode().getIR();
                    int pc3 = normalIk2.getSite().getProgramCounter();
                    PaPanel.this.irViewer.setIRAndPc(ir3, pc3);
                } else if (userObject instanceof CGNode) {
                    PaPanel.this.irViewer.setIR(((CGNode)userObject).getIR());
                }
            }
        });
    }

    private void initDataStructures(PointerAnalysis<InstanceKey> pa) {
        HeapGraph<InstanceKey> heapGraph = pa.getHeapGraph();
        OrdinalSetMapping<InstanceKey> instanceKeyMapping = pa.getInstanceKeyMapping();
        for (Object t : heapGraph) {
            if (heapGraph.getPredNodeCount((InstanceKey)t) != 0) continue;
            if (t instanceof PointerKey) {
                int nodeId;
                if (t instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)t;
                    nodeId = lpk.getNode().getGraphNodeId();
                    PaPanel.mapUsingMutableMapping(this.cgNodeIdToLocalPointers, nodeId, lpk);
                    continue;
                }
                if (t instanceof ReturnValueKey) {
                    ReturnValueKey rvk = (ReturnValueKey)t;
                    nodeId = rvk.getNode().getGraphNodeId();
                    PaPanel.mapUsingMutableMapping(this.cgNodeIdToReturnValue, nodeId, rvk);
                    continue;
                }
                if (!(t instanceof InstanceFieldPointerKey)) continue;
                InstanceFieldPointerKey ifpk = (InstanceFieldPointerKey)t;
                int instanceKeyId = instanceKeyMapping.getMappedIndex(ifpk.getInstanceKey());
                PaPanel.mapUsingMutableMapping(this.instanceKeyIdToInstanceFieldPointers, instanceKeyId, ifpk);
                continue;
            }
            System.err.println("Non Pointer key root: " + t);
        }
    }

    protected List<Object> getRootNodes() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (CGNode n : this.cg) {
            ret.add(n);
        }
        return ret;
    }

    private void expandNodeRec(DefaultMutableTreeNode treeNode, int rec) {
        if (rec == 0) {
            return;
        }
        if (treeNode.getChildCount() == 0) {
            List<Object> children = this.getChildrenFor(treeNode.getUserObject());
            for (Object child : children) {
                treeNode.add(new DefaultMutableTreeNode(child));
            }
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode child = treeNode.getChildAt(i);
            this.expandNodeRec((DefaultMutableTreeNode)child, rec - 1);
        }
    }

    protected List<Object> getChildrenFor(Object node) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (node instanceof InstanceKey) {
            ret.addAll(this.getPointerKeysUnderInstanceKey((InstanceKey)node));
        } else if (node instanceof PointerKey) {
            for (InstanceKey ik : this.pa.getPointsToSet((PointerKey)node)) {
                ret.add(ik);
            }
        } else if (node instanceof CGNode) {
            int nodeId = ((CGNode)node).getGraphNodeId();
            ret.addAll(this.nonNullList(this.cgNodeIdToLocalPointers.getMappedObject(nodeId)));
            ret.addAll(this.nonNullList(this.cgNodeIdToReturnValue.getMappedObject(nodeId)));
        } else assert (false) : "Unhandled Node : " + node;
        return ret;
    }

    protected List<? extends PointerKey> getPointerKeysUnderInstanceKey(InstanceKey ik) {
        int ikIndex = this.pa.getInstanceKeyMapping().getMappedIndex(ik);
        List<Object> ret = ikIndex <= this.instanceKeyIdToInstanceFieldPointers.getMaximumIndex() ? this.nonNullList(this.instanceKeyIdToInstanceFieldPointers.getMappedObject(ikIndex)) : Collections.emptyList();
        return ret;
    }

    protected static <T> void mapUsingMutableMapping(MutableMapping<List<T>> map, int index, T o) {
        List<T> set = index <= map.getMaximumIndex() ? map.getMappedObject(index) : null;
        if (null == set) {
            set = new ArrayList<T>();
            map.put(index, set);
        }
        set.add(o);
    }

    protected <T> List<T> nonNullList(List<T> l) {
        if (null == l) {
            return Collections.emptyList();
        }
        return l;
    }
}

