/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.frontend;

import com.google.common.base.Objects;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.AbstractClass;
import sootup.core.model.SootClass;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;

public abstract class AbstractClassSource<T extends AbstractClass> {
    protected final AnalysisInputLocation<? extends SootClass<?>> classSource;
    protected final Path sourcePath;
    protected ClassType classSignature;

    public AbstractClassSource(@Nonnull AnalysisInputLocation<? extends SootClass<?>> classSource, @Nonnull ClassType classSignature, @Nonnull Path sourcePath) {
        this.classSource = classSource;
        this.classSignature = classSignature;
        this.sourcePath = sourcePath;
    }

    public abstract T buildClass(@Nonnull SourceType var1);

    public ClassType getClassType() {
        return this.classSignature;
    }

    public AnalysisInputLocation<? extends SootClass<?>> getClassSource() {
        return this.classSource;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractClassSource that = (AbstractClassSource)o;
        return Objects.equal(this.classSource, that.classSource) && Objects.equal(this.sourcePath, that.sourcePath);
    }

    public int hashCode() {
        return Objects.hashCode(this.classSource, this.sourcePath);
    }
}

