/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.frontend;

import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.frontend.ResolveException;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;
import sootup.core.util.CollectionUtils;

public class OverridingClassSource
extends SootClassSource {
    @Nullable
    private final Collection<SootMethod> overriddenSootMethods;
    @Nullable
    private final Collection<SootField> overriddenSootFields;
    @Nullable
    private final Set<Modifier> overriddenModifiers;
    @Nullable
    private final Set<ClassType> overriddenInterfaces;
    @Nullable
    private final Optional<ClassType> overriddenSuperclass;
    @Nullable
    private final Optional<ClassType> overriddenOuterClass;
    @Nullable
    private final Position position;
    @Nullable
    private final SootClassSource delegate;

    public OverridingClassSource(@Nonnull SootClassSource delegate) {
        super(delegate);
        this.delegate = delegate;
        this.overriddenSootMethods = null;
        this.overriddenSootFields = null;
        this.overriddenModifiers = null;
        this.overriddenInterfaces = null;
        this.overriddenSuperclass = null;
        this.overriddenOuterClass = null;
        this.position = null;
    }

    private OverridingClassSource(@Nullable Collection<SootMethod> overriddenSootMethods, @Nullable Collection<SootField> overriddenSootFields, @Nullable Set<Modifier> overriddenModifiers, @Nullable Set<ClassType> overriddenInterfaces, @Nullable Optional<ClassType> overriddenSuperclass, @Nullable Optional<ClassType> overriddenOuterClass, @Nullable Position position, @Nonnull SootClassSource delegate) {
        super(delegate);
        this.overriddenSootMethods = overriddenSootMethods;
        this.overriddenSootFields = overriddenSootFields;
        this.overriddenModifiers = overriddenModifiers;
        this.overriddenInterfaces = overriddenInterfaces;
        this.overriddenSuperclass = overriddenSuperclass;
        this.overriddenOuterClass = overriddenOuterClass;
        this.position = position;
        this.delegate = delegate;
    }

    public OverridingClassSource(@Nonnull Set<SootMethod> sootMethods, @Nonnull Set<SootField> sootFields, @Nonnull EnumSet<Modifier> modifiers, @Nonnull Set<ClassType> interfaces, @Nonnull ClassType superClass, @Nonnull ClassType outerClass, @Nonnull Position position, @Nonnull Path sourcePath, @Nonnull ClassType classType, @Nonnull AnalysisInputLocation srcNamespace) {
        super(srcNamespace, classType, sourcePath);
        this.delegate = null;
        this.overriddenSootMethods = sootMethods;
        this.overriddenSootFields = sootFields;
        this.overriddenModifiers = modifiers;
        this.overriddenInterfaces = interfaces;
        this.overriddenSuperclass = Optional.ofNullable(superClass);
        this.overriddenOuterClass = Optional.ofNullable(outerClass);
        this.position = position;
    }

    @Override
    @Nonnull
    public Collection<? extends SootMethod> resolveMethods() throws ResolveException {
        return this.overriddenSootMethods != null ? this.overriddenSootMethods : this.delegate.resolveMethods();
    }

    @Override
    @Nonnull
    public Collection<? extends SootField> resolveFields() throws ResolveException {
        return this.overriddenSootFields != null ? this.overriddenSootFields : this.delegate.resolveFields();
    }

    @Override
    @Nonnull
    public Set<Modifier> resolveModifiers() {
        return this.overriddenModifiers != null ? this.overriddenModifiers : this.delegate.resolveModifiers();
    }

    @Nonnull
    public Set<ClassType> resolveInterfaces() {
        return this.overriddenInterfaces != null ? this.overriddenInterfaces : this.delegate.resolveInterfaces();
    }

    @Nonnull
    public Optional<ClassType> resolveSuperclass() {
        return this.overriddenSuperclass != null ? this.overriddenSuperclass : this.delegate.resolveSuperclass();
    }

    @Override
    @Nonnull
    public Optional<? extends ClassType> resolveOuterClass() {
        return this.overriddenOuterClass != null ? this.overriddenOuterClass : this.delegate.resolveOuterClass();
    }

    @Override
    @Nonnull
    public Position resolvePosition() {
        return this.position != null ? this.position : this.delegate.resolvePosition();
    }

    @Override
    public SootClass<?> buildClass(@Nonnull SourceType sourceType) {
        return new SootClass<OverridingClassSource>(this, sourceType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverridingClassSource that = (OverridingClassSource)o;
        return Objects.equals(this.overriddenSuperclass, that.overriddenSuperclass) && Objects.equals(this.overriddenInterfaces, that.overriddenInterfaces) && Objects.equals(this.overriddenOuterClass, that.overriddenOuterClass) && Objects.equals(this.overriddenSootFields, that.overriddenSootFields) && Objects.equals(this.overriddenSootMethods, that.overriddenSootMethods) && Objects.equals(this.position, that.position) && Objects.equals(this.overriddenModifiers, that.overriddenModifiers) && Objects.equals(this.classSignature, that.classSignature);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.overriddenSuperclass, this.overriddenInterfaces, this.overriddenOuterClass, this.overriddenSootFields, this.overriddenSootMethods, this.position, this.overriddenModifiers, this.classSignature);
    }

    public String toString() {
        return "frontend.OverridingClassSource{superClass=" + this.overriddenSuperclass + ", interfaces=" + this.overriddenInterfaces + ", outerClass=" + this.overriddenOuterClass + ", sootFields=" + this.overriddenSootFields + ", sootMethods=" + this.overriddenSootMethods + ", position=" + this.position + ", modifiers=" + this.overriddenModifiers + ", classType=" + this.classSignature + '}';
    }

    @Nonnull
    public OverridingClassSource withReplacedMethod(@Nonnull SootMethod toReplace, @Nonnull SootMethod replacement) {
        HashSet<SootMethod> newMethods = new HashSet<SootMethod>(this.resolveMethods());
        CollectionUtils.replace(newMethods, toReplace, replacement);
        return this.withMethods(newMethods);
    }

    @Nonnull
    public OverridingClassSource withMethods(@Nonnull Collection<SootMethod> overriddenSootMethods) {
        return new OverridingClassSource(overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.delegate);
    }

    @Nonnull
    public OverridingClassSource withReplacedField(@Nonnull SootField toReplace, @Nonnull SootField replacement) {
        HashSet<SootField> newFields = new HashSet<SootField>(this.resolveFields());
        CollectionUtils.replace(newFields, toReplace, replacement);
        return this.withFields(newFields);
    }

    @Nonnull
    public OverridingClassSource withFields(@Nonnull Collection<SootField> overriddenSootFields) {
        return new OverridingClassSource(this.overriddenSootMethods, overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.delegate);
    }

    @Nonnull
    public OverridingClassSource withModifiers(@Nonnull Set<Modifier> overriddenModifiers) {
        return new OverridingClassSource(this.overriddenSootMethods, this.overriddenSootFields, overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.delegate);
    }

    @Nonnull
    public OverridingClassSource withInterfaces(@Nonnull Set<ClassType> overriddenInterfaces) {
        return new OverridingClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, this.position, this.delegate);
    }

    @Nonnull
    public OverridingClassSource withSuperclass(@Nonnull Optional<ClassType> overriddenSuperclass) {
        return new OverridingClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, overriddenSuperclass, this.overriddenOuterClass, this.position, this.delegate);
    }

    @Nonnull
    public OverridingClassSource withOuterClass(@Nonnull Optional<ClassType> overriddenOuterClass) {
        return new OverridingClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, overriddenOuterClass, this.position, this.delegate);
    }

    @Nonnull
    public OverridingClassSource withPosition(@Nullable Position position) {
        return new OverridingClassSource(this.overriddenSootMethods, this.overriddenSootFields, this.overriddenModifiers, this.overriddenInterfaces, this.overriddenSuperclass, this.overriddenOuterClass, position, this.delegate);
    }
}

