/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.graph;

import com.google.common.collect.Iterators;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.BasicBlock;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JReturnVoidStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.types.ClassType;
import sootup.core.util.DotExporter;
import sootup.core.util.EscapedWriter;
import sootup.core.util.printer.JimplePrinter;

public abstract class StmtGraph<V extends BasicBlock<V>>
implements Iterable<Stmt> {
    public abstract Stmt getStartingStmt();

    public abstract BasicBlock<?> getStartingStmtBlock();

    @Nonnull
    public abstract Collection<Stmt> nodes();

    public List<Stmt> getStmts() {
        ArrayList<Stmt> res = new ArrayList<Stmt>();
        Iterators.addAll(res, this.iterator());
        return res;
    }

    @Nonnull
    public abstract Collection<? extends BasicBlock<?>> getBlocks();

    @Nonnull
    public abstract List<? extends BasicBlock<?>> getBlocksSorted();

    public Iterator<BasicBlock<?>> getBlockIterator() {
        return new BlockGraphIterator();
    }

    public abstract BasicBlock<?> getBlockOf(@Nonnull Stmt var1);

    public abstract boolean containsNode(@Nonnull Stmt var1);

    @Nonnull
    public abstract List<Stmt> predecessors(@Nonnull Stmt var1);

    @Nonnull
    public abstract List<Stmt> exceptionalPredecessors(@Nonnull Stmt var1);

    @Nonnull
    public abstract List<Stmt> successors(@Nonnull Stmt var1);

    @Nonnull
    public abstract Map<ClassType, Stmt> exceptionalSuccessors(@Nonnull Stmt var1);

    @Nonnull
    public List<Stmt> getAllSuccessors(@Nonnull Stmt stmt) {
        List<Stmt> successors = this.successors(stmt);
        Map<ClassType, Stmt> exSuccessors = this.exceptionalSuccessors(stmt);
        ArrayList<Stmt> allSuccessors = new ArrayList<Stmt>(successors.size() + exSuccessors.size());
        allSuccessors.addAll(successors);
        allSuccessors.addAll(exSuccessors.values());
        return allSuccessors;
    }

    public abstract int inDegree(@Nonnull Stmt var1);

    public abstract int outDegree(@Nonnull Stmt var1);

    public int degree(@Nonnull Stmt node) {
        return this.inDegree(node) + this.outDegree(node);
    }

    public abstract boolean hasEdgeConnecting(@Nonnull Stmt var1, @Nonnull Stmt var2);

    @Deprecated
    public abstract List<Trap> getTraps();

    @Nonnull
    public List<Stmt> getTails() {
        return this.nodes().stream().filter(stmt -> stmt.getExpectedSuccessorCount() == 0).collect(Collectors.toList());
    }

    @Nonnull
    public Collection<Stmt> getEntrypoints() {
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        stmts.add(this.getStartingStmt());
        this.getTraps().stream().map(Trap::getHandlerStmt).forEach(stmts::add);
        return stmts;
    }

    public void validateStmtConnectionsInGraph() {
        try {
            for (Stmt stmt : this.nodes()) {
                List<Stmt> successors = this.successors(stmt);
                int successorCount = successors.size();
                if (this.predecessors(stmt).size() == 0 && stmt != this.getStartingStmt() && !this.getTraps().stream().map(Trap::getHandlerStmt).anyMatch(handler -> handler == stmt)) {
                    throw new IllegalStateException("Stmt '" + stmt + "' which is neither the StartingStmt nor a TrapHandler is missing a predecessor!");
                }
                if (stmt instanceof BranchingStmt) {
                    for (Stmt target : successors) {
                        if (target != stmt) continue;
                        throw new IllegalStateException(stmt + ": a Stmt cannot branch to itself.");
                    }
                    if (stmt instanceof JSwitchStmt) {
                        if (successorCount == ((JSwitchStmt)stmt).getValueCount()) continue;
                        throw new IllegalStateException(stmt + ": size of outgoing flows (i.e. " + successorCount + ") does not match the amount of switch statements case labels (i.e. " + ((JSwitchStmt)stmt).getValueCount() + ").");
                    }
                    if (stmt instanceof JIfStmt) {
                        if (successorCount == 2) continue;
                        throw new IllegalStateException(stmt + ": If must have '2' outgoing flow but has '" + successorCount + "'.");
                    }
                    if (!(stmt instanceof JGotoStmt) || successorCount == 1) continue;
                    throw new IllegalStateException(stmt + ": Goto must have '1' outgoing flow but has '" + successorCount + "'.");
                }
                if (stmt instanceof JReturnStmt || stmt instanceof JReturnVoidStmt || stmt instanceof JThrowStmt) {
                    if (successorCount == 0) continue;
                    throw new IllegalStateException(stmt + ": must have '0' outgoing flow but has '" + successorCount + "'.");
                }
                if (successorCount == 1) continue;
                throw new IllegalStateException(stmt + ": must have '1' outgoing flow but has '" + successorCount + "'.");
            }
        }
        catch (Exception e) {
            String urlToWebeditor = DotExporter.createUrlToWebeditor(this);
            throw new IllegalStateException("visualize invalid StmtGraph: " + urlToWebeditor, e);
        }
    }

    @Nullable
    public List<Stmt> getExtendedBasicBlockPathBetween(@Nonnull Stmt from, @Nonnull Stmt to) {
        if (this.inDegree(to) > 1) {
            return null;
        }
        ArrayList<Stmt> pathStack = new ArrayList<Stmt>();
        ArrayList<Integer> pathStackIndex = new ArrayList<Integer>();
        pathStack.add(from);
        pathStackIndex.add(0);
        int psiMax = this.outDegree((Stmt)pathStack.get(0));
        int level = 0;
        while ((Integer)pathStackIndex.get(0) != psiMax) {
            List<Stmt> succs;
            int p = (Integer)pathStackIndex.get(level);
            if (p >= (succs = this.successors((Stmt)pathStack.get(level))).size()) {
                pathStack.remove(level);
                pathStackIndex.remove(level);
                int q = (Integer)pathStackIndex.get(--level);
                pathStackIndex.set(level, q + 1);
                continue;
            }
            Stmt betweenStmt = succs.get(p);
            if (betweenStmt == to) {
                pathStack.add(to);
                return pathStack;
            }
            if (this.inDegree(betweenStmt) > 1) {
                pathStackIndex.set(level, p + 1);
                continue;
            }
            ++level;
            pathStackIndex.add(0);
            pathStack.add(betweenStmt);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StmtGraph)) {
            return false;
        }
        StmtGraph otherGraph = (StmtGraph)o;
        if (this.getStartingStmt() != otherGraph.getStartingStmt()) {
            return false;
        }
        Collection<Stmt> nodes = this.nodes();
        Collection<Stmt> otherNodes = otherGraph.nodes();
        if (nodes.size() != otherNodes.size()) {
            return false;
        }
        if (!this.getTraps().equals(otherGraph.getTraps())) {
            return false;
        }
        for (Stmt node : nodes) {
            List<Stmt> otherSuccessors;
            if (!otherNodes.contains(node)) {
                return false;
            }
            List<Stmt> successors = this.successors(node);
            if (successors.equals(otherSuccessors = otherGraph.successors(node))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Iterator<Stmt> iterator() {
        return new BlockStmtGraphIterator();
    }

    public List<Stmt> getBranchTargetsOf(BranchingStmt fromStmt) {
        List<Stmt> successors = this.successors(fromStmt);
        if (fromStmt instanceof JIfStmt) {
            return Collections.singletonList(successors.get(1));
        }
        return successors;
    }

    public boolean isStmtBranchTarget(@Nonnull Stmt targetStmt) {
        Stmt pred;
        List<Stmt> predecessors = this.predecessors(targetStmt);
        if (predecessors.size() > 1) {
            return true;
        }
        Iterator<Stmt> iterator = predecessors.iterator();
        if (iterator.hasNext() && (pred = iterator.next()).branches()) {
            if (pred instanceof JIfStmt) {
                return this.getBranchTargetsOf((JIfStmt)pred).get(0) == targetStmt;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Collection<Stmt> getLabeledStmts() {
        HashSet<Stmt> stmtList = new HashSet<Stmt>();
        for (Stmt stmt : this.nodes()) {
            if (!(stmt instanceof BranchingStmt)) continue;
            if (stmt instanceof JIfStmt) {
                stmtList.add(this.getBranchTargetsOf((JIfStmt)stmt).get(0));
                continue;
            }
            if (stmt instanceof JGotoStmt) {
                stmtList.add(this.getBranchTargetsOf((JGotoStmt)stmt).get(0));
                continue;
            }
            if (!(stmt instanceof JSwitchStmt)) continue;
            stmtList.addAll(this.getBranchTargetsOf((BranchingStmt)stmt));
        }
        for (Trap trap : this.getTraps()) {
            stmtList.add(trap.getBeginStmt());
            stmtList.add(trap.getEndStmt());
            stmtList.add(trap.getHandlerStmt());
        }
        return stmtList;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try (PrintWriter writerOut = new PrintWriter(new EscapedWriter(writer));){
            new JimplePrinter(new JimplePrinter.Option[0]).printTo(this, writerOut);
        }
        return writer.toString();
    }

    public class BlockGraphIterator
    implements Iterator<BasicBlock<?>> {
        @Nonnull
        private final ArrayDeque<BasicBlock<?>> trapHandlerBlocks = new ArrayDeque();
        @Nonnull
        private final ArrayDeque<BasicBlock<?>> nestedBlocks = new ArrayDeque();
        @Nonnull
        private final ArrayDeque<BasicBlock<?>> otherBlocks = new ArrayDeque();
        @Nonnull
        private final Set<BasicBlock<?>> iteratedBlocks;

        public BlockGraphIterator() {
            Collection<BasicBlock<?>> blocks = StmtGraph.this.getBlocks();
            this.iteratedBlocks = new HashSet(blocks.size(), 1.0f);
            Stmt startingStmt = StmtGraph.this.getStartingStmt();
            if (startingStmt != null) {
                BasicBlock<?> startingBlock = StmtGraph.this.getStartingStmtBlock();
                this.updateFollowingBlocks(startingBlock);
                this.nestedBlocks.addFirst(startingBlock);
            }
        }

        @Nullable
        private BasicBlock<?> retrieveNextBlock() {
            BasicBlock<?> nextBlock;
            do {
                if (!this.nestedBlocks.isEmpty()) {
                    nextBlock = this.nestedBlocks.pollFirst();
                    continue;
                }
                if (!this.trapHandlerBlocks.isEmpty()) {
                    nextBlock = this.trapHandlerBlocks.pollFirst();
                    continue;
                }
                if (!this.otherBlocks.isEmpty()) {
                    nextBlock = this.otherBlocks.pollFirst();
                    continue;
                }
                Collection<BasicBlock<?>> blocks = StmtGraph.this.getBlocks();
                if (this.iteratedBlocks.size() < blocks.size()) {
                    for (BasicBlock<?> block : blocks) {
                        if (this.iteratedBlocks.contains(block)) continue;
                        this.nestedBlocks.addLast(block);
                    }
                    if (!this.nestedBlocks.isEmpty()) {
                        return this.nestedBlocks.pollFirst();
                    }
                }
                return null;
            } while (this.iteratedBlocks.contains(nextBlock));
            return nextBlock;
        }

        @Override
        @Nonnull
        public BasicBlock<?> next() {
            BasicBlock<?> currentBlock = this.retrieveNextBlock();
            if (currentBlock == null) {
                throw new NoSuchElementException("Iterator has no more Blocks.");
            }
            this.updateFollowingBlocks(currentBlock);
            this.iteratedBlocks.add(currentBlock);
            return currentBlock;
        }

        private void updateFollowingBlocks(BasicBlock<?> currentBlock) {
            Stmt tailStmt = currentBlock.getTail();
            for (Map.Entry<ClassType, ?> entry : currentBlock.getExceptionalSuccessors().entrySet()) {
                BasicBlock trapHandlerBlock = (BasicBlock)entry.getValue();
                this.trapHandlerBlocks.addLast(trapHandlerBlock);
                this.nestedBlocks.addFirst(trapHandlerBlock);
            }
            List<?> successors = currentBlock.getSuccessors();
            for (int i = successors.size() - 1; i >= 0; --i) {
                boolean isReturnBlock;
                BasicBlock predecessorBlock;
                List itPreds;
                BasicBlock successorBlock;
                if (i == 0 && tailStmt.fallsThrough()) {
                    this.nestedBlocks.addFirst((BasicBlock<?>)successors.get(0));
                    continue;
                }
                BasicBlock leaderOfFallsthroughBlocks = successorBlock = (BasicBlock)successors.get(i);
                while ((itPreds = leaderOfFallsthroughBlocks.getPredecessors()).size() == 1 && (predecessorBlock = (BasicBlock)itPreds.get(0)).getTail().fallsThrough() && predecessorBlock.getSuccessors().get(0) == leaderOfFallsthroughBlocks) {
                    leaderOfFallsthroughBlocks = predecessorBlock;
                }
                Stmt succTailStmt = successorBlock.getTail();
                boolean bl = isReturnBlock = succTailStmt instanceof JReturnVoidStmt || succTailStmt instanceof JReturnStmt;
                if (tailStmt instanceof JGotoStmt) {
                    if (isReturnBlock) {
                        this.nestedBlocks.removeFirstOccurrence(currentBlock.getHead());
                        this.otherBlocks.addLast(leaderOfFallsthroughBlocks);
                        continue;
                    }
                    this.otherBlocks.addFirst(leaderOfFallsthroughBlocks);
                    continue;
                }
                if (this.nestedBlocks.contains(leaderOfFallsthroughBlocks)) continue;
                if (isReturnBlock) {
                    this.nestedBlocks.addLast(leaderOfFallsthroughBlocks);
                    continue;
                }
                this.nestedBlocks.addFirst(leaderOfFallsthroughBlocks);
            }
        }

        @Override
        public boolean hasNext() {
            Collection<BasicBlock<?>> blocks;
            int actualSize;
            int returnedSize;
            boolean hasIteratorMoreElements;
            BasicBlock<?> b = this.retrieveNextBlock();
            if (b != null) {
                this.nestedBlocks.addFirst(b);
                hasIteratorMoreElements = true;
            } else {
                hasIteratorMoreElements = false;
            }
            if (!hasIteratorMoreElements && (returnedSize = this.iteratedBlocks.size()) != (actualSize = (blocks = StmtGraph.this.getBlocks()).size())) {
                String info = blocks.stream().filter(n -> !this.iteratedBlocks.contains(n)).map(BasicBlock::getStmts).collect(Collectors.toList()).toString();
                throw new IllegalStateException("There are " + (actualSize - returnedSize) + " Blocks that are not iterated! i.e. the StmtGraph is not connected from its startingStmt!" + info + DotExporter.createUrlToWebeditor(StmtGraph.this));
            }
            return hasIteratorMoreElements;
        }
    }

    public static class BlockGraphIteratorAndTrapAggregator
    extends BlockGraphIterator {
        @Nonnull
        private final List<Trap> collectedTraps = new ArrayList<Trap>();
        Map<ClassType, Stmt> trapStarts = new HashMap<ClassType, Stmt>();
        BasicBlock<?> lastIteratedBlock;
        final /* synthetic */ StmtGraph this$0;

        public BlockGraphIteratorAndTrapAggregator(V dummyBlock) {
            this.this$0 = this$0;
            this.lastIteratedBlock = dummyBlock;
        }

        @Override
        @Nonnull
        public BasicBlock<?> next() {
            Object block = super.next();
            Map currentBlocksExceptions = block.getExceptionalSuccessors();
            Map<ClassType, ?> lastBlocksExceptions = this.lastIteratedBlock.getExceptionalSuccessors();
            lastBlocksExceptions.forEach((arg_0, arg_1) -> this.lambda$next$0((BasicBlock)block, arg_0, arg_1));
            block.getExceptionalSuccessors().forEach((arg_0, arg_1) -> this.lambda$next$1(lastBlocksExceptions, (BasicBlock)block, arg_0, arg_1));
            this.lastIteratedBlock = block;
            return block;
        }

        public List<Trap> getTraps() {
            this.trapStarts.forEach((type, trapStart) -> {
                BasicBlock trapHandler = (BasicBlock)this.lastIteratedBlock.getExceptionalSuccessors().get(type);
                if (trapHandler == null) {
                    throw new IllegalStateException("No matching Trap info found for '" + type + "' in ExceptionalSucessors() of the last iterated Block!");
                }
                this.collectedTraps.add(new Trap((ClassType)type, (Stmt)trapStart, this.lastIteratedBlock.getTail(), trapHandler.getTail()));
            });
            this.trapStarts.clear();
            return this.collectedTraps;
        }

        private /* synthetic */ void lambda$next$1(Map lastBlocksExceptions, BasicBlock block, ClassType type, BasicBlock trapHandlerBlock) {
            if (trapHandlerBlock != lastBlocksExceptions.get(type)) {
                this.trapStarts.put(type, block.getHead());
            }
        }

        private /* synthetic */ void lambda$next$0(BasicBlock block, ClassType type, BasicBlock trapHandlerBlock) {
            if (trapHandlerBlock != block.getExceptionalSuccessors().get(type)) {
                Stmt trapBeginStmt = this.trapStarts.remove(type);
                if (trapBeginStmt == null) {
                    throw new IllegalStateException("Trap start for '" + type + "' is not in the Map!");
                }
                this.collectedTraps.add(new Trap(type, trapBeginStmt, block.getHead(), trapHandlerBlock.getHead()));
            }
        }
    }

    private class BlockStmtGraphIterator
    implements Iterator<Stmt> {
        private final BlockGraphIterator blockIt;
        @Nonnull
        private Iterator<Stmt> currentBlockIt = Collections.emptyIterator();

        public BlockStmtGraphIterator() {
            this(stmtGraph.new BlockGraphIterator());
        }

        public BlockStmtGraphIterator(BlockGraphIterator blockIterator) {
            this.blockIt = blockIterator;
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIt.hasNext() || this.blockIt.hasNext();
        }

        @Override
        public Stmt next() {
            if (!this.currentBlockIt.hasNext()) {
                if (!this.blockIt.hasNext()) {
                    throw new NoSuchElementException("Iterator has no more Stmts.");
                }
                Object currentBlock = this.blockIt.next();
                this.currentBlockIt = currentBlock.getStmts().iterator();
            }
            return this.currentBlockIt.next();
        }
    }
}

