/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.basic;

import java.util.Iterator;
import java.util.List;
import sootup.core.graph.BasicBlock;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JGeExpr;
import sootup.core.jimple.common.expr.JGtExpr;
import sootup.core.jimple.common.expr.JInstanceOfExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JLeExpr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JLtExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JPhiExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.stmt.AbstractOpStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JReturnVoidStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JBreakpointStmt;
import sootup.core.jimple.javabytecode.stmt.JEnterMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JExitMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JRetStmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;

public class JimpleComparator {
    private static final JimpleComparator INSTANCE = new JimpleComparator();

    public static JimpleComparator getInstance() {
        return INSTANCE;
    }

    public boolean caseLocal(Local obj, Object o) {
        if (!(o instanceof Local)) {
            return false;
        }
        Local local = (Local)o;
        return obj.getName().equals(local.getName()) && obj.getType().equals(local.getType());
    }

    public boolean caseBlock(BasicBlock<?> block, Object o) {
        if (!(o instanceof BasicBlock)) {
            return false;
        }
        BasicBlock obj = (BasicBlock)o;
        return this.caseStmt(block.getHead(), obj.getHead()) && this.caseStmt(block.getTail(), obj.getTail());
    }

    public boolean caseStmt(Stmt stmt, Object o) {
        if (!(o instanceof Stmt)) {
            return false;
        }
        if (stmt instanceof JBreakpointStmt) {
            return this.caseBreakpointStmt((JBreakpointStmt)stmt, o);
        }
        if (stmt instanceof JInvokeStmt) {
            return this.caseInvokeStmt((JInvokeStmt)stmt, o);
        }
        if (stmt instanceof JAssignStmt) {
            return this.caseAssignStmt((JAssignStmt)stmt, o);
        }
        if (stmt instanceof JIdentityStmt) {
            return this.caseIdentityStmt((JIdentityStmt)stmt, o);
        }
        if (stmt instanceof JEnterMonitorStmt) {
            return this.caseEnterMonitorStmt((JEnterMonitorStmt)stmt, o);
        }
        if (stmt instanceof JExitMonitorStmt) {
            return this.caseExitMonitorStmt((JExitMonitorStmt)stmt, o);
        }
        if (stmt instanceof JGotoStmt) {
            return this.caseGotoStmt((JGotoStmt)stmt, o);
        }
        if (stmt instanceof JIfStmt) {
            return this.caseIfStmt((JIfStmt)stmt, o);
        }
        if (stmt instanceof JSwitchStmt) {
            return this.caseSwitchStmt((JSwitchStmt)stmt, o);
        }
        if (stmt instanceof JNopStmt) {
            return this.caseNopStmt((JNopStmt)stmt, o);
        }
        if (stmt instanceof JRetStmt) {
            return this.caseRetStmt((JRetStmt)stmt, o);
        }
        if (stmt instanceof JReturnStmt) {
            return this.caseReturnStmt((JReturnStmt)stmt, o);
        }
        if (stmt instanceof JReturnVoidStmt) {
            return this.caseReturnVoidStmt((JReturnVoidStmt)stmt, o);
        }
        if (stmt instanceof JThrowStmt) {
            return this.caseThrowStmt((JThrowStmt)stmt, o);
        }
        return false;
    }

    public boolean caseBreakpointStmt(JBreakpointStmt stmt, Object o) {
        return o instanceof JBreakpointStmt;
    }

    public boolean caseInvokeStmt(JInvokeStmt stmt, Object o) {
        return o instanceof JInvokeStmt && stmt.getInvokeExpr().equivTo(((JInvokeStmt)o).getInvokeExpr(), this);
    }

    public boolean caseAssignStmt(JAssignStmt stmt, Object o) {
        if (!(o instanceof JAssignStmt)) {
            return false;
        }
        JAssignStmt jas = (JAssignStmt)o;
        return stmt.getLeftOp().equivTo(jas.getLeftOp(), this) && stmt.getRightOp().equivTo(jas.getRightOp(), this);
    }

    public boolean caseIdentityStmt(JIdentityStmt stmt, Object o) {
        if (!(o instanceof JIdentityStmt)) {
            return false;
        }
        JIdentityStmt identityStmt = (JIdentityStmt)o;
        return stmt.getLeftOp().equivTo(identityStmt.getLeftOp(), this) && stmt.getRightOp().equivTo(identityStmt.getRightOp(), this);
    }

    public boolean caseEnterMonitorStmt(JEnterMonitorStmt stmt, Object o) {
        if (!(o instanceof JEnterMonitorStmt)) {
            return false;
        }
        return stmt.getOp().equivTo(((AbstractOpStmt)o).getOp(), this);
    }

    public boolean caseExitMonitorStmt(JExitMonitorStmt stmt, Object o) {
        if (!(o instanceof JExitMonitorStmt)) {
            return false;
        }
        return stmt.getOp().equivTo(((AbstractOpStmt)o).getOp(), this);
    }

    public boolean caseGotoStmt(JGotoStmt stmt, Object o) {
        return o instanceof JGotoStmt;
    }

    public boolean caseIfStmt(JIfStmt stmt, Object o) {
        if (!(o instanceof JIfStmt)) {
            return false;
        }
        JIfStmt ifStmt = (JIfStmt)o;
        return stmt.getCondition().equivTo(ifStmt.getCondition(), this);
    }

    public boolean caseSwitchStmt(JSwitchStmt stmt, Object o) {
        if (!(o instanceof JSwitchStmt)) {
            return false;
        }
        JSwitchStmt otherSwitchStmt = (JSwitchStmt)o;
        if (stmt.getKey() != otherSwitchStmt.getKey()) {
            return false;
        }
        if (stmt.getValueCount() != otherSwitchStmt.getValueCount()) {
            return false;
        }
        Iterator<IntConstant> valueIterator = stmt.getValues().iterator();
        for (IntConstant valuesOther : otherSwitchStmt.getValues()) {
            if (valuesOther.equivTo(valueIterator.next(), this)) continue;
            return false;
        }
        return true;
    }

    public boolean caseNopStmt(JNopStmt stmt, Object o) {
        return o instanceof JNopStmt;
    }

    public boolean caseRetStmt(JRetStmt stmt, Object o) {
        if (!(o instanceof JRetStmt)) {
            return false;
        }
        return stmt.getStmtAddress().equivTo(((JRetStmt)o).getStmtAddress(), this);
    }

    public boolean caseReturnStmt(JReturnStmt stmt, Object o) {
        if (!(o instanceof JReturnStmt)) {
            return false;
        }
        return stmt.getOp().equivTo(((AbstractOpStmt)o).getOp(), this);
    }

    public boolean caseReturnVoidStmt(JReturnVoidStmt stmt, Object o) {
        return o instanceof JReturnVoidStmt;
    }

    public boolean caseThrowStmt(JThrowStmt stmt, Object o) {
        if (!(o instanceof JThrowStmt)) {
            return false;
        }
        return stmt.getOp().equivTo(((AbstractOpStmt)o).getOp(), this);
    }

    public boolean caseAbstractBinopExpr(AbstractBinopExpr obj, Object o) {
        if (o instanceof AbstractBinopExpr) {
            AbstractBinopExpr abe = (AbstractBinopExpr)o;
            if (obj instanceof JEqExpr && o instanceof JEqExpr) {
                JEqExpr jeq1 = (JEqExpr)abe;
                JEqExpr jeq2 = (JEqExpr)obj;
                return (jeq1.getOp1().equivTo(jeq2.getOp1()) && jeq1.getOp2().equivTo(jeq2.getOp2()) || jeq1.getOp1().equivTo(jeq2.getOp2()) && jeq1.getOp2().equivTo(jeq2.getOp1())) && jeq1.getSymbol().equals(jeq2.getSymbol());
            }
            if (obj instanceof JGtExpr && o instanceof JLtExpr) {
                JGtExpr jgt = (JGtExpr)obj;
                JLtExpr jlt = (JLtExpr)o;
                return jgt.getOp1().equivTo(jlt.getOp2()) && jgt.getOp2().equivTo(jlt.getOp1());
            }
            if (o instanceof JGtExpr && obj instanceof JLtExpr) {
                JGtExpr jgt = (JGtExpr)o;
                JLtExpr jlt = (JLtExpr)obj;
                return jgt.getOp1().equivTo(jlt.getOp2()) && jgt.getOp2().equivTo(jlt.getOp1());
            }
            if (obj instanceof JGeExpr && o instanceof JLeExpr) {
                JGeExpr jgt = (JGeExpr)obj;
                JLeExpr jlt = (JLeExpr)o;
                return jgt.getOp1().equivTo(jlt.getOp2()) && jgt.getOp2().equivTo(jlt.getOp1());
            }
            if (o instanceof JGeExpr && obj instanceof JLeExpr) {
                JGeExpr jgt = (JGeExpr)o;
                JLeExpr jlt = (JLeExpr)obj;
                return jgt.getOp1().equivTo(jlt.getOp2()) && jgt.getOp2().equivTo(jlt.getOp1());
            }
            return obj.getOp1().equivTo(abe.getOp1(), this) && obj.getOp2().equivTo(abe.getOp2(), this) && obj.getSymbol().equals(abe.getSymbol());
        }
        return false;
    }

    public boolean caseStaticInvokeExpr(JStaticInvokeExpr v, Object o) {
        if (!(o instanceof JStaticInvokeExpr)) {
            return false;
        }
        JStaticInvokeExpr ie = (JStaticInvokeExpr)o;
        if (!v.getMethodSignature().equals(ie.getMethodSignature()) || v.getArgCount() != ie.getArgCount()) {
            return false;
        }
        for (int i = v.getArgCount() - 1; i >= 0; --i) {
            if (v.getArg(i).equivTo(ie.getArg(i), this)) continue;
            return false;
        }
        return true;
    }

    public boolean caseDynamicInvokeExpr(JDynamicInvokeExpr v, Object o) {
        Value element;
        int i;
        if (!(o instanceof JDynamicInvokeExpr)) {
            return false;
        }
        JDynamicInvokeExpr ie = (JDynamicInvokeExpr)o;
        if (!v.getBootstrapMethodSignature().equals(ie.getBootstrapMethodSignature()) || v.getBootstrapArgCount() != ie.getBootstrapArgCount()) {
            return false;
        }
        for (i = v.getBootstrapArgCount() - 1; i >= 0; --i) {
            element = v.getBootstrapArg(i);
            if (element.equivTo(ie.getBootstrapArg(i), this)) continue;
            return false;
        }
        if (!v.getMethodSignature().equals(ie.getMethodSignature()) || v.getArgCount() != ie.getArgCount()) {
            return false;
        }
        for (i = v.getArgCount() - 1; i >= 0; --i) {
            element = v.getArg(i);
            if (element.equivTo(ie.getArg(i), this)) continue;
            return false;
        }
        return true;
    }

    public boolean caseCastExpr(JCastExpr v, Object o) {
        if (!(o instanceof JCastExpr)) {
            return false;
        }
        JCastExpr ace = (JCastExpr)o;
        return v.getOp().equivTo(ace.getOp(), this) && v.getType().equals(ace.getType());
    }

    public boolean caseInstanceOfExpr(JInstanceOfExpr v, Object o) {
        if (!(o instanceof JInstanceOfExpr)) {
            return false;
        }
        JInstanceOfExpr aie = (JInstanceOfExpr)o;
        return v.getOp().equivTo(aie.getOp(), this) && v.getCheckType().equals(aie.getCheckType());
    }

    public boolean caseNewArrayExpr(JNewArrayExpr v, Object o) {
        if (!(o instanceof JNewArrayExpr)) {
            return false;
        }
        JNewArrayExpr ae = (JNewArrayExpr)o;
        return v.getBaseType().equals(ae.getBaseType()) && v.getSize().equivTo(ae.getSize(), this);
    }

    public boolean caseNewMultiArrayExpr(JNewMultiArrayExpr v, Object o) {
        if (!(o instanceof JNewMultiArrayExpr)) {
            return false;
        }
        JNewMultiArrayExpr ae = (JNewMultiArrayExpr)o;
        return v.getBaseType().equals(ae.getBaseType()) && v.getSizeCount() == ae.getSizeCount();
    }

    public boolean caseJPhiExpr(JPhiExpr v, Object o) {
        if (!(o instanceof JPhiExpr)) {
            return false;
        }
        JPhiExpr ae = (JPhiExpr)o;
        for (int i = 0; i < v.getArgsSize(); ++i) {
            if (v.getArg(i).equivTo(ae.getArg(i), this)) continue;
            return false;
        }
        List<BasicBlock<?>> blocksV = v.getBlocks();
        List<BasicBlock<?>> blocksAe = ae.getBlocks();
        for (int i = 0; i < v.getArgsSize(); ++i) {
            if (this.caseBlock(blocksV.get(i), blocksAe.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean caseNewExpr(JNewExpr v, Object o) {
        if (!(o instanceof JNewExpr)) {
            return false;
        }
        JNewExpr ae = (JNewExpr)o;
        return v.getType().equals(ae.getType());
    }

    public boolean caseLengthExpr(JLengthExpr v, Object o) {
        if (!(o instanceof JLengthExpr)) {
            return false;
        }
        return v.getOp().equivTo(((JLengthExpr)o).getOp(), this);
    }

    public boolean caseNegExpr(JNegExpr v, Object o) {
        if (!(o instanceof JNegExpr)) {
            return false;
        }
        return v.getOp().equivTo(((JNegExpr)o).getOp(), this);
    }

    protected boolean caseAbstractInstanceInvokeExpr(AbstractInstanceInvokeExpr obj, Object o) {
        if (!(o instanceof AbstractInstanceInvokeExpr)) {
            return false;
        }
        AbstractInstanceInvokeExpr ie = (AbstractInstanceInvokeExpr)o;
        if (!obj.getBase().equivTo(ie.getBase(), this) || !obj.getMethodSignature().equals(ie.getMethodSignature()) || obj.getArgCount() != ie.getArgCount()) {
            return false;
        }
        for (int i = obj.getArgCount() - 1; i >= 0; --i) {
            if (obj.getArg(i).equivTo(ie.getArg(i), this)) continue;
            return false;
        }
        return true;
    }

    public boolean caseInterfaceInvokeExpr(JInterfaceInvokeExpr obj, Object o) {
        if (!(o instanceof JInterfaceInvokeExpr)) {
            return false;
        }
        return this.caseAbstractInstanceInvokeExpr(obj, o);
    }

    public boolean caseSpecialInvokeExpr(JSpecialInvokeExpr obj, Object o) {
        if (!(o instanceof JSpecialInvokeExpr)) {
            return false;
        }
        return this.caseAbstractInstanceInvokeExpr(obj, o);
    }

    public boolean caseVirtualInvokeExpr(JVirtualInvokeExpr obj, Object o) {
        if (!(o instanceof JVirtualInvokeExpr)) {
            return false;
        }
        return this.caseAbstractInstanceInvokeExpr(obj, o);
    }

    public boolean caseArrayRef(JArrayRef obj, Object o) {
        if (!(o instanceof JArrayRef)) {
            return false;
        }
        return obj.getBase().equivTo(((JArrayRef)o).getBase(), this) && obj.getIndex().equivTo(((JArrayRef)o).getIndex(), this);
    }

    public boolean caseCaughtException(JCaughtExceptionRef obj, Object o) {
        return o instanceof JCaughtExceptionRef;
    }

    public boolean caseInstanceFieldRef(JInstanceFieldRef obj, Object o) {
        if (!(o instanceof JInstanceFieldRef)) {
            return false;
        }
        JInstanceFieldRef fr = (JInstanceFieldRef)o;
        return fr.getFieldSignature().equals(obj.getFieldSignature()) && obj.getBase().equivTo(fr.getBase(), this);
    }

    public boolean caseParameterRef(JParameterRef obj, Object o) {
        if (!(o instanceof JParameterRef)) {
            return false;
        }
        return obj.getIndex() == ((JParameterRef)o).getIndex() && obj.getType().equals(((JParameterRef)o).getType());
    }

    public boolean caseStaticFieldRef(JStaticFieldRef obj, Object o) {
        if (!(o instanceof JStaticFieldRef)) {
            return false;
        }
        return obj.getFieldSignature().equals(((JStaticFieldRef)o).getFieldSignature());
    }

    public boolean caseThisRef(JThisRef obj, Object o) {
        if (!(o instanceof JThisRef)) {
            return false;
        }
        return obj.getType().equals(((JThisRef)o).getType());
    }

    public boolean caseConstant(Constant constant, Object o) {
        return constant.equals(o);
    }
}

