/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.ShiftableConstant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;

public class LongConstant
implements ShiftableConstant<LongConstant> {
    private final long value;

    private LongConstant(@Nonnull long value) {
        this.value = value;
    }

    public static LongConstant getInstance(@Nonnull long value) {
        return new LongConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof LongConstant && ((LongConstant)c).value == this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    @Nonnull
    public LongConstant add(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value + c.value);
    }

    @Override
    @Nonnull
    public LongConstant subtract(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value - c.value);
    }

    @Override
    @Nonnull
    public LongConstant multiply(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value * c.value);
    }

    @Override
    @Nonnull
    public LongConstant divide(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value / c.value);
    }

    @Override
    @Nonnull
    public LongConstant remainder(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value % c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant equalEqual(@Nonnull LongConstant c) {
        return BooleanConstant.getInstance(this.value == c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant notEqual(@Nonnull LongConstant c) {
        return BooleanConstant.getInstance(this.value != c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThan(@Nonnull LongConstant c) {
        return BooleanConstant.getInstance(this.value < c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThanOrEqual(@Nonnull LongConstant c) {
        return BooleanConstant.getInstance(this.value <= c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThan(@Nonnull LongConstant c) {
        return BooleanConstant.getInstance(this.value > c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThanOrEqual(@Nonnull LongConstant c) {
        return BooleanConstant.getInstance(this.value >= c.value);
    }

    public IntConstant cmp(LongConstant c) {
        if (this.value > c.value) {
            return IntConstant.getInstance(1);
        }
        if (this.value == c.value) {
            return IntConstant.getInstance(0);
        }
        return IntConstant.getInstance(-1);
    }

    @Override
    @Nonnull
    public LongConstant negate() {
        return LongConstant.getInstance(-this.value);
    }

    @Override
    @Nonnull
    public LongConstant and(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value & c.value);
    }

    @Override
    @Nonnull
    public LongConstant or(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value | c.value);
    }

    @Override
    @Nonnull
    public LongConstant xor(@Nonnull LongConstant c) {
        return LongConstant.getInstance(this.value ^ c.value);
    }

    @Override
    @Nonnull
    public LongConstant shiftLeft(@Nonnull IntConstant c) {
        return LongConstant.getInstance(this.value << c.getValue());
    }

    @Override
    @Nonnull
    public LongConstant shiftRight(@Nonnull IntConstant c) {
        return LongConstant.getInstance(this.value >> c.getValue());
    }

    @Override
    @Nonnull
    public LongConstant unsignedShiftRight(@Nonnull IntConstant c) {
        return LongConstant.getInstance(this.value >>> c.getValue());
    }

    public String toString() {
        return this.value + "L";
    }

    @Override
    @Nonnull
    public Type getType() {
        return PrimitiveType.getLong();
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseLongConstant(this);
    }

    public long getValue() {
        return this.value;
    }
}

