/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.util.printer.StmtPrinter;

public abstract class AbstractBinopExpr
implements Expr {
    @Nonnull
    private final Immediate op1;
    @Nonnull
    private final Immediate op2;

    AbstractBinopExpr(@Nonnull Immediate op1, @Nonnull Immediate op2) {
        this.op1 = op1;
        this.op2 = op2;
    }

    @Nonnull
    public Immediate getOp1() {
        return this.op1;
    }

    @Nonnull
    public Immediate getOp2() {
        return this.op2;
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        List<Value> uses1 = this.op1.getUses();
        List<Value> uses2 = this.op2.getUses();
        ArrayList<Value> list = new ArrayList<Value>(uses1.size() + uses2.size() + 2);
        list.addAll(uses1);
        list.add(this.op1);
        list.addAll(uses2);
        list.add(this.op2);
        return list;
    }

    @Override
    public boolean equivTo(@Nonnull Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseAbstractBinopExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.op1.equivHashCode() * 101 + this.op2.equivHashCode() + 17 ^ this.getSymbol().hashCode();
    }

    @Nonnull
    public abstract String getSymbol();

    public String toString() {
        String leftOp = this.op1.toString();
        String rightOp = this.op2.toString();
        return leftOp + this.getSymbol() + rightOp;
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        this.op1.toString(up);
        up.literal(this.getSymbol());
        this.op2.toString(up);
    }

    @Nonnull
    public abstract AbstractBinopExpr withOp1(@Nonnull Immediate var1);

    @Nonnull
    public abstract AbstractBinopExpr withOp2(@Nonnull Immediate var1);
}

