/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.common.expr.AbstractIntLongBinopExpr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.util.Copyable;

public final class JShrExpr
extends AbstractIntLongBinopExpr
implements Copyable {
    public JShrExpr(@Nonnull Immediate op1, @Nonnull Immediate op2) {
        super(op1, op2);
    }

    @Override
    @Nonnull
    public String getSymbol() {
        return " >> ";
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseShrExpr(this);
    }

    @Override
    @Nonnull
    public Type getType() {
        Immediate op1 = this.getOp1();
        Immediate op2 = this.getOp2();
        if (!PrimitiveType.isIntLikeType(op2.getType())) {
            return UnknownType.getInstance();
        }
        if (PrimitiveType.isIntLikeType(op1.getType())) {
            return PrimitiveType.getInt();
        }
        if (op1.getType().equals(PrimitiveType.getLong())) {
            return PrimitiveType.getLong();
        }
        return UnknownType.getInstance();
    }

    @Override
    @Nonnull
    public JShrExpr withOp1(@Nonnull Immediate op1) {
        return new JShrExpr(op1, this.getOp2());
    }

    @Override
    @Nonnull
    public JShrExpr withOp2(@Nonnull Immediate op2) {
        return new JShrExpr(this.getOp1(), op2);
    }
}

