/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.ref;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.visitor.RefVisitor;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JParameterRef
implements IdentityRef,
Copyable {
    private final int index;
    private final Type paramType;

    public JParameterRef(@Nonnull Type paramType, @Nonnull int number) {
        this.index = number;
        this.paramType = paramType;
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseParameterRef(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.index * 101 + this.paramType.hashCode() * 17;
    }

    public String toString() {
        return "@parameter" + this.index + ": " + this.paramType;
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.identityRef(this);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.paramType;
    }

    @Override
    public void accept(@Nonnull RefVisitor v) {
        v.caseParameterRef(this);
    }

    @Nonnull
    public JParameterRef withParamType(@Nonnull Type paramType) {
        return new JParameterRef(paramType, this.index);
    }

    @Nonnull
    public JParameterRef withNumber(@Nonnull int number) {
        return new JParameterRef(this.paramType, number);
    }
}

