/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.stmt;

import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.ref.ConcreteRef;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.visitor.StmtVisitor;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JAssignStmt<L extends Value, R extends Value>
extends AbstractDefinitionStmt<L, R>
implements Copyable {
    public JAssignStmt(@Nonnull L variable, @Nonnull R rValue, @Nonnull StmtPositionInfo positionInfo) {
        super(variable, rValue, positionInfo);
        if (!this.validateVariable((Value)variable)) {
            throw new RuntimeException("Illegal Assignment statement. Make sure that left hand side has a valid operand.");
        }
        if (!this.validateValue((Value)rValue)) {
            throw new RuntimeException("Illegal Assignment statement. Make sure that right hand side has a valid operand.");
        }
    }

    private boolean validateVariable(@Nonnull Value variable) {
        return variable instanceof Local || variable instanceof ConcreteRef;
    }

    private boolean validateValue(@Nonnull Value rValue) {
        return rValue instanceof Immediate || rValue instanceof ConcreteRef || rValue instanceof Expr;
    }

    @Override
    public boolean containsInvokeExpr() {
        return this.getRightOp() instanceof AbstractInvokeExpr;
    }

    @Override
    public AbstractInvokeExpr getInvokeExpr() {
        if (!this.containsInvokeExpr()) {
            throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
        }
        return (AbstractInvokeExpr)this.getRightOp();
    }

    @Override
    public boolean containsArrayRef() {
        return this.getLeftOp() instanceof JArrayRef || this.getRightOp() instanceof JArrayRef;
    }

    @Override
    public JArrayRef getArrayRef() {
        if (this.getLeftOp() instanceof JArrayRef) {
            return (JArrayRef)this.getLeftOp();
        }
        if (this.getRightOp() instanceof JArrayRef) {
            return (JArrayRef)this.getRightOp();
        }
        throw new RuntimeException("getArrayRef() called with no ArrayRef present!");
    }

    @Override
    public boolean containsFieldRef() {
        return this.getLeftOp() instanceof JFieldRef || this.getRightOp() instanceof JFieldRef;
    }

    @Override
    public JFieldRef getFieldRef() {
        if (this.getLeftOp() instanceof JFieldRef) {
            return (JFieldRef)this.getLeftOp();
        }
        if (this.getRightOp() instanceof JFieldRef) {
            return (JFieldRef)this.getRightOp();
        }
        throw new RuntimeException("getFieldRef() called with no JFieldRef present!");
    }

    public String toString() {
        return this.getLeftOp() + " = " + this.getRightOp();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        this.getLeftOp().toString(up);
        up.literal(" = ");
        this.getRightOp().toString(up);
    }

    @Override
    public void accept(@Nonnull StmtVisitor sw) {
        sw.caseAssignStmt(this);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseAssignStmt(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.getLeftOp().equivHashCode() + 31 * this.getRightOp().equivHashCode();
    }

    @Nonnull
    public <N extends Value> JAssignStmt<N, R> withVariable(@Nonnull N variable) {
        return new JAssignStmt(variable, this.getRightOp(), this.getPositionInfo());
    }

    @Nonnull
    public <N extends Value> JAssignStmt<L, N> withRValue(@Nonnull N rValue) {
        return new JAssignStmt(this.getLeftOp(), rValue, this.getPositionInfo());
    }

    @Nonnull
    public JAssignStmt<L, R> withPositionInfo(@Nonnull StmtPositionInfo positionInfo) {
        return new JAssignStmt(this.getLeftOp(), this.getRightOp(), positionInfo);
    }
}

