/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.javabytecode.stmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.StmtVisitor;
import sootup.core.model.Body;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public class JSwitchStmt
extends BranchingStmt
implements Copyable {
    private final Immediate key;
    private List<IntConstant> values;

    private JSwitchStmt(boolean isTableSwitch, @Nonnull StmtPositionInfo positionInfo, @Nonnull Immediate key) {
        super(positionInfo);
        this.key = key;
    }

    public JSwitchStmt(@Nonnull Immediate key, int lowIndex, int highIndex, @Nonnull StmtPositionInfo positionInfo) {
        this(true, positionInfo, key);
        if (lowIndex > highIndex) {
            throw new RuntimeException("Error creating switch: lowIndex(" + lowIndex + ") can't be greater than highIndex(" + highIndex + ").");
        }
        this.values = new ImmutableAscendingSequenceList(lowIndex, highIndex);
    }

    public JSwitchStmt(@Nonnull Immediate key, @Nonnull List<IntConstant> lookupValues, @Nonnull StmtPositionInfo positionInfo) {
        this(false, positionInfo, key);
        this.values = Collections.unmodifiableList(new ArrayList<IntConstant>(lookupValues));
    }

    public boolean isTableSwitch() {
        return this.values instanceof ImmutableAscendingSequenceList;
    }

    @Nonnull
    public Optional<Stmt> getDefaultTarget(Body body) {
        return Optional.ofNullable(body.getBranchTargetsOf(this).get(this.values.size()));
    }

    public Immediate getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public List<Value> getUses() {
        List<Value> uses = this.getKey().getUses();
        ArrayList<Value> list = new ArrayList<Value>(uses.size() + 1);
        list.addAll(uses);
        list.add(this.getKey());
        return list;
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public void accept(@Nonnull StmtVisitor sw) {
        sw.caseSwitchStmt(this);
    }

    public int getValueCount() {
        return this.values.size() + 1;
    }

    public int getValue(int index) {
        return this.values.get(index).getValue();
    }

    @Nonnull
    public List<IntConstant> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    @Nonnull
    public List<Stmt> getTargetStmts(Body body) {
        return body.getBranchTargetsOf(this);
    }

    @Override
    public int getExpectedSuccessorCount() {
        return this.getValueCount();
    }

    @Override
    public boolean equivTo(@Nonnull Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseSwitchStmt(this, o);
    }

    @Override
    public int equivHashCode() {
        return Objects.hash(this.getValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("switch").append('(').append(this.getKey()).append(')').append(' ').append('{').append(" ");
        for (IntConstant value : this.values) {
            sb.append("    ").append("case").append(' ').append(value).append(": ");
        }
        sb.append("    ").append("default").append(": ");
        sb.append(' ').append('}');
        return sb.toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter stmtPrinter) {
        stmtPrinter.literal("switch");
        stmtPrinter.literal("(");
        this.getKey().toString(stmtPrinter);
        stmtPrinter.literal(")");
        stmtPrinter.newline();
        stmtPrinter.incIndent();
        stmtPrinter.handleIndent();
        stmtPrinter.literal("{");
        stmtPrinter.newline();
        List<Stmt> targets = stmtPrinter.getGraph().getBranchTargetsOf(this);
        Iterator targetIt = targets.iterator();
        for (IntConstant value : this.values) {
            stmtPrinter.handleIndent();
            stmtPrinter.literal("case");
            stmtPrinter.literal(" ");
            stmtPrinter.constant(value);
            stmtPrinter.literal(": ");
            stmtPrinter.literal("goto");
            stmtPrinter.literal(" ");
            stmtPrinter.stmtRef((Stmt)targetIt.next(), true);
            stmtPrinter.literal(";");
            stmtPrinter.newline();
        }
        Stmt defaultTarget = (Stmt)targetIt.next();
        stmtPrinter.handleIndent();
        stmtPrinter.literal("default");
        stmtPrinter.literal(": ");
        stmtPrinter.literal("goto");
        stmtPrinter.literal(" ");
        stmtPrinter.stmtRef(defaultTarget, true);
        stmtPrinter.literal(";");
        stmtPrinter.decIndent();
        stmtPrinter.newline();
        stmtPrinter.handleIndent();
        stmtPrinter.literal("}");
    }

    @Nonnull
    public JSwitchStmt withKey(@Nonnull Immediate key) {
        return new JSwitchStmt(key, this.getValues(), this.getPositionInfo());
    }

    @Nonnull
    public JSwitchStmt withValues(@Nonnull List<IntConstant> values) {
        return new JSwitchStmt(this.getKey(), values, this.getPositionInfo());
    }

    @Nonnull
    public JSwitchStmt withPositionInfo(@Nonnull StmtPositionInfo positionInfo) {
        return new JSwitchStmt(this.getKey(), this.getValues(), positionInfo);
    }

    private static class ImmutableAscendingSequenceList
    implements List<IntConstant> {
        private final int from;
        private final int to;

        ImmutableAscendingSequenceList(int from, int to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public int size() {
            return this.to - this.from + 1;
        }

        @Override
        public boolean isEmpty() {
            return this.size() <= 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof IntConstant) {
                int value = ((IntConstant)o).getValue();
                return value >= this.from && value <= this.to;
            }
            return false;
        }

        @Override
        @Nonnull
        public Iterator<IntConstant> iterator() {
            return this.listIterator();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            Object[] intConstants = new IntConstant[this.to - this.from + 1];
            for (int i = 0; i < this.size(); ++i) {
                intConstants[i] = IntConstant.getInstance(this.from + i);
            }
            return intConstants;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] ts) {
            Object[] intConstants = new Object[this.to - this.from + 1];
            for (int i = 0; i < this.size(); ++i) {
                intConstants[i] = IntConstant.getInstance(this.from + i);
            }
            return intConstants;
        }

        @Override
        public boolean add(IntConstant constant) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends IntConstant> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i, @Nonnull Collection<? extends IntConstant> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntConstant get(int i) {
            if (0 > i || this.size() <= i) {
                throw new IndexOutOfBoundsException("" + i + "  is out of range [ 0 , " + (this.size() - 1) + " ]");
            }
            return IntConstant.getInstance(this.from + i);
        }

        @Override
        public IntConstant set(int i, IntConstant constant) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i, IntConstant constant) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntConstant remove(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            if (!this.contains(o)) {
                return -1;
            }
            return ((IntConstant)o).getValue() - this.from;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        @Nonnull
        public ListIterator<IntConstant> listIterator() {
            return this.listIterator(0);
        }

        @Override
        @Nonnull
        public ListIterator<IntConstant> listIterator(final int i) {
            return new ListIterator<IntConstant>(){
                int it;
                {
                    this.it = from + i - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.it < to;
                }

                @Override
                public IntConstant next() {
                    if (!this.hasNext()) {
                        throw new IndexOutOfBoundsException("There are no more elements.");
                    }
                    return IntConstant.getInstance(++this.it);
                }

                @Override
                public boolean hasPrevious() {
                    return this.it > from;
                }

                @Override
                public IntConstant previous() {
                    if (!this.hasPrevious()) {
                        throw new IndexOutOfBoundsException("There are no more elements.");
                    }
                    return IntConstant.getInstance(--this.it);
                }

                @Override
                public int nextIndex() {
                    return this.it + 1;
                }

                @Override
                public int previousIndex() {
                    return this.it - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(IntConstant constant) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(IntConstant constant) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        @Nonnull
        public List<IntConstant> subList(int startIdx, int endIdx) {
            return new ImmutableAscendingSequenceList(this.from + startIdx, this.from + endIdx);
        }
    }
}

