/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.visitor;

import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.ref.Ref;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JReturnVoidStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JBreakpointStmt;
import sootup.core.jimple.javabytecode.stmt.JEnterMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JExitMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JRetStmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.jimple.visitor.AbstractStmtVisitor;
import sootup.core.jimple.visitor.ReplaceUseExprVisitor;
import sootup.core.jimple.visitor.ReplaceUseRefVisitor;

public class ReplaceUseStmtVisitor
extends AbstractStmtVisitor<Stmt> {
    @Nonnull
    private final Value oldUse;
    @Nonnull
    private final Value newUse;
    final ReplaceUseExprVisitor exprVisitor = new ReplaceUseExprVisitor();
    final ReplaceUseRefVisitor refVisitor = new ReplaceUseRefVisitor();

    public ReplaceUseStmtVisitor(@Nonnull Value oldUse, @Nonnull Value newUse) {
        this.oldUse = oldUse;
        this.newUse = newUse;
    }

    @Override
    public void caseBreakpointStmt(@Nonnull JBreakpointStmt stmt) {
        this.defaultCaseStmt(stmt);
    }

    @Override
    public void caseInvokeStmt(@Nonnull JInvokeStmt stmt) {
        AbstractInvokeExpr invokeExpr = stmt.getInvokeExpr();
        this.exprVisitor.init(this.oldUse, this.newUse);
        invokeExpr.accept(this.exprVisitor);
        if (this.exprVisitor.getResult() != invokeExpr) {
            this.setResult(stmt.withInvokeExpr((AbstractInvokeExpr)this.exprVisitor.getResult()));
        } else {
            this.defaultCaseStmt(stmt);
        }
    }

    @Override
    public void caseAssignStmt(@Nonnull JAssignStmt<?, ?> stmt) {
        Object rValue = stmt.getRightOp();
        if (rValue instanceof Immediate) {
            if (rValue == this.oldUse) {
                this.setResult(stmt.withRValue(this.newUse));
            }
        } else if (rValue instanceof Ref) {
            if (rValue == this.oldUse) {
                this.setResult(stmt.withRValue(this.newUse));
            } else {
                this.refVisitor.init(this.oldUse, this.newUse);
                ((Ref)rValue).accept(this.refVisitor);
                if (this.refVisitor.getResult() != rValue) {
                    this.setResult(stmt.withRValue((Value)this.refVisitor.getResult()));
                }
            }
        } else if (rValue instanceof Expr) {
            this.exprVisitor.init(this.oldUse, this.newUse);
            ((Expr)rValue).accept(this.exprVisitor);
            if (this.exprVisitor.getResult() != rValue) {
                this.setResult(stmt.withRValue((Value)this.exprVisitor.getResult()));
            }
        } else {
            this.errorHandler(stmt);
        }
    }

    @Override
    public void caseIdentityStmt(@Nonnull JIdentityStmt stmt) {
        this.defaultCaseStmt(stmt);
    }

    @Override
    public void caseEnterMonitorStmt(@Nonnull JEnterMonitorStmt stmt) {
        this.setResult(stmt.withOp((Immediate)this.newUse));
    }

    @Override
    public void caseExitMonitorStmt(@Nonnull JExitMonitorStmt stmt) {
        this.setResult(stmt.withOp((Immediate)this.newUse));
    }

    @Override
    public void caseGotoStmt(@Nonnull JGotoStmt stmt) {
        this.defaultCaseStmt(stmt);
    }

    @Override
    public void caseIfStmt(@Nonnull JIfStmt stmt) {
        AbstractConditionExpr conditionExpr = stmt.getCondition();
        this.exprVisitor.init((Immediate)this.oldUse, (Immediate)this.newUse);
        conditionExpr.accept(this.exprVisitor);
        if (this.exprVisitor.getResult() != conditionExpr) {
            this.setResult(stmt.withCondition((AbstractConditionExpr)this.exprVisitor.getResult()));
        } else {
            this.errorHandler(stmt);
        }
    }

    @Override
    public void caseNopStmt(@Nonnull JNopStmt stmt) {
        this.defaultCaseStmt(stmt);
    }

    @Override
    public void caseRetStmt(@Nonnull JRetStmt stmt) {
        this.setResult(stmt.withStmtAddress(this.newUse));
    }

    @Override
    public void caseReturnStmt(@Nonnull JReturnStmt stmt) {
        this.setResult(stmt.withReturnValue((Immediate)this.newUse));
    }

    @Override
    public void caseReturnVoidStmt(@Nonnull JReturnVoidStmt stmt) {
        this.defaultCaseStmt(stmt);
    }

    @Override
    public void caseSwitchStmt(@Nonnull JSwitchStmt stmt) {
        this.setResult(stmt.withKey((Immediate)this.newUse));
    }

    @Override
    public void caseThrowStmt(@Nonnull JThrowStmt stmt) {
        this.setResult(stmt.withOp((Immediate)this.newUse));
    }

    @Override
    public void defaultCaseStmt(@Nonnull Stmt stmt) {
        this.setResult(stmt);
    }

    public void errorHandler(@Nonnull Stmt stmt) {
        this.defaultCaseStmt(stmt);
    }
}

