/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import java.util.Objects;

public class Position
implements Comparable<Position> {
    private final int firstLine;
    private final int firstCol;
    private final int lastLine;
    private final int lastCol;

    public Position(int firstLine, int firstCol, int lastLine, int lastCol) {
        this.firstLine = firstLine;
        this.firstCol = firstCol;
        this.lastLine = lastLine;
        this.lastCol = lastCol;
    }

    public int getFirstLine() {
        return this.firstLine;
    }

    public int getLastLine() {
        return this.lastLine;
    }

    public int getFirstCol() {
        return this.firstCol;
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.firstLine);
        if (this.firstCol >= 0) {
            sb.append(":").append(this.firstCol);
        }
        sb.append("-").append(this.lastLine);
        if (this.lastCol >= 0) {
            sb.append(":").append(this.lastCol);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        return this.firstLine == position.firstLine && this.firstCol == position.firstCol && this.lastLine == position.lastLine && this.lastCol == position.lastCol;
    }

    public int hashCode() {
        return Objects.hash(this.firstLine, this.firstCol, this.lastLine, this.lastCol);
    }

    @Override
    public int compareTo(Position position) {
        if (this.getFirstLine() < position.getFirstLine()) {
            return -1;
        }
        if (this.getFirstLine() == position.getFirstLine()) {
            if (this.getFirstCol() < position.getFirstCol()) {
                return -1;
            }
            if (this.getFirstCol() == position.getFirstCol()) {
                return 0;
            }
            return 1;
        }
        return 1;
    }
}

