/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ImmutableUtils {
    @Nonnull
    public static <E> ImmutableSet<E> emptyImmutableList() {
        return ImmutableSet.of();
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1) {
        return ImmutableList.of(e1);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2) {
        return ImmutableList.of(e1, e2);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3) {
        return ImmutableList.of(e1, e2, e3);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4) {
        return ImmutableList.of(e1, e2, e3, e4);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableList.of(e1, e2, e3, e4, e5);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5, E e6) {
        return ImmutableList.of(e1, e2, e3, e4, e5, e6);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5, E e6, E e7) {
        return ImmutableList.of(e1, e2, e3, e4, e5, e6, e7);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return ImmutableList.of(e1, e2, e3, e4, e5, e6, e7, e8);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return ImmutableList.of(e1, e2, e3, e4, e5, e6, e7, e8, e9);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return ImmutableList.of(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11) {
        return ImmutableList.of(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11);
    }

    @SafeVarargs
    @Nonnull
    public static <E> ImmutableList<E> immutableList(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11, E e12, E ... others) {
        return ImmutableList.of(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, others);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableListOf(@Nonnull E[] elements) {
        return ImmutableList.copyOf(elements);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableListOf(@Nonnull Iterable<? extends E> elements) {
        return ImmutableList.copyOf(elements);
    }

    @Nonnull
    public static <E> ImmutableList<E> immutableListOf(@Nonnull Stream<? extends E> elements) {
        return elements.collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static <E extends Enum<E>> ImmutableSet<E> emptyImmutableEnumSet() {
        return ImmutableUtils.emptyImmutableSet();
    }

    @Nonnull
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSetOf(@Nonnull Iterable<E> elements) {
        return Sets.immutableEnumSet(elements);
    }

    @SafeVarargs
    @Nonnull
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(@Nonnull E anElement, E ... otherElements) {
        return Sets.immutableEnumSet(anElement, otherElements);
    }

    @Nonnull
    public static <E> ImmutableSet<E> emptyImmutableSet() {
        return ImmutableSet.of();
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSet(E e1) {
        return ImmutableSet.of(e1);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSet(E e1, E e2) {
        return ImmutableSet.of(e1, e2);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSet(E e1, E e2, E e3) {
        return ImmutableSet.of(e1, e2, e3);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSet(E e1, E e2, E e3, E e4) {
        return ImmutableSet.of(e1, e2, e3, e4);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSet(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSet.of(e1, e2, e3, e4, e5);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSet(E e1, E e2, E e3, E e4, E e5, E e6) {
        return ImmutableSet.of(e1, e2, e3, e4, e5, e6, new Object[0]);
    }

    @SafeVarargs
    @Nonnull
    public static <E> ImmutableSet<E> immutableSet(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        return ImmutableSet.of(e1, e2, e3, e4, e5, e6, others);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSetOf(@Nonnull E[] elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSetOf(@Nonnull Iterable<? extends E> elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Nonnull
    public static <E> ImmutableSet<E> immutableSetOf(@Nonnull Stream<? extends E> elements) {
        return elements.collect(ImmutableSet.toImmutableSet());
    }

    public static final class ImmutableCollectors {
        @Nonnull
        public static <E> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
            return ImmutableSet.toImmutableSet();
        }

        @Nonnull
        public static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
            return Sets.toImmutableEnumSet();
        }
    }
}

