/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import sootup.core.inputlocation.FileType;

public class PathUtils {
    public static boolean hasExtension(@Nonnull Path path, FileType ... extensions) {
        return PathUtils.hasExtension(path, Arrays.asList(extensions));
    }

    public static boolean hasExtension(@Nonnull Path path, @Nonnull Collection<FileType> extensions) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        for (FileType extension : extensions) {
            if (!PathUtils.endsWithIgnoreCase(path.toString(), extension.getExtension())) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }

    public static boolean isArchive(@Nonnull Path path) {
        return PathUtils.hasExtension(path, FileType.ARCHIVE_TYPES);
    }
}

