/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util;

import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StreamUtils {
    @Nonnull
    public static <T> Stream<T> optionalToStream(@Nonnull Optional<T> o) {
        return o.map(Stream::of).orElseGet(Stream::empty);
    }

    @Nonnull
    public static <T> Stream<T> iterableToStream(@Nonnull Iterable<T> it) {
        return StreamUtils.iterableToStream(it, false);
    }

    @Nonnull
    public static <T> Stream<T> iterableToStream(@Nonnull Iterable<T> it, boolean parallel) {
        return StreamSupport.stream(it.spliterator(), parallel);
    }

    @Nonnull
    public static <T> Stream<T> iteratorToStream(@Nonnull Iterator<T> it) {
        return StreamUtils.iteratorToStream(it, false);
    }

    @Nonnull
    public static <T> Stream<T> iteratorToStream(@Nonnull Iterator<T> it, boolean parallel) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), parallel);
    }

    @Nonnull
    public static <C> Stream<C> filterAllCasted(@Nonnull Stream<?> stream, @Nonnull Class<C> clazz) {
        return stream.filter(clazz::isInstance).map(clazz::cast);
    }

    @Nonnull
    public static <T> T valueOrElse(@Nullable T value, @Nonnull T other) {
        return value != null ? value : other;
    }
}

