/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import sootup.core.Project;
import sootup.core.SourceTypeSpecifier;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.ClassLoadingOptions;
import sootup.core.inputlocation.DefaultSourceTypeSpecifier;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.JavaModuleProject;
import sootup.java.core.JavaSootClass;
import sootup.java.core.ModuleInfoAnalysisInputLocation;
import sootup.java.core.language.JavaLanguage;
import sootup.java.core.views.JavaView;
import sootup.java.core.views.MutableJavaView;

public class JavaProject
extends Project<JavaSootClass, JavaView> {
    public JavaProject(JavaLanguage language, @Nonnull List<AnalysisInputLocation<? extends JavaSootClass>> inputLocations, @Nonnull SourceTypeSpecifier sourceTypeSpecifier) {
        super(language, inputLocations, JavaIdentifierFactory.getInstance(), sourceTypeSpecifier);
    }

    @Override
    @Nonnull
    public JavaView createOnDemandView() {
        return new JavaView(this);
    }

    @Nonnull
    public MutableJavaView createMutableOnDemandView() {
        return new MutableJavaView(this);
    }

    @Override
    @Nonnull
    public JavaView createOnDemandView(@Nonnull Function<AnalysisInputLocation<? extends JavaSootClass>, ClassLoadingOptions> classLoadingOptionsSpecifier) {
        return new JavaView(this, classLoadingOptionsSpecifier);
    }

    @Override
    @Nonnull
    public JavaView createFullView() {
        JavaView view = this.createOnDemandView();
        view.getClasses();
        return view;
    }

    @Nonnull
    public MutableJavaView createMutableFullView() {
        MutableJavaView view = this.createMutableOnDemandView();
        view.getClasses();
        return view;
    }

    @Nonnull
    public static JavaProjectBuilder builder(JavaLanguage language) {
        return new JavaProjectBuilder(language);
    }

    public static class JavaProjectBuilder {
        private final List<AnalysisInputLocation<? extends JavaSootClass>> analysisInputLocations = new ArrayList<AnalysisInputLocation<? extends JavaSootClass>>();
        private final List<ModuleInfoAnalysisInputLocation> moduleAnalysisInputLocations = new ArrayList<ModuleInfoAnalysisInputLocation>();
        private SourceTypeSpecifier sourceTypeSpecifier = DefaultSourceTypeSpecifier.getInstance();
        private final JavaLanguage language;
        private boolean useModules = false;

        public JavaProjectBuilder(JavaLanguage language) {
            this.language = language;
        }

        @Nonnull
        public JavaProjectBuilder setSourceTypeSpecifier(SourceTypeSpecifier sourceTypeSpecifier) {
            this.sourceTypeSpecifier = sourceTypeSpecifier;
            return this;
        }

        @Nonnull
        public JavaProjectBuilder addInputLocation(AnalysisInputLocation<JavaSootClass> analysisInputLocation) {
            this.analysisInputLocations.add(analysisInputLocation);
            return this;
        }

        @Nonnull
        public JavaProjectBuilder addInputLocation(ModuleInfoAnalysisInputLocation analysisInputLocation) {
            Preconditions.checkArgument(this.language.getVersion() > 8);
            this.useModules = true;
            this.moduleAnalysisInputLocations.add(analysisInputLocation);
            return this;
        }

        @Nonnull
        public JavaProjectBuilder enableModules() {
            this.useModules = true;
            return this;
        }

        @Nonnull
        public JavaProject build() {
            if (this.useModules) {
                return new JavaModuleProject(this.language, this.analysisInputLocations, this.moduleAnalysisInputLocations, this.sourceTypeSpecifier);
            }
            return new JavaProject(this.language, this.analysisInputLocations, this.sourceTypeSpecifier);
        }
    }
}

