/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.sourcecode.frontend;

import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.CAstBinaryOp;
import com.ibm.wala.cast.java.ssa.AstJavaInvokeInstruction;
import com.ibm.wala.cast.java.ssa.EnclosingObjectReference;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sootup.core.IdentifierFactory;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.LocalGenerator;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JInstanceOfExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.jimple.visitor.Acceptor;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootField;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.types.VoidType;
import sootup.core.util.Copyable;
import sootup.java.core.ConstantUtil;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.language.JavaJimple;
import sootup.java.core.types.JavaClassType;
import sootup.java.sourcecode.frontend.WalaIRToJimpleConverter;

public class InstructionConverter {
    private final AstMethod.DebuggingInformation debugInfo;
    private final WalaIRToJimpleConverter converter;
    private final MethodSignature methodSignature;
    private final AstMethod walaMethod;
    private final SymbolTable symbolTable;
    private final LocalGenerator localGenerator;
    private final Map<JGotoStmt, Integer> branchingTargetsOfGotoStmts;
    private final Map<JIfStmt, Integer> branchingTargetsOfIfStmts;
    private final Map<JSwitchStmt, List<Integer>> branchingTargetsOfLookUpSwitchStmts;
    private final Map<Integer, Local> locals;
    private final IdentifierFactory identifierFactory;

    InstructionConverter(WalaIRToJimpleConverter converter, MethodSignature methodSignature, AstMethod walaMethod, LocalGenerator localGenerator) {
        this.converter = converter;
        this.methodSignature = methodSignature;
        this.walaMethod = walaMethod;
        this.symbolTable = walaMethod.symbolTable();
        this.localGenerator = localGenerator;
        this.branchingTargetsOfIfStmts = new LinkedHashMap<JIfStmt, Integer>();
        this.branchingTargetsOfGotoStmts = new LinkedHashMap<JGotoStmt, Integer>();
        this.branchingTargetsOfLookUpSwitchStmts = new LinkedHashMap<JSwitchStmt, List<Integer>>();
        this.locals = new HashMap<Integer, Local>();
        this.identifierFactory = converter.identifierFactory;
        this.debugInfo = walaMethod.debugInfo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Stmt> convertInstruction(SSAInstruction inst, HashMap<Integer, Stmt> stmt2iIndex) {
        List<Stmt> stmts = new ArrayList<Stmt>();
        if (inst instanceof SSAConditionalBranchInstruction) {
            stmts.addAll(this.convertBranchInstruction((SSAConditionalBranchInstruction)inst));
            return stmts;
        } else if (inst instanceof SSAGotoInstruction) {
            stmts.add(this.convertGoToInstruction((SSAGotoInstruction)inst));
            return stmts;
        } else if (inst instanceof SSAReturnInstruction) {
            stmts.add(this.convertReturnInstruction((SSAReturnInstruction)inst));
            return stmts;
        } else if (inst instanceof AstJavaInvokeInstruction) {
            stmts.add(this.convertInvokeInstruction((AstJavaInvokeInstruction)inst));
            return stmts;
        } else if (inst instanceof SSAFieldAccessInstruction) {
            if (inst instanceof SSAGetInstruction) {
                stmts.add(this.convertGetInstruction((SSAGetInstruction)inst));
                return stmts;
            } else {
                if (!(inst instanceof SSAPutInstruction)) throw new RuntimeException("Unsupported instruction type: " + inst.getClass().toString());
                stmts.add(this.convertPutInstruction((SSAPutInstruction)inst));
            }
            return stmts;
        } else if (inst instanceof SSANewInstruction) {
            stmts.add(this.convertNewInstruction((SSANewInstruction)inst));
            return stmts;
        } else if (inst instanceof SSAConversionInstruction) {
            stmts.add(this.convertConversionInstruction((SSAConversionInstruction)inst));
            return stmts;
        } else if (inst instanceof SSAInstanceofInstruction) {
            stmts.add(this.convertInstanceofInstruction((SSAInstanceofInstruction)inst));
            return stmts;
        } else if (inst instanceof SSABinaryOpInstruction) {
            stmts.addAll(this.convertBinaryOpInstruction((SSABinaryOpInstruction)inst));
            return stmts;
        } else if (inst instanceof SSAUnaryOpInstruction) {
            stmts.add(this.convertUnaryOpInstruction((SSAUnaryOpInstruction)inst));
            return stmts;
        } else if (inst instanceof SSAThrowInstruction) {
            stmts.add(this.convertThrowInstruction((SSAThrowInstruction)inst));
            return stmts;
        } else if (inst instanceof SSASwitchInstruction) {
            stmts.add(this.convertSwitchInstruction((SSASwitchInstruction)inst));
            return stmts;
        } else if (inst instanceof SSALoadMetadataInstruction) {
            stmts.add(this.convertLoadMetadataInstruction((SSALoadMetadataInstruction)inst));
            return stmts;
        } else if (inst instanceof EnclosingObjectReference) {
            stmts.add(this.convertEnclosingObjectReference((EnclosingObjectReference)inst));
            return stmts;
        } else {
            if (inst instanceof AstLexicalRead) {
                return this.convertAstLexicalRead((AstLexicalRead)inst);
            }
            if (inst instanceof AstLexicalWrite) {
                return this.convertAstLexicalWrite((AstLexicalWrite)inst);
            }
            if (inst instanceof AstAssertInstruction) {
                return this.convertAssertInstruction((AstAssertInstruction)inst, stmt2iIndex);
            }
            if (inst instanceof SSACheckCastInstruction) {
                stmts.add(this.convertCheckCastInstruction((SSACheckCastInstruction)inst));
                return stmts;
            } else if (inst instanceof SSAMonitorInstruction) {
                stmts.add(this.convertMonitorInstruction((SSAMonitorInstruction)inst));
                return stmts;
            } else if (inst instanceof SSAGetCaughtExceptionInstruction) {
                stmts.add(this.convertGetCaughtExceptionInstruction((SSAGetCaughtExceptionInstruction)inst));
                return stmts;
            } else if (inst instanceof SSAArrayLengthInstruction) {
                stmts.add(this.convertArrayLengthInstruction((SSAArrayLengthInstruction)inst));
                return stmts;
            } else {
                if (!(inst instanceof SSAArrayReferenceInstruction)) throw new RuntimeException("Unsupported instruction type: " + inst.getClass().toString());
                if (inst instanceof SSAArrayLoadInstruction) {
                    stmts.add(this.convertArrayLoadInstruction((SSAArrayLoadInstruction)inst));
                    return stmts;
                } else {
                    if (!(inst instanceof SSAArrayStoreInstruction)) throw new RuntimeException("Unsupported instruction type: " + inst.getClass().toString());
                    stmts.add(this.convertArrayStoreInstruction((SSAArrayStoreInstruction)inst));
                }
            }
        }
        return stmts;
    }

    private Stmt convertArrayStoreInstruction(SSAArrayStoreInstruction inst) {
        Local base = this.getLocal(UnknownType.getInstance(), inst.getArrayRef());
        int i = inst.getIndex();
        Acceptor<ConstantVisitor> index = null;
        index = this.symbolTable.isConstant(i) ? this.getConstant(i) : this.getLocal(PrimitiveType.getInt(), i);
        JArrayRef arrayRef = JavaJimple.getInstance().newArrayRef(base, (Immediate)((Object)index));
        Acceptor<ConstantVisitor> rvalue = null;
        int value = inst.getValue();
        rvalue = this.symbolTable.isConstant(value) ? this.getConstant(value) : this.getLocal(base.getType(), value);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[1];
        return Jimple.newAssignStmt(arrayRef, rvalue, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Stmt convertArrayLoadInstruction(SSAArrayLoadInstruction inst) {
        Local base = this.getLocal(UnknownType.getInstance(), inst.getArrayRef());
        int i = inst.getIndex();
        Acceptor<ConstantVisitor> index = this.symbolTable.isConstant(i) ? this.getConstant(i) : this.getLocal(PrimitiveType.getInt(), i);
        JArrayRef arrayRef = JavaJimple.getInstance().newArrayRef(base, (Immediate)((Object)index));
        Local left = null;
        int def = inst.getDef();
        left = this.getLocal(base.getType(), def);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[1];
        return Jimple.newAssignStmt(left, arrayRef, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Stmt convertArrayLengthInstruction(SSAArrayLengthInstruction inst) {
        int result = inst.getDef();
        Local left = this.getLocal(PrimitiveType.getInt(), result);
        int arrayRef = inst.getArrayRef();
        Local arrayLocal = this.getLocal(UnknownType.getInstance(), arrayRef);
        JLengthExpr right = Jimple.newLengthExpr(arrayLocal);
        CAstSourcePositionMap.Position p1 = this.debugInfo.getOperandPosition(inst.iIndex(), 0);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[]{p1};
        return Jimple.newAssignStmt(left, right, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Stmt convertGetCaughtExceptionInstruction(SSAGetCaughtExceptionInstruction inst) {
        int exceptionValue = inst.getException();
        JavaClassType exceptionClassType = JavaIdentifierFactory.getInstance().getClassType("java.lang.Throwable");
        Local local = this.getLocal(exceptionClassType, exceptionValue);
        JCaughtExceptionRef caught = JavaJimple.getInstance().newCaughtExceptionRef();
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[1];
        JIdentityStmt<JCaughtExceptionRef> handlerStmt = Jimple.newIdentityStmt(local, caught, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        return handlerStmt;
    }

    private Stmt convertMonitorInstruction(SSAMonitorInstruction inst) {
        Local op = this.getLocal(UnknownType.getInstance(), inst.getRef());
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[1];
        if (inst.isMonitorEnter()) {
            return Jimple.newEnterMonitorStmt(op, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        }
        return Jimple.newExitMonitorStmt(op, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private List<Stmt> convertAssertInstruction(AstAssertInstruction inst, HashMap<Integer, Stmt> stmt2iIndex) {
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        JavaClassType cSig = (JavaClassType)this.methodSignature.getDeclClassType();
        FieldSignature fieldSig = this.identifierFactory.getFieldSignature("$assertionsDisabled", (ClassType)cSig, "boolean");
        SootField assertionsDisabled = new SootField(fieldSig, (Iterable<Modifier>)EnumSet.of(Modifier.FINAL, Modifier.STATIC), (Position)NoPositionInformation.getInstance());
        this.converter.addSootField(assertionsDisabled);
        Local testLocal = this.localGenerator.generateLocal(PrimitiveType.getBoolean());
        JStaticFieldRef assertFieldRef = Jimple.newStaticFieldRef(fieldSig);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[]{this.debugInfo.getOperandPosition(inst.iIndex(), 0)};
        JAssignStmt<Local, JStaticFieldRef> assignStmt = Jimple.newAssignStmt(testLocal, assertFieldRef, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        stmts.add(assignStmt);
        JEqExpr condition = Jimple.newEqExpr(testLocal, IntConstant.getInstance(1));
        JNopStmt nopStmt = Jimple.newNopStmt(WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        int stmtAfterAssertion = -42 - inst.iIndex();
        stmt2iIndex.put(stmtAfterAssertion, nopStmt);
        JIfStmt ifStmt = Jimple.newIfStmt(condition, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        this.branchingTargetsOfIfStmts.put(ifStmt, stmtAfterAssertion);
        stmts.add(ifStmt);
        Local assertLocal = this.getLocal(PrimitiveType.getBoolean(), inst.getUse(0));
        JEqExpr assertionExpr = Jimple.newEqExpr(assertLocal, IntConstant.getInstance(1));
        JIfStmt assertIfStmt = Jimple.newIfStmt(assertionExpr, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        stmts.add(assertIfStmt);
        this.branchingTargetsOfIfStmts.put(assertIfStmt, stmtAfterAssertion);
        JavaClassType assertionErrorType = JavaIdentifierFactory.getInstance().getClassType("java.lang.AssertionError");
        Local failureLocal = this.localGenerator.generateLocal(assertionErrorType);
        JNewExpr newExpr = Jimple.newNewExpr(assertionErrorType);
        JAssignStmt<Local, JNewExpr> newAssignStmt = Jimple.newAssignStmt(failureLocal, newExpr, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        stmts.add(newAssignStmt);
        MethodSignature methodSig = this.identifierFactory.getMethodSignature("<init>", "java.lang.AssertionError", "void", Collections.emptyList());
        JSpecialInvokeExpr invoke = Jimple.newSpecialInvokeExpr(failureLocal, methodSig);
        JInvokeStmt invokeStmt = Jimple.newInvokeStmt(invoke, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        stmts.add(invokeStmt);
        JThrowStmt throwStmt = Jimple.newThrowStmt(failureLocal, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        stmts.add(throwStmt);
        stmts.add(nopStmt);
        return stmts;
    }

    private List<Stmt> convertAstLexicalWrite(AstLexicalWrite inst) {
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        for (int i = 0; i < inst.getAccessCount(); ++i) {
            Copyable left;
            AstLexicalAccess.Access access = inst.getAccess(i);
            Type type = this.converter.convertType(access.type);
            Acceptor<ConstantVisitor> right = this.symbolTable.isConstant(access.valueNumber) ? this.getConstant(access.valueNumber) : this.getLocal(type, access.valueNumber);
            JavaClassType cSig = (JavaClassType)this.methodSignature.getDeclClassType();
            if (!this.walaMethod.isStatic()) {
                FieldSignature fieldSig = this.identifierFactory.getFieldSignature("val$" + access.variableName, (ClassType)cSig, type.toString());
                SootField field = new SootField(fieldSig, (Iterable<Modifier>)EnumSet.of(Modifier.FINAL), (Position)NoPositionInformation.getInstance());
                left = Jimple.newInstanceFieldRef(this.localGenerator.getThisLocal(), fieldSig);
                this.converter.addSootField(field);
            } else {
                left = this.localGenerator.generateLocal(type);
            }
            stmts.add(Jimple.newAssignStmt(left, right, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), null)));
        }
        return stmts;
    }

    private List<Stmt> convertAstLexicalRead(AstLexicalRead inst) {
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        for (int i = 0; i < inst.getAccessCount(); ++i) {
            AstLexicalAccess.Access access = inst.getAccess(i);
            Type type = this.converter.convertType(access.type);
            Local left = this.getLocal(type, access.valueNumber);
            JavaClassType cSig = (JavaClassType)this.methodSignature.getDeclClassType();
            Copyable rvalue = null;
            if (!this.walaMethod.isStatic()) {
                FieldSignature fieldSig = this.identifierFactory.getFieldSignature("val$" + access.variableName, (ClassType)cSig, type.toString());
                SootField field = new SootField(fieldSig, (Iterable<Modifier>)EnumSet.of(Modifier.FINAL), (Position)NoPositionInformation.getInstance());
                rvalue = Jimple.newInstanceFieldRef(this.localGenerator.getThisLocal(), fieldSig);
                this.converter.addSootField(field);
            } else {
                rvalue = this.localGenerator.generateLocal(type);
            }
            stmts.add(Jimple.newAssignStmt(left, rvalue, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), null)));
        }
        return stmts;
    }

    private Stmt convertEnclosingObjectReference(EnclosingObjectReference inst) {
        Type enclosingType = this.converter.convertType(inst.getEnclosingType());
        Local variable = this.getLocal(enclosingType, inst.getDef());
        JavaClassType cSig = (JavaClassType)this.methodSignature.getDeclClassType();
        FieldSignature fieldSig = this.identifierFactory.getFieldSignature("this$0", (ClassType)cSig, enclosingType.toString());
        JInstanceFieldRef rvalue = Jimple.newInstanceFieldRef(this.localGenerator.getThisLocal(), fieldSig);
        return Jimple.newAssignStmt(variable, rvalue, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), null));
    }

    private Stmt convertCheckCastInstruction(SSACheckCastInstruction inst) {
        TypeReference[] types = inst.getDeclaredResultTypes();
        Local result = this.getLocal(this.converter.convertType(types[0]), inst.getResult());
        Acceptor<ConstantVisitor> rvalue = null;
        int val = inst.getVal();
        rvalue = this.symbolTable.isConstant(val) ? this.getConstant(val) : this.getLocal(this.converter.convertType(types[0]), val);
        JCastExpr castExpr = Jimple.newCastExpr(rvalue, this.converter.convertType(types[0]));
        return Jimple.newAssignStmt(result, castExpr, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), null));
    }

    private Stmt convertLoadMetadataInstruction(SSALoadMetadataInstruction inst) {
        Local lval = this.getLocal(this.converter.convertType(inst.getType()), inst.getDef());
        TypeReference token = (TypeReference)inst.getToken();
        ClassConstant c = JavaJimple.getInstance().newClassConstant(token.getName().toString());
        return Jimple.newAssignStmt(lval, c, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), null));
    }

    private Stmt convertSwitchInstruction(SSASwitchInstruction inst) {
        int val = inst.getUse(0);
        Local local = this.getLocal(UnknownType.getInstance(), val);
        int[] cases = inst.getCasesAndLabels();
        int defaultCase = inst.getDefault();
        ArrayList<IntConstant> lookupValues = new ArrayList<IntConstant>();
        ArrayList<Integer> targetList = new ArrayList<Integer>();
        for (int i = 0; i < cases.length; ++i) {
            int c = cases[i];
            if (i % 2 == 0) {
                IntConstant cValue = IntConstant.getInstance(c);
                lookupValues.add(cValue);
                continue;
            }
            targetList.add(c);
        }
        targetList.add(defaultCase);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[2];
        JSwitchStmt stmt = Jimple.newLookupSwitchStmt(local, lookupValues, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        this.branchingTargetsOfLookUpSwitchStmts.put(stmt, targetList);
        return stmt;
    }

    private Stmt convertThrowInstruction(SSAThrowInstruction inst) {
        int exception = inst.getException();
        Local local = this.getLocal(UnknownType.getInstance(), exception);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[]{this.debugInfo.getOperandPosition(inst.iIndex(), 0)};
        JThrowStmt jThrowStmt = Jimple.newThrowStmt(local, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        return jThrowStmt;
    }

    private Stmt convertUnaryOpInstruction(SSAUnaryOpInstruction inst) {
        int def = inst.getDef();
        int use = inst.getUse(0);
        Type type = UnknownType.getInstance();
        Acceptor<ConstantVisitor> op = this.symbolTable.isConstant(use) ? this.getConstant(use) : this.getLocal(type, use);
        type = op.getType();
        if (type == NullType.getInstance()) {
            type = UnknownType.getInstance();
        }
        Local left = this.getLocal(type, def);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[2];
        if (inst instanceof AssignInstruction) {
            return Jimple.newAssignStmt(left, op, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
        }
        JNegExpr expr = Jimple.newNegExpr(op);
        return Jimple.newAssignStmt(left, expr, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Stmt convertPutInstruction(SSAPutInstruction inst) {
        JFieldRef fieldValue;
        FieldReference fieldRef = inst.getDeclaredField();
        Type fieldType = this.converter.convertType(inst.getDeclaredFieldType());
        String walaClassName = fieldRef.getDeclaringClass().getName().toString();
        JavaClassType classSig = (JavaClassType)this.identifierFactory.getClassType(this.converter.convertClassNameFromWala(walaClassName));
        FieldSignature fieldSig = this.identifierFactory.getFieldSignature(fieldRef.getName().toString(), (ClassType)classSig, fieldType.toString());
        if (inst.isStatic()) {
            fieldValue = Jimple.newStaticFieldRef(fieldSig);
        } else {
            int ref = inst.getRef();
            Local base = this.getLocal(classSig, ref);
            fieldValue = Jimple.newInstanceFieldRef(base, fieldSig);
        }
        int val = inst.getVal();
        Acceptor<ConstantVisitor> value = this.symbolTable.isConstant(val) ? this.getConstant(val) : this.getLocal(fieldType, val);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[2];
        return Jimple.newAssignStmt(fieldValue, value, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Stmt convertNewInstruction(SSANewInstruction inst) {
        Expr rvalue;
        int result = inst.getDef();
        Type type = this.converter.convertType(inst.getNewSite().getDeclaredType());
        Local var = this.getLocal(type, result);
        if (type instanceof ArrayType) {
            int use = inst.getUse(0);
            Acceptor<ConstantVisitor> size = this.symbolTable.isConstant(use) ? this.getConstant(use) : this.getLocal(PrimitiveType.getInt(), use);
            Type baseType = this.converter.convertType(inst.getNewSite().getDeclaredType().getArrayElementType());
            rvalue = JavaJimple.getInstance().newNewArrayExpr(baseType, (Immediate)((Object)size));
        } else {
            rvalue = Jimple.newNewExpr((ClassType)type);
        }
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[2];
        return Jimple.newAssignStmt(var, rvalue, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Stmt convertComparisonInstruction(SSAComparisonInstruction inst) {
        return Jimple.newNopStmt(WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), null));
    }

    private Stmt convertInstanceofInstruction(SSAInstanceofInstruction inst) {
        int result = inst.getDef();
        int ref = inst.getRef();
        Type checkedType = this.converter.convertType(inst.getCheckedType());
        Local op = this.getLocal(UnknownType.getInstance(), ref);
        JInstanceOfExpr expr = Jimple.newInstanceOfExpr(op, checkedType);
        Local left = this.getLocal(PrimitiveType.getBoolean(), result);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[2];
        return Jimple.newAssignStmt(left, expr, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Stmt convertConversionInstruction(SSAConversionInstruction inst) {
        Type fromType = this.converter.convertType(inst.getFromType());
        Type toType = this.converter.convertType(inst.getToType());
        int def = inst.getDef();
        int use = inst.getUse(0);
        Local lvalue = this.getLocal(toType, def);
        Acceptor<ConstantVisitor> rvalue = this.symbolTable.isConstant(use) ? this.getConstant(use) : this.getLocal(fromType, use);
        JCastExpr cast = Jimple.newCastExpr(rvalue, toType);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[2];
        return Jimple.newAssignStmt(lvalue, cast, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Stmt convertInvokeInstruction(AstJavaInvokeInstruction invokeInst) {
        void var13_22;
        void var2_31;
        CallSiteReference callee = invokeInst.getCallSite();
        MethodReference target = invokeInst.getDeclaredTarget();
        String declaringClassSignature = this.converter.convertClassNameFromWala(target.getDeclaringClass().getName().toString());
        String returnType = this.converter.convertType(target.getReturnType()).toString();
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList<Type> paraTypes = new ArrayList<Type>();
        ArrayList<Immediate> args = new ArrayList<Immediate>();
        for (int i = 0; i < target.getNumberOfParameters(); ++i) {
            Type paraType = this.converter.convertType(target.getParameterType(i));
            paraTypes.add(paraType);
            parameters.add(paraType.toString());
        }
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[invokeInst.getNumberOfUses()];
        for (int j = 0; j < invokeInst.getNumberOfUses(); ++j) {
            operandPos[j] = this.debugInfo.getOperandPosition(invokeInst.iIndex(), j);
        }
        int i = 0;
        if (!callee.isStatic()) {
            i = 1;
        }
        while (i < invokeInst.getNumberOfUses()) {
            void var13_15;
            int use = invokeInst.getUse(i);
            if (this.symbolTable.isConstant(use)) {
                Constant constant = this.getConstant(use);
            } else if (invokeInst.getNumberOfUses() > paraTypes.size()) {
                Local local = this.getLocal((Type)paraTypes.get(i - 1), use);
            } else {
                Local local = this.getLocal((Type)paraTypes.get(i), use);
            }
            assert (var13_15 != null);
            args.add((Immediate)var13_15);
            ++i;
        }
        MethodSignature methodSig = this.identifierFactory.getMethodSignature(target.getName().toString(), declaringClassSignature, returnType, parameters);
        if (!callee.isStatic()) {
            int n = invokeInst.getReceiver();
            Type classType = this.converter.convertType(target.getDeclaringClass());
            Local base = this.getLocal(classType, n);
            if (callee.isSpecial()) {
                UnknownType baseType = UnknownType.getInstance();
                base = this.getLocal(baseType, n);
                JSpecialInvokeExpr jSpecialInvokeExpr = Jimple.newSpecialInvokeExpr(base, methodSig, args);
            } else if (callee.isVirtual()) {
                JVirtualInvokeExpr jVirtualInvokeExpr = Jimple.newVirtualInvokeExpr(base, methodSig, args);
            } else {
                if (!callee.isInterface()) throw new RuntimeException("Unsupported invoke instruction: " + callee.toString());
                JInterfaceInvokeExpr jInterfaceInvokeExpr = Jimple.newInterfaceInvokeExpr(base, methodSig, args);
            }
        } else {
            JStaticInvokeExpr jStaticInvokeExpr = Jimple.newStaticInvokeExpr(methodSig, args);
        }
        if (invokeInst.hasDef()) {
            Type type = this.converter.convertType(invokeInst.getDeclaredResultType());
            Local v = this.getLocal(type, invokeInst.getDef());
            JAssignStmt<Local, void> jAssignStmt = Jimple.newAssignStmt(v, var2_31, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(invokeInst.iIndex()), operandPos));
            return var13_22;
        } else {
            JInvokeStmt jInvokeStmt = Jimple.newInvokeStmt((AbstractInvokeExpr)var2_31, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(invokeInst.iIndex()), operandPos));
        }
        return var13_22;
    }

    private List<Stmt> convertBranchInstruction(SSAConditionalBranchInstruction condInst) {
        AbstractConditionExpr condition;
        StmtPositionInfo posInfo = WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(condInst.iIndex()), null);
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        int val1 = condInst.getUse(0);
        int val2 = condInst.getUse(1);
        Immediate value1 = this.extractValueAndAddAssignStmt(posInfo, stmts, val1);
        Immediate value2 = this.extractValueAndAddAssignStmt(posInfo, stmts, val2);
        IConditionalBranchInstruction.IOperator op = condInst.getOperator();
        if (op.equals(IConditionalBranchInstruction.Operator.EQ)) {
            condition = Jimple.newEqExpr(value1, value2);
        } else if (op.equals(IConditionalBranchInstruction.Operator.NE)) {
            condition = Jimple.newNeExpr(value1, value2);
        } else if (op.equals(IConditionalBranchInstruction.Operator.LT)) {
            condition = Jimple.newLtExpr(value1, value2);
        } else if (op.equals(IConditionalBranchInstruction.Operator.GE)) {
            condition = Jimple.newGeExpr(value1, value2);
        } else if (op.equals(IConditionalBranchInstruction.Operator.GT)) {
            condition = Jimple.newGtExpr(value1, value2);
        } else if (op.equals(IConditionalBranchInstruction.Operator.LE)) {
            condition = Jimple.newLtExpr(value1, value2);
        } else {
            throw new RuntimeException("Unsupported conditional operator: " + op);
        }
        JIfStmt ifStmt = Jimple.newIfStmt(condition, posInfo);
        this.branchingTargetsOfIfStmts.put(ifStmt, condInst.getTarget());
        stmts.add(ifStmt);
        return stmts;
    }

    private Immediate extractValueAndAddAssignStmt(StmtPositionInfo posInfo, List<Stmt> addTo, int val) {
        Acceptor<ConstantVisitor> value;
        Object constant = null;
        if (this.symbolTable.isZero(val)) {
            value = IntConstant.getInstance(0);
        } else {
            if (this.symbolTable.isConstant(val)) {
                constant = this.symbolTable.getConstantValue(val);
            }
            value = this.getLocal(PrimitiveType.getInt(), val);
        }
        if (constant != null) {
            JAssignStmt<IntConstant, Constant> assignStmt = Jimple.newAssignStmt(value, ConstantUtil.fromObject(constant), posInfo);
            addTo.add(assignStmt);
        }
        return value;
    }

    private Stmt convertReturnInstruction(SSAReturnInstruction inst) {
        int result = inst.getResult();
        if (inst.returnsVoid()) {
            return Jimple.newReturnVoidStmt(WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), null));
        }
        Acceptor<ConstantVisitor> ret = this.symbolTable.isConstant(result) ? this.getConstant(result) : this.getLocal(UnknownType.getInstance(), result);
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[]{this.debugInfo.getOperandPosition(inst.iIndex(), 0)};
        return Jimple.newReturnStmt(ret, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private List<Stmt> convertStringAddition(Immediate op1, Immediate op2, Immediate result, Type type, int iindex, AstMethod.DebuggingInformation debugInfo) {
        ArrayList<Stmt> ret = new ArrayList<Stmt>();
        CAstSourcePositionMap.Position p1 = debugInfo.getOperandPosition(iindex, 0);
        CAstSourcePositionMap.Position p2 = debugInfo.getOperandPosition(iindex, 1);
        CAstSourcePositionMap.Position stmtPosition = debugInfo.getInstructionPosition(iindex);
        JavaClassType sbType = (JavaClassType)this.identifierFactory.getClassType("java.lang.StringBuilder");
        Local strBuilderLocal = this.localGenerator.generateLocal(sbType);
        JAssignStmt<Local, JNewExpr> newStmt = Jimple.newAssignStmt(strBuilderLocal, Jimple.newNewExpr(sbType), WalaIRToJimpleConverter.convertPositionInfo(stmtPosition, null));
        ret.add(newStmt);
        MethodSignature initMethod = this.identifierFactory.getMethodSignature("<init>", sbType.getFullyQualifiedName(), VoidType.getInstance().toString(), Collections.singletonList(type.toString()));
        CAstSourcePositionMap.Position[] pos1 = new CAstSourcePositionMap.Position[]{null, p1};
        JInvokeStmt specStmt = Jimple.newInvokeStmt(Jimple.newSpecialInvokeExpr(strBuilderLocal, initMethod, op1), WalaIRToJimpleConverter.convertPositionInfo(stmtPosition, pos1));
        ret.add(specStmt);
        MethodSignature appendMethod = this.identifierFactory.getMethodSignature("append", sbType.getFullyQualifiedName(), sbType.toString(), Collections.singletonList(type.toString()));
        Local strBuilderLocal2 = this.localGenerator.generateLocal(sbType);
        CAstSourcePositionMap.Position[] pos2 = new CAstSourcePositionMap.Position[]{null, p2};
        JAssignStmt<Local, JVirtualInvokeExpr> virStmt = Jimple.newAssignStmt(strBuilderLocal2, Jimple.newVirtualInvokeExpr(strBuilderLocal, appendMethod, op2), WalaIRToJimpleConverter.convertPositionInfo(stmtPosition, pos2));
        ret.add(virStmt);
        MethodSignature toStringMethod = this.identifierFactory.getMethodSignature("toString", sbType.getFullyQualifiedName(), sbType.toString(), Collections.emptyList());
        JAssignStmt<Immediate, JVirtualInvokeExpr> toStringStmt = Jimple.newAssignStmt(result, Jimple.newVirtualInvokeExpr(strBuilderLocal2, toStringMethod), WalaIRToJimpleConverter.convertPositionInfo(stmtPosition, null));
        ret.add(toStringStmt);
        return ret;
    }

    private List<Stmt> convertBinaryOpInstruction(SSABinaryOpInstruction binOpInst) {
        CAstSourcePositionMap.Position p2;
        CAstSourcePositionMap.Position p1;
        AbstractBinopExpr binExpr;
        IBinaryOpInstruction.IOperator operator;
        ArrayList<Stmt> ret = new ArrayList<Stmt>();
        int def = binOpInst.getDef();
        int val1 = binOpInst.getUse(0);
        int val2 = binOpInst.getUse(1);
        Type type = UnknownType.getInstance();
        Acceptor<ConstantVisitor> op1 = this.symbolTable.isConstant(val1) ? this.getConstant(val1) : this.getLocal(type, val1);
        type = op1.getType();
        Acceptor<ConstantVisitor> op2 = this.symbolTable.isConstant(val2) ? this.getConstant(val2) : this.getLocal(type, val2);
        if (type.equals(UnknownType.getInstance())) {
            type = op2.getType();
        }
        if ((operator = binOpInst.getOperator()).equals(IBinaryOpInstruction.Operator.ADD)) {
            if (type.toString().equals("java.lang.String")) {
                Local result = this.getLocal(type, def);
                return this.convertStringAddition((Immediate)((Object)op1), (Immediate)((Object)op2), result, type, binOpInst.iIndex(), this.debugInfo);
            }
            binExpr = Jimple.newAddExpr(op1, op2);
        } else if (operator.equals(IBinaryOpInstruction.Operator.SUB)) {
            binExpr = Jimple.newSubExpr(op1, op2);
        } else if (operator.equals(IBinaryOpInstruction.Operator.MUL)) {
            binExpr = Jimple.newMulExpr(op1, op2);
        } else if (operator.equals(IBinaryOpInstruction.Operator.DIV)) {
            binExpr = Jimple.newDivExpr(op1, op2);
        } else if (operator.equals(IBinaryOpInstruction.Operator.REM)) {
            binExpr = Jimple.newRemExpr(op1, op2);
        } else if (operator.equals(IBinaryOpInstruction.Operator.AND)) {
            binExpr = Jimple.newAndExpr(op1, op2);
        } else if (operator.equals(IBinaryOpInstruction.Operator.OR)) {
            binExpr = Jimple.newOrExpr(op1, op2);
        } else if (operator.equals(IBinaryOpInstruction.Operator.XOR)) {
            binExpr = Jimple.newXorExpr(op1, op2);
        } else if (operator.equals(CAstBinaryOp.EQ)) {
            binExpr = Jimple.newEqExpr(op1, op2);
            type = PrimitiveType.getBoolean();
        } else if (operator.equals(CAstBinaryOp.NE)) {
            binExpr = Jimple.newNeExpr(op1, op2);
            type = PrimitiveType.getBoolean();
        } else if (operator.equals(CAstBinaryOp.LT)) {
            binExpr = Jimple.newLtExpr(op1, op2);
            type = PrimitiveType.getBoolean();
        } else if (operator.equals(CAstBinaryOp.GE)) {
            binExpr = Jimple.newGeExpr(op1, op2);
            type = PrimitiveType.getBoolean();
        } else if (operator.equals(CAstBinaryOp.GT)) {
            binExpr = Jimple.newGtExpr(op1, op2);
            type = PrimitiveType.getBoolean();
        } else if (operator.equals(CAstBinaryOp.LE)) {
            binExpr = Jimple.newLeExpr(op1, op2);
            type = PrimitiveType.getBoolean();
        } else if (operator.equals(IShiftInstruction.Operator.SHL)) {
            binExpr = Jimple.newShlExpr(op1, op2);
        } else if (operator.equals(IShiftInstruction.Operator.SHR)) {
            binExpr = Jimple.newShrExpr(op1, op2);
        } else if (operator.equals(IShiftInstruction.Operator.USHR)) {
            binExpr = Jimple.newUshrExpr(op1, op2);
        } else {
            throw new RuntimeException("Unsupported binary operator: " + operator.getClass());
        }
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[]{p1 = this.debugInfo.getOperandPosition(binOpInst.iIndex(), 0), p2 = this.debugInfo.getOperandPosition(binOpInst.iIndex(), 1)};
        Local result = this.getLocal(type, def);
        ret.add(Jimple.newAssignStmt(result, binExpr, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(binOpInst.iIndex()), operandPos)));
        return ret;
    }

    private Stmt convertGoToInstruction(SSAGotoInstruction gotoInst) {
        JGotoStmt gotoStmt = Jimple.newGotoStmt(WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(gotoInst.iIndex()), null));
        this.branchingTargetsOfGotoStmts.put(gotoStmt, gotoInst.getTarget());
        return gotoStmt;
    }

    private Stmt convertGetInstruction(SSAGetInstruction inst) {
        int def = inst.getDef(0);
        FieldReference fieldRef = inst.getDeclaredField();
        Type fieldType = this.converter.convertType(inst.getDeclaredFieldType());
        String walaClassName = fieldRef.getDeclaringClass().getName().toString();
        JavaClassType classSig = (JavaClassType)this.identifierFactory.getClassType(this.converter.convertClassNameFromWala(walaClassName));
        FieldSignature fieldSig = this.identifierFactory.getFieldSignature(fieldRef.getName().toString(), (ClassType)classSig, fieldType.toString());
        JFieldRef rvalue = null;
        if (inst.isStatic()) {
            rvalue = Jimple.newStaticFieldRef(fieldSig);
        } else {
            int ref = inst.getRef();
            Local base = this.getLocal(classSig, ref);
            rvalue = Jimple.newInstanceFieldRef(base, fieldSig);
        }
        CAstSourcePositionMap.Position[] operandPos = new CAstSourcePositionMap.Position[]{this.debugInfo.getOperandPosition(inst.iIndex(), 0)};
        Local var = this.getLocal(fieldType, def);
        return Jimple.newAssignStmt(var, rvalue, WalaIRToJimpleConverter.convertPositionInfo(this.debugInfo.getInstructionPosition(inst.iIndex()), operandPos));
    }

    private Constant getConstant(int valueNumber) {
        Object value = this.symbolTable.getConstantValue(valueNumber);
        if (value instanceof Boolean) {
            return BooleanConstant.getInstance((Boolean)value);
        }
        if (value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer) {
            return IntConstant.getInstance((Integer)value);
        }
        if (this.symbolTable.isLongConstant(valueNumber)) {
            return LongConstant.getInstance((Long)value);
        }
        if (this.symbolTable.isDoubleConstant(valueNumber)) {
            return DoubleConstant.getInstance((Double)value);
        }
        if (this.symbolTable.isFloatConstant(valueNumber)) {
            return FloatConstant.getInstance(((Float)value).floatValue());
        }
        if (this.symbolTable.isStringConstant(valueNumber)) {
            return JavaJimple.getInstance().newStringConstant((String)value);
        }
        if (this.symbolTable.isNullConstant(valueNumber)) {
            return NullConstant.getInstance();
        }
        throw new RuntimeException("Unsupported constant type: " + value.getClass().toString());
    }

    private Local getLocal(Type type, int valueNumber) {
        Local para;
        Local cachedLocal = this.locals.get(valueNumber);
        if (cachedLocal != null) {
            return cachedLocal;
        }
        if (valueNumber == 1 && !this.walaMethod.isStatic()) {
            Local thisLocal = this.localGenerator.getThisLocal();
            this.locals.put(valueNumber, thisLocal);
            return thisLocal;
        }
        if (this.symbolTable.isParameter(valueNumber) && (para = this.localGenerator.getParameterLocal(valueNumber - 1)) != null) {
            return para;
        }
        Local ret = this.locals.computeIfAbsent(valueNumber, key -> this.localGenerator.generateLocal(type));
        if (!ret.getType().equals(type)) {
            // empty if block
        }
        return ret;
    }

    protected Map<BranchingStmt, List<Stmt>> setUpTargets(HashMap<Integer, Stmt> stmt2iIndex) {
        Integer value;
        BranchingStmt key;
        HashMap<BranchingStmt, List<Stmt>> branchingMap = new HashMap<BranchingStmt, List<Stmt>>();
        for (Map.Entry<JIfStmt, Integer> entry : this.branchingTargetsOfIfStmts.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            branchingMap.put(key, Collections.singletonList(stmt2iIndex.get(value)));
        }
        for (Map.Entry<BranchingStmt, Integer> entry : this.branchingTargetsOfGotoStmts.entrySet()) {
            key = (JGotoStmt)entry.getKey();
            value = entry.getValue();
            branchingMap.put(key, Collections.singletonList(stmt2iIndex.get(value)));
        }
        for (Map.Entry<BranchingStmt, Object> entry : this.branchingTargetsOfLookUpSwitchStmts.entrySet()) {
            JSwitchStmt switchStmt = (JSwitchStmt)entry.getKey();
            List targetIdxList = (List)entry.getValue();
            ArrayList<Stmt> targets = new ArrayList<Stmt>(targetIdxList.size());
            for (Integer targetIdx : targetIdxList) {
                targets.add(stmt2iIndex.get(targetIdx));
            }
            branchingMap.put(switchStmt, targets);
        }
        return branchingMap;
    }

    public boolean hasJumpTarget(Integer i) {
        if (this.branchingTargetsOfIfStmts.containsValue(i)) {
            return true;
        }
        if (this.branchingTargetsOfGotoStmts.containsValue(i)) {
            return true;
        }
        for (List<Integer> list : this.branchingTargetsOfLookUpSwitchStmts.values()) {
            if (!list.contains(i)) continue;
            return true;
        }
        return false;
    }
}

