/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.sourcecode.frontend;

import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.loader.AstClass;
import com.ibm.wala.cast.loader.AstField;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.frontend.BodySource;
import sootup.core.frontend.OverridingBodySource;
import sootup.core.graph.MutableBlockStmtGraph;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.LocalGenerator;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JReturnVoidStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.model.SourceType;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.VoidType;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.JavaSootClass;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.OverridingJavaClassSource;
import sootup.java.core.types.AnnotationType;
import sootup.java.core.types.JavaClassType;
import sootup.java.sourcecode.frontend.InstructionConverter;
import sootup.java.sourcecode.frontend.WalaSootMethod;
import sootup.java.sourcecode.inputlocation.JavaSourcePathAnalysisInputLocation;

public class WalaIRToJimpleConverter {
    final JavaIdentifierFactory identifierFactory;
    private final AnalysisInputLocation srcNamespace;
    private final HashMap<String, Integer> clsWithInnerCls;
    private final HashMap<String, String> walaToSootNameTable;
    private Set<SootField> sootFields;

    public WalaIRToJimpleConverter(@Nonnull Set<String> sourceDirPath) {
        this.srcNamespace = new JavaSourcePathAnalysisInputLocation(sourceDirPath);
        this.identifierFactory = JavaIdentifierFactory.getInstance();
        this.clsWithInnerCls = new HashMap();
        this.walaToSootNameTable = new HashMap();
    }

    public WalaIRToJimpleConverter(@Nonnull Set<String> sourceDirPath, @Nonnull SourceType srcType) {
        this.srcNamespace = new JavaSourcePathAnalysisInputLocation(srcType, sourceDirPath);
        this.identifierFactory = JavaIdentifierFactory.getInstance();
        this.clsWithInnerCls = new HashMap();
        this.walaToSootNameTable = new HashMap();
    }

    @Deprecated
    public SootClass convertClass(AstClass walaClass) {
        JavaSootClassSource classSource = this.convertToClassSource(walaClass);
        return new JavaSootClass(classSource, SourceType.Application);
    }

    JavaSootClassSource convertToClassSource(AstClass walaClass) {
        JavaSourceLoaderImpl.JavaClass javaClass;
        IClass ec;
        String fullyQualifiedClassName = this.convertClassNameFromWala(walaClass.getName().toString());
        JavaClassType classSig = this.identifierFactory.getClassType(fullyQualifiedClassName);
        IClass sc = walaClass.getSuperclass();
        JavaClassType superClass = null;
        if (sc != null) {
            superClass = this.identifierFactory.getClassType(this.convertClassNameFromWala(sc.getName().toString()));
        }
        HashSet<ClassType> interfaces = new HashSet<ClassType>();
        for (IClass i : walaClass.getDirectInterfaces()) {
            JavaClassType inter = this.identifierFactory.getClassType(this.convertClassNameFromWala(i.getName().toString()));
            interfaces.add(inter);
        }
        JavaClassType outerClass = null;
        if (walaClass instanceof JavaSourceLoaderImpl.JavaClass && (ec = (javaClass = (JavaSourceLoaderImpl.JavaClass)walaClass).getEnclosingClass()) != null) {
            outerClass = this.identifierFactory.getClassType(this.convertClassNameFromWala(ec.getName().toString()));
        }
        CAstSourcePositionMap.Position position = walaClass.getSourcePosition();
        EnumSet<Modifier> modifiers = this.convertModifiers(walaClass);
        HashSet<IField> fields = HashSetFactory.make(walaClass.getDeclaredInstanceFields());
        fields.addAll(walaClass.getDeclaredStaticFields());
        this.sootFields = new HashSet<SootField>();
        for (IField walaField : fields) {
            SootField sootField = this.convertField(classSig, (AstField)walaField);
            this.sootFields.add(sootField);
        }
        if (outerClass != null) {
            FieldSignature signature = this.identifierFactory.getFieldSignature("this$0", (ClassType)classSig, outerClass);
            SootField enclosingObject = new SootField(signature, (Iterable<Modifier>)EnumSet.of(Modifier.FINAL), (Position)NoPositionInformation.getInstance());
            this.sootFields.add(enclosingObject);
        }
        HashSet<SootMethod> sootMethods = new HashSet<SootMethod>();
        for (IMethod iMethod : walaClass.getDeclaredMethods()) {
            SootMethod sootMethod = this.convertMethod(classSig, (AstMethod)iMethod);
            sootMethods.add(sootMethod);
        }
        return this.createClassSource(walaClass, superClass, interfaces, outerClass, this.sootFields, sootMethods, position, modifiers, Collections.emptyList());
    }

    public OverridingJavaClassSource createClassSource(AstClass walaClass, JavaClassType superClass, Set<ClassType> interfaces, JavaClassType outerClass, Set<SootField> sootFields, Set<SootMethod> sootMethods, CAstSourcePositionMap.Position position, EnumSet<Modifier> modifiers, Iterable<AnnotationType> annotations) {
        String fullyQualifiedClassName = this.convertClassNameFromWala(walaClass.getName().toString());
        JavaClassType classSignature = this.identifierFactory.getClassType(fullyQualifiedClassName);
        URL url = walaClass.getSourceURL();
        Path sourcePath = Paths.get(url.getPath(), new String[0]);
        return new OverridingJavaClassSource(this.srcNamespace, sourcePath, classSignature, superClass, interfaces, outerClass, sootFields, sootMethods, WalaIRToJimpleConverter.convertPosition(position), modifiers, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public SootField convertField(JavaClassType classSig, AstField walaField) {
        Type type = this.convertType(walaField.getFieldTypeReference());
        EnumSet<Modifier> modifiers = this.convertModifiers(walaField);
        FieldSignature signature = this.identifierFactory.getFieldSignature(walaField.getName().toString(), (ClassType)classSig, type);
        return new SootField(signature, (Iterable<Modifier>)modifiers, (Position)NoPositionInformation.getInstance());
    }

    public SootMethod convertMethod(JavaClassType classSig, AstMethod walaMethod) {
        ArrayList<Type> paraTypes = new ArrayList<Type>();
        ArrayList<String> sigs = new ArrayList<String>();
        if (walaMethod.symbolTable() != null) {
            int i;
            int n = i = walaMethod.isStatic() ? 0 : 1;
            while (i < walaMethod.getNumberOfParameters()) {
                TypeReference type = walaMethod.getParameterType(i);
                Type paraType = this.convertType(type);
                paraTypes.add(this.identifierFactory.getType(paraType.toString()));
                sigs.add(paraType.toString());
                ++i;
            }
        }
        Type returnType = this.convertType(walaMethod.getReturnType());
        EnumSet<Modifier> modifiers = this.convertModifiers(walaMethod);
        ArrayList<ClassType> thrownExceptions = new ArrayList<ClassType>();
        try {
            for (TypeReference exception : walaMethod.getDeclaredExceptions()) {
                String exceptionName = this.convertClassNameFromWala(exception.getName().toString());
                JavaClassType exceptionSig = this.identifierFactory.getClassType(exceptionName);
                thrownExceptions.add(exceptionSig);
            }
        }
        catch (InvalidClassFileException | UnsupportedOperationException e) {
            e.printStackTrace();
        }
        AstMethod.DebuggingInformation debugInfo = walaMethod.debugInfo();
        MethodSignature methodSig = this.identifierFactory.getMethodSignature((ClassType)classSig, walaMethod.getName().toString(), returnType.toString(), sigs);
        Body body = this.createBody(methodSig, modifiers, walaMethod);
        return new WalaSootMethod((BodySource)new OverridingBodySource(methodSig, body), methodSig, modifiers, thrownExceptions, debugInfo);
    }

    public Type convertType(TypeReference type) {
        if (type.isPrimitiveType()) {
            if (type.equals(TypeReference.Boolean)) {
                return PrimitiveType.getBoolean();
            }
            if (type.equals(TypeReference.Byte)) {
                return PrimitiveType.getByte();
            }
            if (type.equals(TypeReference.Char)) {
                return PrimitiveType.getChar();
            }
            if (type.equals(TypeReference.Short)) {
                return PrimitiveType.getShort();
            }
            if (type.equals(TypeReference.Int)) {
                return PrimitiveType.getInt();
            }
            if (type.equals(TypeReference.Long)) {
                return PrimitiveType.getLong();
            }
            if (type.equals(TypeReference.Float)) {
                return PrimitiveType.getFloat();
            }
            if (type.equals(TypeReference.Double)) {
                return PrimitiveType.getDouble();
            }
            if (type.equals(TypeReference.Void)) {
                return VoidType.getInstance();
            }
        } else if (type.isReferenceType()) {
            if (type.isArrayType()) {
                TypeReference t = type.getInnermostElementType();
                Type baseType = this.convertType(t);
                int dim = type.getDimensionality();
                return this.identifierFactory.getArrayType(baseType, dim);
            }
            if (type.isClassType()) {
                if (type.equals(TypeReference.Null)) {
                    return NullType.getInstance();
                }
                String className = this.convertClassNameFromWala(type.getName().toString());
                return this.identifierFactory.getClassType(className);
            }
        }
        throw new RuntimeException("Unsupported type: " + type);
    }

    public EnumSet<Modifier> convertModifiers(AstField field) {
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (field.isFinal()) {
            modifiers.add(Modifier.FINAL);
        }
        if (field.isPrivate()) {
            modifiers.add(Modifier.PRIVATE);
        }
        if (field.isProtected()) {
            modifiers.add(Modifier.PROTECTED);
        }
        if (field.isPublic()) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (field.isStatic()) {
            modifiers.add(Modifier.STATIC);
        }
        if (field.isVolatile()) {
            modifiers.add(Modifier.VOLATILE);
        }
        return modifiers;
    }

    public EnumSet<Modifier> convertModifiers(AstMethod method) {
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (method.isPrivate()) {
            modifiers.add(Modifier.PRIVATE);
        }
        if (method.isProtected()) {
            modifiers.add(Modifier.PROTECTED);
        }
        if (method.isPublic()) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (method.isStatic()) {
            modifiers.add(Modifier.STATIC);
        }
        if (method.isFinal()) {
            modifiers.add(Modifier.FINAL);
        }
        if (method.isAbstract()) {
            modifiers.add(Modifier.ABSTRACT);
        }
        if (method.isSynchronized()) {
            modifiers.add(Modifier.SYNCHRONIZED);
        }
        if (method.isNative()) {
            modifiers.add(Modifier.NATIVE);
        }
        if (method.isSynthetic()) {
            modifiers.add(Modifier.SYNTHETIC);
        }
        if (method.isBridge()) {
            modifiers.add(Modifier.VOLATILE);
        }
        return modifiers;
    }

    public EnumSet<Modifier> convertModifiers(AstClass klass) {
        int modif = klass.getModifiers();
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (klass.isAbstract()) {
            modifiers.add(Modifier.ABSTRACT);
        }
        if (klass.isPrivate()) {
            modifiers.add(Modifier.PRIVATE);
        }
        if (klass.isSynthetic()) {
            modifiers.add(Modifier.SYNTHETIC);
        }
        if (klass.isPublic()) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (klass.isInterface()) {
            modifiers.add(Modifier.INTERFACE);
        }
        if (klass.getSuperclass().getName().toString().equals("Ljava/lang/Enum")) {
            modifiers.add(Modifier.ENUM);
        }
        if ((modif & 0x10) != 0) {
            modifiers.add(Modifier.FINAL);
        }
        return modifiers;
    }

    @Nonnull
    private Body createBody(MethodSignature methodSignature, EnumSet<Modifier> modifiers, AstMethod walaMethod) {
        if (walaMethod.isAbstract()) {
            return Body.builder().setMethodSignature(methodSignature).build();
        }
        ArrayList<Trap> traps = new ArrayList<Trap>();
        ArrayList<Stmt> stmtList = new ArrayList<Stmt>();
        AbstractCFG<?, ?> cfg = walaMethod.cfg();
        if (cfg != null) {
            LocalGenerator localGenerator = new LocalGenerator(new LinkedHashSet<Local>());
            SSAInstruction[] insts = (SSAInstruction[])cfg.getInstructions();
            if (insts.length > 0) {
                JIdentityStmt<JParameterRef> stmt;
                Local paraLocal;
                Type type;
                int i;
                Stmt stmt2;
                AstMethod.DebuggingInformation debugInfo = walaMethod.debugInfo();
                CAstSourcePositionMap.Position bodyPos = debugInfo.getCodeBodyPosition();
                if (!Modifier.isStatic(modifiers)) {
                    JavaClassType thisType = (JavaClassType)methodSignature.getDeclClassType();
                    Local thisLocal = localGenerator.generateThisLocal(thisType);
                    stmt2 = Jimple.newIdentityStmt(thisLocal, Jimple.newThisRef(thisType), WalaIRToJimpleConverter.convertPositionInfo(debugInfo.getInstructionPosition(0), null));
                    stmtList.add(stmt2);
                }
                if (walaMethod.isStatic()) {
                    for (i = 0; i < walaMethod.getNumberOfParameters(); ++i) {
                        type = this.convertType(walaMethod.getParameterType(i));
                        paraLocal = localGenerator.generateParameterLocal(type, i);
                        stmt = Jimple.newIdentityStmt(paraLocal, Jimple.newParameterRef(type, i), WalaIRToJimpleConverter.convertPositionInfo(debugInfo.getInstructionPosition(0), null));
                        stmtList.add(stmt);
                    }
                } else {
                    for (i = 1; i < walaMethod.getNumberOfParameters(); ++i) {
                        type = this.convertType(walaMethod.getParameterType(i));
                        paraLocal = localGenerator.generateParameterLocal(type, i);
                        stmt = Jimple.newIdentityStmt(paraLocal, Jimple.newParameterRef(type, i - 1), WalaIRToJimpleConverter.convertPositionInfo(debugInfo.getInstructionPosition(0), null));
                        stmtList.add(stmt);
                    }
                }
                InstructionConverter instConverter = new InstructionConverter(this, methodSignature, walaMethod, localGenerator);
                HashMap<Integer, Stmt> index2Stmt = new HashMap<Integer, Stmt>();
                stmt2 = null;
                boolean isVoidMethod = walaMethod.getReturnType().equals(TypeReference.Void);
                for (SSAInstruction inst : insts) {
                    List<Stmt> retStmts;
                    if (!isVoidMethod && inst instanceof SSAGotoInstruction && ((SSAGotoInstruction)inst).getTarget() == -1 || (retStmts = instConverter.convertInstruction(inst, index2Stmt)).isEmpty()) continue;
                    int retStmtsSize = retStmts.size();
                    stmt2 = retStmts.get(0);
                    stmtList.add(stmt2);
                    index2Stmt.put(inst.iIndex(), stmt2);
                    for (int i2 = 1; i2 < retStmtsSize; ++i2) {
                        stmt2 = retStmts.get(i2);
                        stmtList.add(stmt2);
                    }
                }
                if (isVoidMethod) {
                    Stmt ret;
                    boolean validMethodLeaving;
                    boolean isImplicitLastStmtTargetOfBranchStmt = instConverter.hasJumpTarget(-1);
                    boolean bl = validMethodLeaving = !(stmt2 instanceof JReturnVoidStmt) && !(stmt2 instanceof JThrowStmt);
                    if (index2Stmt.isEmpty() || validMethodLeaving || isImplicitLastStmtTargetOfBranchStmt) {
                        ret = Jimple.newReturnVoidStmt(WalaIRToJimpleConverter.convertPositionInfo(debugInfo.getInstructionPosition(insts.length - 1), null));
                        stmtList.add(ret);
                    } else {
                        ret = stmt2;
                    }
                    index2Stmt.put(-1, ret);
                }
                Map<BranchingStmt, List<Stmt>> branchingMap = instConverter.setUpTargets(index2Stmt);
                for (Map.Entry<IBasicBlock<SSAInstruction>, TypeReference[]> catchBlockEntry : walaMethod.catchTypes().entrySet()) {
                    IBasicBlock<SSAInstruction> block = catchBlockEntry.getKey();
                    TypeReference[] typeReferenceArray = catchBlockEntry.getValue();
                }
                MutableBlockStmtGraph graph = new MutableBlockStmtGraph();
                graph.initializeWith(stmtList, branchingMap, traps);
                return Body.builder(graph).setMethodSignature(methodSignature).setLocals(localGenerator.getLocals()).setPosition(WalaIRToJimpleConverter.convertPosition(bodyPos)).build();
            }
        }
        throw new IllegalStateException("can not create Body - no CFG from WALA present.");
    }

    public String convertClassNameFromWala(String className) {
        String cl = className.intern();
        String sootName = this.walaToSootNameTable.get(cl);
        if (sootName != null) {
            return sootName;
        }
        StringBuilder sb = new StringBuilder();
        if (className.startsWith("L")) {
            String lastSubName;
            String[] temp;
            className = className.substring(1);
            String[] subNames = className.split("/");
            boolean isSpecial = false;
            for (String subName : subNames) {
                if (subName.contains("(") || subName.contains("<")) {
                    isSpecial = true;
                    break;
                }
                sb.append(subName).append('.');
            }
            if (subNames.length != 0) {
                sb.setLength(sb.length() - 1);
            }
            if (isSpecial && (temp = (lastSubName = subNames[subNames.length - 1]).split(">")).length > 0) {
                String name = temp[temp.length - 1];
                if (!name.contains("$")) {
                    String outClass = sb.toString();
                    Integer innerClassCount = this.clsWithInnerCls.get(outClass);
                    int count = innerClassCount != null ? innerClassCount + 1 : 1;
                    this.clsWithInnerCls.put(outClass, count);
                    sb.append(count).append("$");
                }
                sb.append(name);
            }
        } else {
            throw new RuntimeException("Can not convert WALA class name: " + className);
        }
        String ret = sb.toString();
        this.walaToSootNameTable.put(cl, ret);
        return ret;
    }

    public String convertClassNameFromSoot(String signature) {
        return "L" + signature.replace('.', '/');
    }

    protected void addSootField(SootField field) {
        if (this.sootFields != null) {
            this.sootFields.add(field);
        }
    }

    public static Position convertPosition(CAstSourcePositionMap.Position instructionPosition) {
        return new Position(instructionPosition.getFirstLine(), instructionPosition.getFirstCol(), instructionPosition.getLastLine(), instructionPosition.getLastCol());
    }

    public static StmtPositionInfo convertPositionInfo(CAstSourcePositionMap.Position instructionPosition, CAstSourcePositionMap.Position[] operandPosition) {
        if (operandPosition == null) {
            return new StmtPositionInfo(WalaIRToJimpleConverter.convertPosition(instructionPosition), null);
        }
        Position[] operandPos = (Position[])Arrays.stream(operandPosition).map(instrPos -> instrPos == null ? null : new Position(instrPos.getFirstLine(), instrPos.getFirstCol(), instrPos.getLastLine(), instrPos.getLastCol())).toArray(Position[]::new);
        return new StmtPositionInfo(WalaIRToJimpleConverter.convertPosition(instructionPosition), operandPos);
    }
}

