/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.sourcecode.frontend;

import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.dalvik.classLoader.DexFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.warnings.Warnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.SourceTypeSpecifier;
import sootup.core.frontend.ClassProvider;
import sootup.core.frontend.ResolveException;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.model.SootClass;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;
import sootup.java.core.JavaSootClass;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.types.JavaClassType;
import sootup.java.sourcecode.frontend.WalaIRToJimpleConverter;

public class WalaJavaClassProvider
implements ClassProvider<JavaSootClass> {
    private Set<String> sourcePath;
    private IClassHierarchy classHierarchy;
    private List<SootClass<?>> sootClasses;
    private List<SootClassSource<JavaSootClass>> classSources;
    private AnalysisScope scope;
    private ClassLoaderFactory factory;
    private final File walaPropertiesFile = new File("target/classes/wala.properties");

    public WalaJavaClassProvider(@Nonnull String sourceDirPath) {
        this(sourceDirPath, null);
    }

    public WalaJavaClassProvider(@Nonnull String sourceDirPath, @Nullable String exclusionFilePath) {
        this(Collections.singleton(sourceDirPath), exclusionFilePath);
    }

    public WalaJavaClassProvider(@Nonnull Set<String> sourcePath) {
        this(sourcePath, (String)null);
    }

    public WalaJavaClassProvider(@Nonnull Set<String> sourcePath, @Nullable String exclusionFilePath) {
        this.addScopesForJava();
        this.sourcePath = sourcePath;
        for (String path : sourcePath) {
            this.scope.addToScope(JavaSourceAnalysisScope.SOURCE, new SourceDirectoryTreeModule(new File(path)));
        }
        this.setExclusions(exclusionFilePath);
        this.factory = new ECJClassLoaderFactory(this.scope.getExclusions());
    }

    public WalaJavaClassProvider(@Nonnull Set<String> sourcePath, @Nonnull Set<String> libPath, @Nonnull String exclusionFilePath) {
        this.addScopesForJava();
        this.sourcePath = sourcePath;
        for (String path : sourcePath) {
            this.scope.addToScope(JavaSourceAnalysisScope.SOURCE, new SourceDirectoryTreeModule(new File(path)));
        }
        try {
            for (String libJar : libPath) {
                this.scope.addToScope(ClassLoaderReference.Primordial, new JarFile(libJar));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setExclusions(exclusionFilePath);
        this.factory = new ECJClassLoaderFactory(this.scope.getExclusions());
    }

    public WalaJavaClassProvider(@Nonnull Set<String> sourcePath, @Nonnull String apkPath, @Nonnull String androidJar, @Nullable String exclusionFilePath) {
        this.addScopesForJava();
        this.sourcePath = sourcePath;
        try {
            for (String path : sourcePath) {
                this.scope.addToScope(JavaSourceAnalysisScope.SOURCE, new SourceDirectoryTreeModule(new File(path)));
            }
            this.scope.setLoaderImpl(ClassLoaderReference.Application, "com.ibm.wala.dalvik.classLoader.WDexClassLoaderImpl");
            this.scope.addToScope(ClassLoaderReference.Primordial, new JarFile(androidJar));
            this.scope.addToScope(ClassLoaderReference.Application, DexFileModule.make(new File(apkPath)));
            this.setExclusions(exclusionFilePath);
            this.factory = new ECJClassLoaderFactory(this.scope.getExclusions());
        }
        catch (IOException | IllegalArgumentException e) {
            throw new RuntimeException("Failed to construct frontend.WalaJavaClassProvider", e);
        }
    }

    public WalaJavaClassProvider(@Nonnull String sourceDirPath, @Nullable String exclusionFilePath, @Nonnull SourceTypeSpecifier sourceTypeSpecifier) {
        this.addScopesForJava();
        this.sourcePath = Collections.singleton(sourceDirPath);
        this.scope.addToScope(JavaSourceAnalysisScope.SOURCE, new SourceDirectoryTreeModule(new File(sourceDirPath)));
        this.setExclusions(exclusionFilePath);
        this.factory = new ECJClassLoaderFactory(this.scope.getExclusions());
    }

    public WalaJavaClassProvider(@Nonnull Collection<? extends Module> moduleFiles, @Nonnull SourceTypeSpecifier sourceTypeSpecifier) {
        this.addScopesForJava();
        for (Module module : moduleFiles) {
            this.scope.addToScope(JavaSourceAnalysisScope.SOURCE, module);
        }
        this.factory = new ECJClassLoaderFactory(this.scope.getExclusions());
    }

    private void createWalaproperties() {
        if (!this.walaPropertiesFile.exists()) {
            try {
                PrintWriter pw = new PrintWriter(this.walaPropertiesFile);
                String jdkPath = System.getProperty("java.home");
                pw.println("java_runtime_dir = " + new File(jdkPath).toString().replace("\\", "/"));
                pw.close();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addScopesForJava() {
        this.createWalaproperties();
        System.setProperty("wala.jdt.quiet", "true");
        this.scope = new JavaSourceAnalysisScope();
        try {
            String[] stdlibs;
            for (String stdlib : stdlibs = WalaProperties.getJ2SEJarFiles()) {
                this.scope.addToScope(ClassLoaderReference.Primordial, new JarFile(stdlib));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildClassHierachy() {
        try {
            this.classHierarchy = ClassHierarchyFactory.make(this.scope, this.factory);
            Warnings.clear();
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
        }
    }

    public List<SootClassSource<JavaSootClass>> getClassSources(SourceType srcType) {
        Iterator<IClass> it = this.iterateWalaClasses();
        if (this.classSources == null) {
            this.classSources = new ArrayList<SootClassSource<JavaSootClass>>();
        }
        WalaIRToJimpleConverter walaToSoot = new WalaIRToJimpleConverter(this.sourcePath, srcType);
        while (it.hasNext()) {
            JavaSourceLoaderImpl.JavaClass walaClass = (JavaSourceLoaderImpl.JavaClass)it.next();
            JavaSootClassSource sootClass = walaToSoot.convertToClassSource(walaClass);
            this.classSources.add(sootClass);
        }
        return this.classSources;
    }

    @Deprecated
    public List<SootClass<?>> getSootClasses() {
        Iterator<IClass> it = this.iterateWalaClasses();
        if (this.sootClasses == null) {
            this.sootClasses = new ArrayList();
        }
        WalaIRToJimpleConverter walaToSoot = new WalaIRToJimpleConverter(this.sourcePath);
        while (it.hasNext()) {
            JavaSourceLoaderImpl.JavaClass walaClass = (JavaSourceLoaderImpl.JavaClass)it.next();
            SootClass sootClass = walaToSoot.convertClass(walaClass);
            this.sootClasses.add(sootClass);
        }
        return this.sootClasses;
    }

    private Iterator<IClass> iterateWalaClasses() {
        if (this.classHierarchy == null) {
            try {
                this.buildClassHierachy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.classHierarchy.getLoader(JavaSourceAnalysisScope.SOURCE).iterateAllClasses();
    }

    @Deprecated
    public Optional<SootClass> getSootClass(JavaClassType signature) {
        if (this.classHierarchy == null) {
            this.buildClassHierachy();
        }
        WalaIRToJimpleConverter walaToSoot = new WalaIRToJimpleConverter(this.sourcePath);
        JavaSourceLoaderImpl.JavaClass walaClass = this.loadWalaClass(signature, walaToSoot);
        return Optional.ofNullable(walaClass).map(walaToSoot::convertClass);
    }

    public Optional<SootClassSource<JavaSootClass>> getClassSource(ClassType signature) {
        if (this.classHierarchy == null) {
            this.buildClassHierachy();
        }
        WalaIRToJimpleConverter walaToSoot = new WalaIRToJimpleConverter(this.sourcePath);
        JavaSourceLoaderImpl.JavaClass walaClass = this.loadWalaClass(signature, walaToSoot);
        return Optional.ofNullable(walaClass).map(walaToSoot::convertToClassSource);
    }

    @Nullable
    private JavaSourceLoaderImpl.JavaClass loadWalaClass(ClassType signature, WalaIRToJimpleConverter walaToSoot) {
        String className = walaToSoot.convertClassNameFromSoot(signature.getFullyQualifiedName());
        IClass clazz = this.classHierarchy.getLoader(JavaSourceAnalysisScope.SOURCE).lookupClass(TypeName.findOrCreate(className));
        JavaSourceLoaderImpl.JavaClass walaClass = null;
        if (clazz instanceof JavaSourceLoaderImpl.JavaClass) {
            walaClass = (JavaSourceLoaderImpl.JavaClass)clazz;
        }
        if (walaClass == null && className.contains("$")) {
            Iterator<IClass> it = this.classHierarchy.getLoader(JavaSourceAnalysisScope.SOURCE).iterateAllClasses();
            while (it.hasNext()) {
                JavaSourceLoaderImpl.JavaClass c = (JavaSourceLoaderImpl.JavaClass)it.next();
                String cname = walaToSoot.convertClassNameFromWala(c.getName().toString());
                if (!cname.equals(signature.getFullyQualifiedName())) continue;
                walaClass = c;
            }
        }
        return walaClass;
    }

    private void setExclusions(@Nullable String exclusionFilePath) {
        if (exclusionFilePath == null) {
            return;
        }
        File exclusionFile = new File(exclusionFilePath);
        if (exclusionFile.isFile()) {
            try {
                FileOfClasses classes = new FileOfClasses(Files.newInputStream(exclusionFile.toPath(), new OpenOption[0]));
                this.scope.setExclusions(classes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new ResolveException("the given path to the exclusion file does not point to a file.", exclusionFile.toPath());
        }
    }

    @Override
    public SootClassSource<JavaSootClass> createClassSource(AnalysisInputLocation<? extends SootClass<?>> srcNamespace, Path sourcePath, ClassType type) {
        return this.getClassSource(type).orElse(null);
    }

    @Override
    public FileType getHandledFileType() {
        return FileType.JAVA;
    }
}

