/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.sourcecode.frontend;

import com.ibm.wala.cast.loader.AstMethod;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.frontend.BodySource;
import sootup.core.frontend.OverridingBodySource;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.model.Modifier;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.java.core.JavaSootMethod;

public class WalaSootMethod
extends JavaSootMethod {
    @Nullable
    private final AstMethod.DebuggingInformation debugInfo;

    public WalaSootMethod(@Nonnull BodySource source, @Nonnull MethodSignature methodSignature, @Nonnull Iterable<Modifier> modifiers, @Nonnull Iterable<ClassType> thrownExceptions, AstMethod.DebuggingInformation debugInfo) {
        super(source, methodSignature, modifiers, thrownExceptions, Collections.emptyList(), NoPositionInformation.getInstance());
        this.debugInfo = debugInfo;
    }

    public int getJavaSourceStartLineNumber() {
        return this.debugInfo.getCodeBodyPosition().getFirstLine();
    }

    @Nullable
    public AstMethod.DebuggingInformation getDebugInfo() {
        return this.debugInfo;
    }

    @Override
    @Nonnull
    public JavaSootMethod withOverridingMethodSource(Function<OverridingBodySource, OverridingBodySource> overrider) {
        return new WalaSootMethod((BodySource)overrider.apply(new OverridingBodySource(this.bodySource)), (MethodSignature)this.getSignature(), this.getModifiers(), (Iterable<ClassType>)this.exceptions, this.debugInfo);
    }

    @Override
    @Nonnull
    public JavaSootMethod withSource(BodySource source) {
        return new WalaSootMethod(source, (MethodSignature)this.getSignature(), this.getModifiers(), (Iterable<ClassType>)this.exceptions, this.debugInfo);
    }

    @Override
    @Nonnull
    public JavaSootMethod withModifiers(Iterable<Modifier> modifiers) {
        return new WalaSootMethod(this.bodySource, (MethodSignature)this.getSignature(), this.getModifiers(), (Iterable<ClassType>)this.exceptions, this.debugInfo);
    }

    @Override
    @Nonnull
    public JavaSootMethod withThrownExceptions(Iterable<ClassType> thrownExceptions) {
        return new WalaSootMethod(this.bodySource, (MethodSignature)this.getSignature(), this.getModifiers(), thrownExceptions, this.debugInfo);
    }

    @Nonnull
    public SootMethod withDebugInfo(AstMethod.DebuggingInformation debugInfo) {
        return new WalaSootMethod(this.bodySource, (MethodSignature)this.getSignature(), this.getModifiers(), (Iterable<ClassType>)this.exceptions, debugInfo);
    }
}

