/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.sourcecode.inputlocation;

import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.core.JavaSootClass;
import sootup.java.sourcecode.frontend.WalaJavaClassProvider;

public class JavaSourcePathAnalysisInputLocation
implements AnalysisInputLocation<JavaSootClass> {
    private static final Logger log = LoggerFactory.getLogger(JavaSourcePathAnalysisInputLocation.class);
    @Nonnull
    private final Set<String> sourcePaths;
    @Nonnull
    private final WalaJavaClassProvider classProvider;
    @Nullable
    private final String exclusionFilePath;
    private SourceType srcType = null;

    public JavaSourcePathAnalysisInputLocation(@Nonnull Set<String> sourcePaths) {
        this(sourcePaths, null);
    }

    public JavaSourcePathAnalysisInputLocation(@Nonnull String sourcePath) {
        this(Collections.singleton(sourcePath), null);
    }

    public JavaSourcePathAnalysisInputLocation(@Nonnull Set<String> sourcePaths, @Nullable String exclusionFilePath) {
        this.sourcePaths = sourcePaths;
        this.exclusionFilePath = exclusionFilePath;
        this.classProvider = new WalaJavaClassProvider(sourcePaths, exclusionFilePath);
    }

    public JavaSourcePathAnalysisInputLocation(@Nullable SourceType srcType, @Nonnull Set<String> sourcePaths) {
        this(sourcePaths, null);
        this.setSpecifiedAsBuiltInByUser(srcType);
    }

    public JavaSourcePathAnalysisInputLocation(@Nullable SourceType srcType, @Nonnull String sourcePath) {
        this(Collections.singleton(sourcePath), null);
        this.setSpecifiedAsBuiltInByUser(srcType);
    }

    public JavaSourcePathAnalysisInputLocation(@Nonnull SourceType srcType, @Nonnull Set<String> sourcePaths, @Nullable String exclusionFilePath) {
        this.sourcePaths = sourcePaths;
        this.exclusionFilePath = exclusionFilePath;
        this.classProvider = new WalaJavaClassProvider(sourcePaths, exclusionFilePath);
        this.setSpecifiedAsBuiltInByUser(srcType);
    }

    public void setSpecifiedAsBuiltInByUser(@Nullable SourceType srcType) {
        this.srcType = srcType;
    }

    @Override
    public SourceType getSourceType() {
        return this.srcType;
    }

    @Override
    @Nonnull
    public Collection<? extends AbstractClassSource<JavaSootClass>> getClassSources(@Nonnull View<?> view) {
        return this.classProvider.getClassSources(this.srcType);
    }

    @Override
    @Nonnull
    public Optional<? extends AbstractClassSource<JavaSootClass>> getClassSource(@Nonnull ClassType type, @Nonnull View<?> view) {
        for (String path : this.sourcePaths) {
            try {
                return Optional.ofNullable(this.classProvider.createClassSource((AnalysisInputLocation)this, Paths.get(path, new String[0]), type));
            }
            catch (ResolveException e) {
                log.debug(type + " not found in sourcePath " + path, e);
            }
        }
        return Optional.empty();
    }

    public String getExclusionFilePath() {
        return this.exclusionFilePath;
    }

    public int hashCode() {
        return Objects.hash(this.sourcePaths, this.exclusionFilePath);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaSourcePathAnalysisInputLocation)) {
            return false;
        }
        return this.sourcePaths.equals(((JavaSourcePathAnalysisInputLocation)o).sourcePaths) && this.exclusionFilePath.equals(((JavaSourcePathAnalysisInputLocation)o).exclusionFilePath);
    }
}

