/*
 * Decompiled with CFR 0.152.
 */
package qilin.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import qilin.util.PTAUtils;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.language.JavaJimple;

public abstract class ArtificialMethod {
    protected final View view;
    protected SootMethod method;
    protected Body.BodyBuilder bodyBuilder;
    protected Local thisLocal;
    protected Local[] paraLocals;
    protected int paraStart;
    protected int localStart;
    protected final List<Stmt> stmtList;

    protected ArtificialMethod(View view) {
        this.view = view;
        this.stmtList = new ArrayList<Stmt>();
    }

    protected Local getThis() {
        if (this.thisLocal == null) {
            ClassType type = this.method.getDeclaringClassType();
            JThisRef thisRef = new JThisRef(type);
            this.thisLocal = this.getLocal((Type)type, 0);
            this.addIdentity(this.thisLocal, (IdentityRef)thisRef);
        }
        return this.thisLocal;
    }

    protected Local getPara(int index) {
        Local paraLocal = this.paraLocals[index];
        if (paraLocal == null) {
            Type type = this.method.getParameterType(index);
            return this.getPara(index, type);
        }
        return paraLocal;
    }

    protected Local getPara(int index, Type type) {
        Local paraLocal = this.paraLocals[index];
        if (paraLocal == null) {
            JParameterRef paraRef = new JParameterRef(type, index);
            paraLocal = this.getLocal(type, this.paraStart + index);
            this.addIdentity(paraLocal, (IdentityRef)paraRef);
            this.paraLocals[index] = paraLocal;
        }
        return paraLocal;
    }

    private void addIdentity(Local lValue, IdentityRef rValue) {
        JIdentityStmt identityStmt = Jimple.newIdentityStmt((Local)lValue, (IdentityRef)rValue, (StmtPositionInfo)StmtPositionInfo.getNoStmtPositionInfo());
        this.stmtList.add((Stmt)identityStmt);
    }

    protected Local getNew(ClassType type) {
        JNewExpr newExpr = new JNewExpr(type);
        Local local = this.getNextLocal((Type)type);
        this.addAssign((LValue)local, (Value)newExpr);
        return local;
    }

    protected Local getNewArray(ClassType type) {
        JNewArrayExpr newExpr = JavaJimple.getInstance().newNewArrayExpr((Type)type, (Immediate)IntConstant.getInstance((int)1));
        Local local = this.getNextLocal((Type)new ArrayType((Type)type, 1));
        this.addAssign((LValue)local, (Value)newExpr);
        return local;
    }

    protected Local getNextLocal(Type type) {
        return this.getLocal(type, this.localStart++);
    }

    private Local getLocal(Type type, int index) {
        Local local = Jimple.newLocal((String)("r" + index), (Type)type);
        this.bodyBuilder.addLocal(local);
        return local;
    }

    protected void addReturn(Immediate ret) {
        JReturnStmt stmt = Jimple.newReturnStmt((Immediate)ret, (StmtPositionInfo)StmtPositionInfo.getNoStmtPositionInfo());
        this.stmtList.add((Stmt)stmt);
    }

    protected JStaticFieldRef getStaticFieldRef(String className, String name) {
        ClassType classType = PTAUtils.getClassType(className);
        SootClass sc = (SootClass)this.view.getClass(classType).get();
        SootField field = (SootField)sc.getField(name).get();
        return Jimple.newStaticFieldRef((FieldSignature)((FieldSignature)field.getSignature()));
    }

    protected JArrayRef getArrayRef(Value base) {
        return JavaJimple.getInstance().newArrayRef((Local)base, (Immediate)IntConstant.getInstance((int)0));
    }

    protected void addInvoke(Local receiver, String sig, Immediate ... args) {
        MethodSignature methodSig = JavaIdentifierFactory.getInstance().parseMethodSignature(sig);
        SootMethod method = (SootMethod)this.view.getMethod(methodSig).get();
        SootClass clazz = (SootClass)this.view.getClass(method.getDeclaringClassType()).get();
        List<Immediate> argsL = Arrays.asList(args);
        JInterfaceInvokeExpr invoke = clazz.isInterface() ? Jimple.newInterfaceInvokeExpr((Local)receiver, (MethodSignature)methodSig, argsL) : Jimple.newVirtualInvokeExpr((Local)receiver, (MethodSignature)methodSig, argsL);
        JInvokeStmt stmt = Jimple.newInvokeStmt((AbstractInvokeExpr)invoke, (StmtPositionInfo)StmtPositionInfo.getNoStmtPositionInfo());
        this.stmtList.add((Stmt)stmt);
    }

    protected Local getInvoke(Local receiver, String sig, Immediate ... args) {
        MethodSignature methodSig = JavaIdentifierFactory.getInstance().parseMethodSignature(sig);
        SootMethod method = (SootMethod)this.view.getMethod(methodSig).get();
        SootClass clazz = (SootClass)this.view.getClass(method.getDeclaringClassType()).get();
        List<Immediate> argsL = Arrays.asList(args);
        JInterfaceInvokeExpr invoke = clazz.isInterface() ? Jimple.newInterfaceInvokeExpr((Local)receiver, (MethodSignature)methodSig, argsL) : Jimple.newVirtualInvokeExpr((Local)receiver, (MethodSignature)methodSig, argsL);
        Local rx = this.getNextLocal(method.getReturnType());
        this.addAssign((LValue)rx, (Value)invoke);
        return rx;
    }

    protected void addInvoke(String sig, Immediate ... args) {
        MethodSignature methodSig = JavaIdentifierFactory.getInstance().parseMethodSignature(sig);
        List<Immediate> argsL = Arrays.asList(args);
        JInvokeStmt stmt = Jimple.newInvokeStmt((AbstractInvokeExpr)Jimple.newStaticInvokeExpr((MethodSignature)methodSig, argsL), (StmtPositionInfo)StmtPositionInfo.getNoStmtPositionInfo());
        this.stmtList.add((Stmt)stmt);
    }

    protected Value getInvoke(String sig, Immediate ... args) {
        MethodSignature methodSig = JavaIdentifierFactory.getInstance().parseMethodSignature(sig);
        List<Immediate> argsL = Arrays.asList(args);
        Local rx = this.getNextLocal(methodSig.getType());
        this.addAssign((LValue)rx, (Value)Jimple.newStaticInvokeExpr((MethodSignature)methodSig, argsL));
        return rx;
    }

    protected void addAssign(LValue lValue, Value rValue) {
        JAssignStmt stmt = Jimple.newAssignStmt((LValue)lValue, (Value)rValue, (StmtPositionInfo)StmtPositionInfo.getNoStmtPositionInfo());
        this.stmtList.add((Stmt)stmt);
    }
}

