/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder.callgraph;

import qilin.util.Numberable;

public final class Kind
implements Numberable {
    public static final Kind INVALID = new Kind("INVALID");
    public static final Kind STATIC = new Kind("STATIC");
    public static final Kind VIRTUAL = new Kind("VIRTUAL");
    public static final Kind INTERFACE = new Kind("INTERFACE");
    public static final Kind SPECIAL = new Kind("SPECIAL");
    public static final Kind CLINIT = new Kind("CLINIT");
    public static final Kind GENERIC_FAKE = new Kind("GENERIC_FAKE");
    public static final Kind THREAD = new Kind("THREAD");
    public static final Kind EXECUTOR = new Kind("EXECUTOR");
    public static final Kind ASYNCTASK = new Kind("ASYNCTASK");
    public static final Kind FINALIZE = new Kind("FINALIZE");
    public static final Kind HANDLER = new Kind("HANDLER");
    public static final Kind INVOKE_FINALIZE = new Kind("INVOKE_FINALIZE");
    public static final Kind PRIVILEGED = new Kind("PRIVILEGED");
    public static final Kind NEWINSTANCE = new Kind("NEWINSTANCE");
    public static final Kind REFL_INVOKE = new Kind("REFL_METHOD_INVOKE");
    public static final Kind REFL_CONSTR_NEWINSTANCE = new Kind("REFL_CONSTRUCTOR_NEWINSTANCE");
    public static final Kind REFL_CLASS_NEWINSTANCE = new Kind("REFL_CLASS_NEWINSTANCE");
    private final String name;
    private int num;

    private Kind(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public int getNumber() {
        return this.num;
    }

    @Override
    public void setNumber(int num) {
        this.num = num;
    }

    public String toString() {
        return this.name();
    }

    public boolean passesParameters() {
        return Kind.passesParameters(this);
    }

    public boolean isFake() {
        return Kind.isFake(this);
    }

    public boolean isExplicit() {
        return Kind.isExplicit(this);
    }

    public boolean isInstance() {
        return Kind.isInstance(this);
    }

    public boolean isVirtual() {
        return Kind.isVirtual(this);
    }

    public boolean isSpecial() {
        return Kind.isSpecial(this);
    }

    public boolean isClinit() {
        return Kind.isClinit(this);
    }

    public boolean isStatic() {
        return Kind.isStatic(this);
    }

    public boolean isThread() {
        return Kind.isThread(this);
    }

    public boolean isExecutor() {
        return Kind.isExecutor(this);
    }

    public boolean isAsyncTask() {
        return Kind.isAsyncTask(this);
    }

    public boolean isPrivileged() {
        return Kind.isPrivileged(this);
    }

    public boolean isReflection() {
        return Kind.isReflection(this);
    }

    public boolean isReflInvoke() {
        return Kind.isReflInvoke(this);
    }

    public boolean isHandler() {
        return Kind.isHandler(this);
    }

    public static boolean passesParameters(Kind k) {
        return Kind.isExplicit(k) || k == THREAD || k == EXECUTOR || k == ASYNCTASK || k == FINALIZE || k == PRIVILEGED || k == NEWINSTANCE || k == INVOKE_FINALIZE || k == REFL_INVOKE || k == REFL_CONSTR_NEWINSTANCE || k == REFL_CLASS_NEWINSTANCE || k == GENERIC_FAKE;
    }

    public static boolean isFake(Kind k) {
        return k == THREAD || k == EXECUTOR || k == ASYNCTASK || k == PRIVILEGED || k == HANDLER || k == GENERIC_FAKE;
    }

    public static boolean isExplicit(Kind k) {
        return Kind.isInstance(k) || Kind.isStatic(k);
    }

    public static boolean isInstance(Kind k) {
        return k == VIRTUAL || k == INTERFACE || k == SPECIAL;
    }

    public static boolean isVirtual(Kind k) {
        return k == VIRTUAL;
    }

    public static boolean isSpecial(Kind k) {
        return k == SPECIAL;
    }

    public static boolean isClinit(Kind k) {
        return k == CLINIT;
    }

    public static boolean isStatic(Kind k) {
        return k == STATIC;
    }

    public static boolean isThread(Kind k) {
        return k == THREAD;
    }

    public static boolean isExecutor(Kind k) {
        return k == EXECUTOR;
    }

    public static boolean isAsyncTask(Kind k) {
        return k == ASYNCTASK;
    }

    public static boolean isPrivileged(Kind k) {
        return k == PRIVILEGED;
    }

    public static boolean isReflection(Kind k) {
        return k == REFL_CLASS_NEWINSTANCE || k == REFL_CONSTR_NEWINSTANCE || k == REFL_INVOKE;
    }

    public static boolean isReflInvoke(Kind k) {
        return k == REFL_INVOKE;
    }

    public static boolean isHandler(Kind k) {
        return k == HANDLER;
    }
}

