/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.natives;

import qilin.core.PTAScene;
import qilin.core.natives.JavaIoFileSystemGetFileSystemNative;
import qilin.core.natives.JavaIoFileSystemListNative;
import qilin.core.natives.JavaLangObjectCloneNative;
import qilin.core.natives.JavaLangRefFinalizerInvokeFinalizeMethodNative;
import qilin.core.natives.JavaLangSystemSetErr0Native;
import qilin.core.natives.JavaLangSystemSetIn0Native;
import qilin.core.natives.JavaLangSystemSetOut0Native;
import qilin.core.natives.JavaLangThreadCurrentThread;
import qilin.core.natives.JavaLangThreadStart0Native;
import qilin.core.natives.JavaSecurityAccessControllerDoPrivilegedNative;
import qilin.core.natives.JavaSecurityAccessControllerDoPrivileged_ExceptionNative;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Value;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.views.View;

public class NativeMethodDriver {
    protected final PTAScene ptaScene;
    protected final View view;

    public NativeMethodDriver(PTAScene ptaScene) {
        this.ptaScene = ptaScene;
        this.view = ptaScene.getView();
    }

    public void buildNative(SootMethod method) {
        String sig;
        if (!this.ptaScene.nativeBuilt.add(method)) {
            return;
        }
        switch (sig = ((MethodSignature)method.getSignature()).toString()) {
            case "<java.lang.Object: java.lang.Object clone()>": 
            case "<qilin.pta.nativemodel.JavaLangObject: java.lang.Object clone()>": {
                new JavaLangObjectCloneNative(this.view, method).simulate();
                break;
            }
            case "<java.lang.System: void setIn0(java.io.InputStream)>": {
                new JavaLangSystemSetIn0Native(this.view, method).simulate();
                break;
            }
            case "<java.lang.System: void setOut0(java.io.PrintStream)>": {
                new JavaLangSystemSetOut0Native(this.view, method).simulate();
                break;
            }
            case "<java.lang.System: void setErr0(java.io.PrintStream)>": {
                new JavaLangSystemSetErr0Native(this.view, method).simulate();
                break;
            }
            case "<java.io.FileSystem: java.io.FileSystem getFileSystem()>": 
            case "<qilin.pta.nativemodel.JavaIoFileSystem: java.lang.Object getFileSystem()>": {
                new JavaIoFileSystemGetFileSystemNative(this.view, method).simulate();
                break;
            }
            case "<java.io.UnixFileSystem: java.lang.String[] list(java.io.File)>": 
            case "<qilin.pta.nativemodel.JavaIoFileSystem: java.lang.String[] list(java.io.File)>": {
                new JavaIoFileSystemListNative(this.view, method).simulate();
                break;
            }
            case "<java.lang.ref.Finalizer: void invokeFinalizeMethod(java.lang.Object)>": {
                new JavaLangRefFinalizerInvokeFinalizeMethodNative(this.view, method).simulate();
                break;
            }
            case "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction)>": 
            case "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)>": {
                new JavaSecurityAccessControllerDoPrivilegedNative(this.view, method).simulate();
                break;
            }
            case "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)>": 
            case "<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)>": {
                new JavaSecurityAccessControllerDoPrivileged_ExceptionNative(this.view, method).simulate();
                break;
            }
            case "<java.lang.Thread: java.lang.Thread currentThread()>": {
                new JavaLangThreadCurrentThread(this.view, method, (Value)this.ptaScene.getFieldCurrentThread()).simulate();
                break;
            }
            case "<java.lang.Thread: void start0()>": {
                new JavaLangThreadStart0Native(this.view, method, (LValue)this.ptaScene.getFieldCurrentThread()).simulate();
                break;
            }
            case "<java.lang.reflect.Array: java.lang.Object get(java.lang.Object,int)>": {
                break;
            }
            case "<java.lang.reflect.Array: void set(java.lang.Object,int,java.lang.Object)>": {
                break;
            }
        }
    }
}

