/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.pag;

import qilin.CoreConfig;
import qilin.core.context.Context;
import qilin.core.context.ContextElement;
import qilin.core.context.ContextElements;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ArrayElement;
import qilin.core.pag.SparkField;
import qilin.core.pag.ValNode;
import qilin.util.PTAUtils;
import sootup.core.types.ArrayType;
import sootup.core.types.Type;

public class ContextField
extends ValNode {
    protected Context context;
    protected SparkField field;

    public ContextField(Context context, SparkField field) {
        super(ContextField.refineFieldType(context, field));
        this.context = context;
        this.field = field;
    }

    private static Type refineFieldType(Context context, SparkField field) {
        if (!CoreConfig.v().getPtaConfig().preciseArrayElement) {
            return PTAUtils.getClassType("java.lang.Object");
        }
        if (field instanceof ArrayElement) {
            ContextElement[] contextElements = ((ContextElements)context).getElements();
            if (contextElements.length > 0) {
                Type baseHeapType = ((AllocNode)((ContextElements)context).getElements()[0]).getType();
                if (baseHeapType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)baseHeapType;
                    return arrayType.getElementType();
                }
                throw new RuntimeException(baseHeapType + " is not an array type.");
            }
            throw new RuntimeException("Context does not have any elements:" + context + ";" + field);
        }
        return field.getType();
    }

    public Context getContext() {
        return this.context;
    }

    public boolean hasBase() {
        ContextElements ctxs = (ContextElements)this.context;
        return ctxs.size() > 0;
    }

    public AllocNode getBase() {
        ContextElements ctxs = (ContextElements)this.context;
        return (AllocNode)ctxs.getElements()[0];
    }

    public SparkField getField() {
        return this.field;
    }

    public String toString() {
        return "ContextField " + this.getNumber() + " " + this.getBase() + "." + this.field;
    }
}

