/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import qilin.core.PTAScene;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.FallsThroughStmt;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.SootMethod;

public abstract class ReflectionModel {
    protected final PTAScene ptaScene;
    protected final String sigForName = "<java.lang.Class: java.lang.Class forName(java.lang.String)>";
    protected final String sigForName2 = "<java.lang.Class: java.lang.Class forName(java.lang.String,boolean,java.lang.ClassLoader)>";
    protected final String sigClassNewInstance = "<java.lang.Class: java.lang.Object newInstance()>";
    protected final String sigConstructorNewInstance = "<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>";
    protected final String sigMethodInvoke = "<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>";
    protected final String sigFieldSet = "<java.lang.reflect.Field: void set(java.lang.Object,java.lang.Object)>";
    protected final String sigFieldGet = "<java.lang.reflect.Field: java.lang.Object get(java.lang.Object)>";
    protected final String sigArrayNewInstance = "<java.lang.reflect.Array: java.lang.Object newInstance(java.lang.Class,int)>";
    protected final String sigArrayGet = "<java.lang.reflect.Array: java.lang.Object get(java.lang.Object,int)>";
    protected final String sigArraySet = "<java.lang.reflect.Array: void set(java.lang.Object,int,java.lang.Object)>";
    protected final String sigReifiedField = "<java.lang.Class: java.lang.reflect.Field getField(java.lang.String)>";
    protected final String sigReifiedDeclaredField = "<java.lang.Class: java.lang.reflect.Field getDeclaredField(java.lang.String)>";
    protected final String sigReifiedFieldArray = "<java.lang.Class: java.lang.reflect.Field[] getFields()>";
    protected final String sigReifiedDeclaredFieldArray = "<java.lang.Class: java.lang.reflect.Field[] getDeclaredFields()>";
    protected final String sigReifiedMethod = "<java.lang.Class: java.lang.reflect.Method getMethod(java.lang.String,java.lang.Class[])>";
    protected final String sigReifiedDeclaredMethod = "<java.lang.Class: java.lang.reflect.Method getDeclaredMethod(java.lang.String,java.lang.Class[])>";
    protected final String sigReifiedMethodArray = "<java.lang.Class: java.lang.reflect.Method[] getMethods()>";
    protected final String sigReifiedDeclaredMethodArray = "<java.lang.Class: java.lang.reflect.Method[] getDeclaredMethods()>";

    protected ReflectionModel(PTAScene ptaScene) {
        this.ptaScene = ptaScene;
    }

    private Collection<Stmt> transform(InvokableStmt s) {
        AbstractInvokeExpr ie = (AbstractInvokeExpr)s.getInvokeExpr().get();
        switch (ie.getMethodSignature().toString()) {
            case "<java.lang.Class: java.lang.Class forName(java.lang.String)>": 
            case "<java.lang.Class: java.lang.Class forName(java.lang.String,boolean,java.lang.ClassLoader)>": {
                return this.transformClassForName(s);
            }
            case "<java.lang.Class: java.lang.Object newInstance()>": {
                return this.transformClassNewInstance(s);
            }
            case "<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>": {
                return this.transformConstructorNewInstance(s);
            }
            case "<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>": {
                return this.transformMethodInvoke(s);
            }
            case "<java.lang.reflect.Field: void set(java.lang.Object,java.lang.Object)>": {
                return this.transformFieldSet(s);
            }
            case "<java.lang.reflect.Field: java.lang.Object get(java.lang.Object)>": {
                return this.transformFieldGet(s);
            }
            case "<java.lang.reflect.Array: java.lang.Object newInstance(java.lang.Class,int)>": {
                return this.transformArrayNewInstance(s);
            }
            case "<java.lang.reflect.Array: java.lang.Object get(java.lang.Object,int)>": {
                return this.transformArrayGet(s);
            }
            case "<java.lang.reflect.Array: void set(java.lang.Object,int,java.lang.Object)>": {
                return this.transformArraySet(s);
            }
        }
        return Collections.emptySet();
    }

    public void buildReflection(SootMethod m) {
        if (!this.ptaScene.reflectionBuilt.add(m)) {
            return;
        }
        Map<Stmt, Collection<Stmt>> newUnits = DataFactory.createMap();
        Body body = PTAUtils.getMethodBody(m);
        List units = body.getStmts();
        for (Stmt u : units) {
            if (!u.isInvokableStmt() || !u.asInvokableStmt().containsInvokeExpr()) continue;
            newUnits.put(u, this.transform(u.asInvokableStmt()));
        }
        Body.BodyBuilder builder = Body.builder((Body)body, Collections.emptySet());
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        for (Stmt unit : newUnits.keySet()) {
            for (Stmt succ : (Collection)newUnits.get(unit)) {
                if (succ instanceof JAssignStmt) {
                    JAssignStmt assign = (JAssignStmt)succ;
                    stmtGraph.insertBefore(unit, (FallsThroughStmt)assign);
                    continue;
                }
                if (succ instanceof JInvokeStmt) {
                    JInvokeStmt invoke = (JInvokeStmt)succ;
                    stmtGraph.insertBefore(unit, (FallsThroughStmt)invoke);
                    continue;
                }
                System.out.println("unit:" + unit);
                System.out.println("succ:" + succ.getClass());
                stmtGraph.putEdge((FallsThroughStmt)unit, succ);
            }
        }
        PTAUtils.updateMethodBody(m, builder.build());
    }

    abstract Collection<Stmt> transformClassForName(InvokableStmt var1);

    abstract Collection<Stmt> transformClassNewInstance(InvokableStmt var1);

    abstract Collection<Stmt> transformConstructorNewInstance(InvokableStmt var1);

    abstract Collection<Stmt> transformMethodInvoke(InvokableStmt var1);

    abstract Collection<Stmt> transformFieldSet(InvokableStmt var1);

    abstract Collection<Stmt> transformFieldGet(InvokableStmt var1);

    abstract Collection<Stmt> transformArrayNewInstance(InvokableStmt var1);

    abstract Collection<Stmt> transformArrayGet(InvokableStmt var1);

    abstract Collection<Stmt> transformArraySet(InvokableStmt var1);
}

