/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.sets;

import java.util.Iterator;
import qilin.core.sets.HybridPointsToSet;
import qilin.core.sets.P2SetVisitor;
import qilin.core.sets.PointsToSetInternal;

public class DoublePointsToSet
extends PointsToSetInternal {
    protected HybridPointsToSet newSet = new HybridPointsToSet();
    protected HybridPointsToSet oldSet = new HybridPointsToSet();

    @Override
    public boolean isEmpty() {
        return this.oldSet.isEmpty() && this.newSet.isEmpty();
    }

    @Override
    public boolean hasNonEmptyIntersection(PointsToSetInternal other) {
        return this.oldSet.hasNonEmptyIntersection(other) || this.newSet.hasNonEmptyIntersection(other);
    }

    @Override
    public int size() {
        return this.oldSet.size() + this.newSet.size();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new DoublePTSIterator();
    }

    @Override
    public void clear() {
        this.oldSet.clear();
        this.newSet.clear();
    }

    @Override
    public boolean addAll(PointsToSetInternal other, PointsToSetInternal exclude) {
        if (exclude != null) {
            throw new RuntimeException("exclude set must be null.");
        }
        return this.newSet.addAll(other, this.oldSet);
    }

    @Override
    public boolean forall(P2SetVisitor v) {
        this.oldSet.forall(v);
        this.newSet.forall(v);
        return v.getReturnValue();
    }

    @Override
    public boolean add(int idx) {
        if (this.oldSet.contains(idx)) {
            return false;
        }
        return this.newSet.add(idx);
    }

    public HybridPointsToSet getOldSet() {
        return this.oldSet;
    }

    public HybridPointsToSet getNewSet() {
        return this.newSet;
    }

    public HybridPointsToSet getNewSetCopy() {
        HybridPointsToSet newCopy = new HybridPointsToSet();
        newCopy.addAll(this.newSet, null);
        return newCopy;
    }

    public void flushNew() {
        this.oldSet.addAll(this.newSet, null);
        this.newSet = new HybridPointsToSet();
    }

    @Override
    public boolean contains(int idx) {
        return this.oldSet.contains(idx) || this.newSet.contains(idx);
    }

    private class DoublePTSIterator
    implements Iterator<Integer> {
        private final Iterator<Integer> oldIt;
        private final Iterator<Integer> newIt;

        private DoublePTSIterator() {
            this.oldIt = DoublePointsToSet.this.oldSet.iterator();
            this.newIt = DoublePointsToSet.this.newSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.oldIt.hasNext() || this.newIt.hasNext();
        }

        @Override
        public Integer next() {
            if (this.oldIt.hasNext()) {
                return this.oldIt.next();
            }
            return this.newIt.next();
        }
    }
}

