/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.sets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ClassConstantNode;
import qilin.core.pag.Node;
import qilin.core.pag.StringConstantNode;
import qilin.core.sets.HybridPointsToSet;
import qilin.core.sets.P2SetVisitor;
import qilin.core.sets.PointsToSet;
import qilin.core.sets.PointsToSetInternal;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.model.SootClass;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.views.View;

public class UnmodifiablePointsToSet
implements PointsToSet {
    private final PointsToSetInternal pts;
    private final PTA pta;

    public UnmodifiablePointsToSet(PTA pta, PointsToSetInternal pts) {
        this.pta = pta;
        this.pts = pts;
    }

    @Override
    public boolean isEmpty() {
        return this.pts.isEmpty();
    }

    @Override
    public boolean contains(AllocNode n) {
        return this.pts.contains(n.getNumber());
    }

    @Override
    public boolean hasNonEmptyIntersection(PointsToSet other) {
        if (other instanceof UnmodifiablePointsToSet) {
            UnmodifiablePointsToSet uother = (UnmodifiablePointsToSet)other;
            return this.pta == uother.pta && this.pts.hasNonEmptyIntersection(uother.pts);
        }
        return false;
    }

    @Override
    public Set<Type> possibleTypes() {
        final HashSet<Type> ret = new HashSet<Type>();
        this.pts.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                Type t = n.getType();
                if (t instanceof ClassType) {
                    ClassType rt = (ClassType)t;
                    View view = this.pta.getView();
                    Optional osc = view.getClass(rt);
                    if (osc.isPresent() && ((SootClass)osc.get()).isAbstract()) {
                        return;
                    }
                }
                ret.add(t);
            }
        });
        return ret;
    }

    @Override
    public Set<String> possibleStringConstants() {
        final HashSet<String> ret = new HashSet<String>();
        return this.pts.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                if (n instanceof StringConstantNode) {
                    ret.add(((StringConstantNode)n).getString());
                } else {
                    this.returnValue = true;
                }
            }
        }) ? null : ret;
    }

    @Override
    public Set<ClassConstant> possibleClassConstants() {
        final HashSet<ClassConstant> ret = new HashSet<ClassConstant>();
        return this.pts.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                if (n instanceof ClassConstantNode) {
                    ret.add(((ClassConstantNode)n).getClassConstant());
                } else {
                    this.returnValue = true;
                }
            }
        }) ? null : ret;
    }

    @Override
    public int size() {
        return this.pts.size();
    }

    @Override
    public void clear() {
        this.pts.clear();
    }

    public String toString() {
        final StringBuffer ret = new StringBuffer();
        this.pts.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                ret.append(n).append(",");
            }
        });
        return ret.toString();
    }

    @Override
    public int pointsToSetHashCode() {
        long intValue = 1L;
        long PRIME = 31L;
        Iterator<Integer> it = this.pts.iterator();
        while (it.hasNext()) {
            intValue = 31L * intValue + (long)it.next().intValue();
        }
        return (int)intValue;
    }

    @Override
    public boolean pointsToSetEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UnmodifiablePointsToSet) {
            UnmodifiablePointsToSet otherPts = (UnmodifiablePointsToSet)other;
            if (otherPts.pta != this.pta) {
                return false;
            }
            return this.superSetOf(otherPts.pts, this.pts) && this.superSetOf(this.pts, otherPts.pts);
        }
        return false;
    }

    @Override
    public PointsToSet toCIPointsToSet() {
        final HybridPointsToSet ptoSet = new HybridPointsToSet();
        this.pts.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                AllocNode heap = (AllocNode)n;
                ptoSet.add(heap.base().getNumber());
            }
        });
        return new UnmodifiablePointsToSet(this.pta, ptoSet);
    }

    @Override
    public Collection<AllocNode> toCollection() {
        HashSet<AllocNode> ret = new HashSet<AllocNode>();
        Iterator<AllocNode> it = this.iterator();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    private boolean superSetOf(PointsToSetInternal onePts, PointsToSetInternal otherPts) {
        Iterator<Integer> it = onePts.iterator();
        while (it.hasNext()) {
            int idx = it.next();
            if (otherPts.contains(idx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<AllocNode> iterator() {
        return new UnmodifiablePTSIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.pointsToSetEquals(o);
    }

    public int hashCode() {
        return Objects.hash(this.pointsToSetHashCode(), this.pta);
    }

    private class UnmodifiablePTSIterator
    implements Iterator<AllocNode> {
        Iterator<Integer> it;

        private UnmodifiablePTSIterator() {
            this.it = UnmodifiablePointsToSet.this.pts.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public AllocNode next() {
            int idx = this.it.next();
            return (AllocNode)UnmodifiablePointsToSet.this.pta.getPag().getAllocNodeNumberer().get(idx);
        }
    }
}

