/*
 * Decompiled with CFR 0.152.
 */
package qilin.driver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import qilin.util.Util;

public enum ContextKind {
    INSENS,
    CALLSITE,
    OBJECT,
    TYPE,
    HYBOBJ,
    HYBTYPE;

    static final Map<String, ContextKind> contextKinds;

    public static Collection<String> contextAliases() {
        return contextKinds.keySet();
    }

    public static ContextKind toCtxKind(String name) {
        return contextKinds.getOrDefault(name, INSENS);
    }

    public String toString() {
        switch (this) {
            case CALLSITE: {
                return "callsite";
            }
            case OBJECT: {
                return "object";
            }
            case HYBOBJ: {
                return "hybobj";
            }
            case HYBTYPE: {
                return "hybtype";
            }
            case TYPE: {
                return "type";
            }
        }
        return "insensitive";
    }

    static {
        contextKinds = new HashMap<String, ContextKind>();
        Util.add(contextKinds, INSENS, "insensitive", "insens", "ci");
        Util.add(contextKinds, CALLSITE, "callsite", "call", "c");
        Util.add(contextKinds, OBJECT, "object", "obj", "o");
        Util.add(contextKinds, HYBOBJ, "hybobj", "ho", "h");
        Util.add(contextKinds, HYBTYPE, "hybtype", "ht");
        Util.add(contextKinds, TYPE, "type", "t");
    }
}

