/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.conch;

import com.google.common.collect.Streams;
import heros.solver.CountingThreadPoolExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ConstantNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.Parm;
import qilin.pta.toolkits.conch.DFA;
import qilin.pta.toolkits.conch.TranEdge;
import qilin.util.PTAUtils;
import qilin.util.queue.QueueReader;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;

public abstract class AbstractPAG {
    protected final Map<SootMethod, Map<Stmt, AllocNode>> symbolicHeaps = new ConcurrentHashMap<SootMethod, Map<Stmt, AllocNode>>();
    protected final Map<Node, Set<TranEdge>> outEdges = new ConcurrentHashMap<Node, Set<TranEdge>>();
    protected final Map<Node, Set<TranEdge>> sumEdges = new ConcurrentHashMap<Node, Set<TranEdge>>();
    protected CountingThreadPoolExecutor executor;
    protected final PTA prePTA;
    protected final PAG prePAG;
    protected final OnFlyCallGraph callGraph;

    protected AbstractPAG(PTA prePTA) {
        this.prePTA = prePTA;
        this.prePAG = prePTA.getPag();
        this.callGraph = prePTA.getCallGraph();
        int threadNum = Runtime.getRuntime().availableProcessors();
        this.executor = new CountingThreadPoolExecutor(threadNum, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue());
    }

    protected void build() {
        this.prePTA.getNakedReachableMethods().parallelStream().filter(PTAUtils::hasBody).forEach(this::buildFG);
    }

    private void buildFG(SootMethod method) {
        LocalVarNode throwNode;
        MethodPAG srcmpag = this.prePAG.getMethodPAG(method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        Object reader = srcmpag.getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            FieldRefNode fr;
            Node from = (Node)((QueueReader)reader).next();
            Node to = (Node)((QueueReader)reader).next();
            if (from instanceof LocalVarNode) {
                if (to instanceof LocalVarNode) {
                    this.addAssignEdge((LocalVarNode)from, (LocalVarNode)to);
                    continue;
                }
                if (!(to instanceof FieldRefNode)) continue;
                fr = (FieldRefNode)to;
                this.addStoreEdge((LocalVarNode)from, (LocalVarNode)fr.getBase());
                continue;
            }
            if (from instanceof AllocNode) {
                if (!(to instanceof LocalVarNode)) continue;
                this.addNewEdge((AllocNode)from, (LocalVarNode)to);
                continue;
            }
            if (!(from instanceof FieldRefNode)) continue;
            fr = (FieldRefNode)from;
            this.addLoadEdge((LocalVarNode)fr.getBase(), (LocalVarNode)to);
        }
        this.addParamEdge(thisRef);
        int numParms = method.getParameterCount();
        for (int i = 0; i < numParms; ++i) {
            if (!(method.getParameterType(i) instanceof ReferenceType)) continue;
            LocalVarNode param = (LocalVarNode)srcnf.caseParm(i);
            this.addParamEdge(param);
        }
        if (method.getReturnType() instanceof ReferenceType) {
            LocalVarNode mret = (LocalVarNode)srcnf.caseRet();
            this.addReturnEdge(mret);
        }
        if ((throwNode = this.prePAG.findLocalVarNode(method, new Parm(method, -3), (Type)PTAUtils.getClassType("java.lang.Throwable"))) != null) {
            this.addThrowEdge(throwNode);
        }
    }

    protected void addNormalEdge(TranEdge edge) {
        this.outEdges.computeIfAbsent(edge.getSource(), k -> ConcurrentHashMap.newKeySet()).add(edge);
    }

    protected void addThrowEdge(Node throwNode) {
        this.addNormalEdge(new TranEdge(throwNode, throwNode, DFA.TranCond.THROW));
        this.addNormalEdge(new TranEdge(throwNode, throwNode, DFA.TranCond.I_THROW));
    }

    protected void addParamEdge(LocalVarNode param) {
        this.addNormalEdge(new TranEdge(param, param, DFA.TranCond.PARAM));
        this.addNormalEdge(new TranEdge(param, param, DFA.TranCond.I_PARAM));
    }

    protected void addReturnEdge(LocalVarNode mret) {
        this.addNormalEdge(new TranEdge(mret, mret, DFA.TranCond.RETURN));
        this.addNormalEdge(new TranEdge(mret, mret, DFA.TranCond.I_RETURN));
    }

    protected void addNewEdge(AllocNode from, LocalVarNode to) {
        if (from.getMethod() == null && !(from instanceof ConstantNode)) {
            return;
        }
        TranEdge newEdge = new TranEdge(from, to, DFA.TranCond.NEW);
        this.addNormalEdge(newEdge);
        TranEdge newInvEdge = new TranEdge(to, from, DFA.TranCond.I_NEW);
        this.addNormalEdge(newInvEdge);
    }

    protected void addAssignEdge(LocalVarNode from, LocalVarNode to) {
        TranEdge assignEdge = new TranEdge(from, to, DFA.TranCond.ASSIGN);
        this.addNormalEdge(assignEdge);
        TranEdge assignInvEdge = new TranEdge(to, from, DFA.TranCond.I_ASSIGN);
        this.addNormalEdge(assignInvEdge);
    }

    protected void addStoreEdge(LocalVarNode from, LocalVarNode base) {
        TranEdge storeEdge = new TranEdge(from, base, DFA.TranCond.STORE);
        this.addNormalEdge(storeEdge);
        TranEdge storeInvEdge = new TranEdge(base, from, DFA.TranCond.I_STORE);
        this.addNormalEdge(storeInvEdge);
    }

    protected void addLoadEdge(LocalVarNode base, LocalVarNode to) {
        TranEdge loadEdge = new TranEdge(base, to, DFA.TranCond.LOAD);
        this.addNormalEdge(loadEdge);
        TranEdge loadInvEdge = new TranEdge(to, base, DFA.TranCond.I_LOAD);
        this.addNormalEdge(loadInvEdge);
    }

    protected void solve() {
        this.submitInitialSeeds();
        this.awaitCompletionComputeValuesAndShutdown();
    }

    protected Collection<TranEdge> outAndSummaryEdges(Node node) {
        return Streams.concat((Stream[])new Stream[]{this.outEdges.getOrDefault(node, Collections.emptySet()).stream(), this.sumEdges.getOrDefault(node, Collections.emptySet()).stream()}).collect(Collectors.toSet());
    }

    protected abstract void submitInitialSeeds();

    protected void awaitCompletionComputeValuesAndShutdown() {
        this.runExecutorAndAwaitCompletion();
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.executor = null;
    }

    private void runExecutorAndAwaitCompletion() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Throwable exception = this.executor.getException();
        if (exception != null) {
            throw new RuntimeException("There were exceptions during IFDS analysis. Exiting.", exception);
        }
    }

    protected AllocNode getSymbolicHeapOf(SootMethod method, Stmt invokeStmt) {
        return this.symbolicHeaps.computeIfAbsent(method, k -> new ConcurrentHashMap()).computeIfAbsent(invokeStmt, k -> new AllocNode(invokeStmt, null, method));
    }
}

