/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.conch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ConstantNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.SparkField;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.toolkits.conch.AbstractConch;
import qilin.pta.toolkits.conch.CSDG;
import qilin.pta.toolkits.conch.DepOnParamAnalysis;
import qilin.pta.toolkits.conch.LeakAnalysis;
import qilin.pta.toolkits.conch.Trilean;
import qilin.util.PTAUtils;
import qilin.util.Pair;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;

public class Conch
extends AbstractConch {
    private final LeakAnalysis mfg;
    private final DepOnParamAnalysis pfg;
    private final Set<AllocNode> csHeaps = new HashSet<AllocNode>();
    private final Set<AllocNode> ciHeaps = new HashSet<AllocNode>();
    private final Map<AllocNode, Set<SparkField>> notSureFields = new HashMap<AllocNode, Set<SparkField>>();

    public Set<Object> ctxDependentHeaps() {
        return this.csHeaps.stream().map(AllocNode::getNewExpr).collect(Collectors.toSet());
    }

    public Set<AllocNode> ctxIndenpendentHeaps() {
        return this.ciHeaps;
    }

    public Set<AllocNode> ctxDependentHeaps2() {
        return this.csHeaps;
    }

    public Conch(PTA pta) {
        super(pta);
        this.mfg = new LeakAnalysis(pta);
        this.pfg = new DepOnParamAnalysis(pta);
    }

    private SootMethod findInvokedConstructorOf(AllocNode heap) {
        SootMethod containingMethod = heap.getMethod();
        MethodPAG cmpag = this.pag.getMethodPAG(containingMethod);
        MethodNodeFactory nodeFactory = cmpag.nodeFactory();
        for (Stmt stmt : cmpag.getInvokeStmts()) {
            JInvokeStmt invokeStmt;
            AbstractInvokeExpr expr;
            if (!(stmt instanceof JInvokeStmt) || !((expr = (AbstractInvokeExpr)(invokeStmt = (JInvokeStmt)stmt).getInvokeExpr().get()) instanceof JSpecialInvokeExpr)) continue;
            JSpecialInvokeExpr iie = (JSpecialInvokeExpr)expr;
            Local base = iie.getBase();
            VarNode baseNode = (VarNode)nodeFactory.getNode((Value)base);
            PointsToSet v1pts = this.pta.reachingObjects(baseNode);
            SootMethod target = (SootMethod)this.pta.getView().getMethod(iie.getMethodSignature()).get();
            if (v1pts.size() != 1 || !v1pts.toCIPointsToSet().contains(heap) || !PTAUtils.isConstructor(target)) continue;
            return target;
        }
        return null;
    }

    private SootMethod findInvokedConstructorOf(SootMethod outerInit) {
        MethodPAG cmpag = this.pag.getMethodPAG(outerInit);
        MethodNodeFactory nodeFactory = cmpag.nodeFactory();
        VarNode thisNode = nodeFactory.caseThis();
        for (Stmt stmt : cmpag.getInvokeStmts()) {
            JInvokeStmt invokeStmt;
            AbstractInvokeExpr expr;
            if (!(stmt instanceof JInvokeStmt) || !((expr = (AbstractInvokeExpr)(invokeStmt = (JInvokeStmt)stmt).getInvokeExpr().get()) instanceof JSpecialInvokeExpr)) continue;
            JSpecialInvokeExpr iie = (JSpecialInvokeExpr)expr;
            Local base = iie.getBase();
            VarNode baseNode = (VarNode)nodeFactory.getNode((Value)base);
            MethodSignature targetSig = iie.getMethodSignature();
            SootMethod target = (SootMethod)this.pta.getView().getMethod(targetSig).get();
            if (!PTAUtils.mustAlias(this.pta, thisNode, baseNode) || !((MethodSubSignature)targetSig.getSubSignature()).getName().equals("<init>")) continue;
            return target;
        }
        return null;
    }

    private ArrayList<SootMethod> recoverConstructorChain(SootMethod sm, AllocNode heap) {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        SootMethod origInit = this.findInvokedConstructorOf(heap);
        if (origInit != null) {
            while (origInit != sm) {
                ret.add(0, origInit);
                if ((origInit = this.findInvokedConstructorOf(origInit)) != null) continue;
                break;
            }
        }
        return ret;
    }

    private Set<Node> mappingtoCallerCommingParamsOrHeaps(Set<Node> params, SootMethod curr, SootMethod caller) {
        MethodPAG cmpag = this.pag.getMethodPAG(caller);
        HashSet<Node> ret = new HashSet<Node>();
        for (InvokableStmt stmt : cmpag.getInvokeStmts()) {
            if (!(stmt.getInvokeExpr().get() instanceof JSpecialInvokeExpr)) continue;
            MethodSignature methodSig = ((AbstractInvokeExpr)stmt.getInvokeExpr().get()).getMethodSignature();
            Optional otarget = this.pta.getView().getMethod(methodSig);
            if (!otarget.isPresent() || !((SootMethod)otarget.get()).equals((Object)curr)) continue;
            for (Node n : params) {
                VarNode paramNode;
                LocalVarNode argNode;
                if (!(n instanceof VarNode) || (argNode = PTAUtils.paramToArg(this.pag, stmt, cmpag, paramNode = (VarNode)n)) == null) continue;
                ret.addAll(this.pfg.fetchReachableParamsOf(argNode));
            }
        }
        return ret;
    }

    private boolean containHeaps(Set<Node> nodes) {
        boolean ret = false;
        for (Node n : nodes) {
            if (!(n instanceof AllocNode)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private Trilean handleTransitiveConstructors(SootMethod sm, AllocNode heap, Set<Node> params) {
        SootMethod curr;
        SootMethod containingMethod = heap.getMethod();
        ArrayList<SootMethod> chain = this.recoverConstructorChain(sm, heap);
        SootMethod caller = sm;
        Set<Node> ret = params;
        boolean notSure = this.containHeaps(params);
        for (SootMethod method : chain) {
            curr = caller;
            caller = method;
            ret = this.mappingtoCallerCommingParamsOrHeaps(ret, curr, caller);
            notSure |= this.containHeaps(ret);
            Trilean res = this.checkResult(ret);
            if (res == Trilean.TRUE) continue;
            if (notSure) {
                return Trilean.UNKNOWN;
            }
            return Trilean.FALSE;
        }
        curr = caller;
        caller = containingMethod;
        ret = this.mappingtoCallerCommingParamsOrHeaps(ret, curr, caller);
        Trilean tmpRes2 = this.checkResult(ret);
        if (notSure) {
            tmpRes2 = Trilean.OR(tmpRes2, Trilean.UNKNOWN);
        }
        return tmpRes2;
    }

    private Trilean checkResult(Set<Node> res) {
        if (res.isEmpty()) {
            return Trilean.FALSE;
        }
        boolean hasParam = false;
        for (Node n : res) {
            if (n instanceof AllocNode) continue;
            hasParam = true;
            break;
        }
        if (hasParam) {
            return Trilean.TRUE;
        }
        return Trilean.UNKNOWN;
    }

    private Trilean isCommingFromParams(LocalVarNode from, SootMethod method, AllocNode heap) {
        Set<Node> ret = this.pfg.fetchReachableParamsOf(from);
        if (PTAUtils.isConstructor(method)) {
            return this.handleTransitiveConstructors(method, heap, ret);
        }
        return this.checkResult(ret);
    }

    private Trilean checkHeap(AllocNode heap) {
        Set fields = this.o2fs.getOrDefault(heap, Collections.emptySet());
        Trilean ret = Trilean.FALSE;
        for (SparkField field : fields) {
            Trilean csorci = Trilean.FALSE;
            if (!this.hasLoadOn(heap, field) || !this.hasStoreOn(heap, field) || this.emptyFieldPts(heap, field)) continue;
            Map f2sts = this.o2nonThisFStores.getOrDefault(heap, Collections.emptyMap());
            Set pairs = f2sts.getOrDefault(field, Collections.emptySet());
            if (!pairs.isEmpty()) {
                for (Pair pair : pairs) {
                    LocalVarNode storeBase = (LocalVarNode)pair.getFirst();
                    VarNode from = (VarNode)pair.getSecond();
                    if (storeBase.getMethod() != heap.getMethod()) {
                        csorci = Trilean.TRUE;
                        continue;
                    }
                    Trilean fromparam = this.isCommingFromParams((LocalVarNode)from, storeBase.getMethod(), heap);
                    csorci = Trilean.OR(csorci, fromparam);
                    if (fromparam != Trilean.UNKNOWN) continue;
                    this.notSureFields.computeIfAbsent(heap, k -> new HashSet()).add(field);
                }
            }
            Set onMethods = this.invokedMethods.getOrDefault(heap, Collections.emptySet());
            for (SootMethod method : onMethods) {
                Map f2stsX = this.m2thisFStores.getOrDefault(method, Collections.emptyMap());
                Set thisFStores = f2stsX.getOrDefault(field, Collections.emptySet());
                if (thisFStores.isEmpty()) continue;
                for (Pair pair : thisFStores) {
                    VarNode from = (VarNode)pair.getSecond();
                    Trilean fromparam = this.isCommingFromParams((LocalVarNode)from, method, heap);
                    csorci = Trilean.OR(csorci, fromparam);
                }
            }
            ret = Trilean.OR(ret, csorci);
            if (csorci != Trilean.UNKNOWN) continue;
            this.notSureFields.computeIfAbsent(heap, k -> new HashSet()).add(field);
        }
        return ret;
    }

    private boolean hasInstanceFieldWithStoreLoad(AllocNode heap) {
        Set fields = this.o2fs.getOrDefault(heap, Collections.emptySet());
        for (SparkField field : fields) {
            boolean hasLoads = this.hasLoadOn(heap, field);
            boolean hasStores = this.hasStoreOn(heap, field);
            boolean emptyFieldPts = this.emptyFieldPts(heap, field);
            if (!hasLoads || !hasStores || emptyFieldPts) continue;
            return true;
        }
        return false;
    }

    public void runClassifier() {
        Collection<AllocNode> allHeaps = this.pag.getAllocNodes();
        int heapCnt = allHeaps.size();
        int[] condACnt = new int[1];
        HashSet remainToSolve = new HashSet();
        allHeaps.forEach(heap -> {
            if (heap.getMethod() == null || heap instanceof ConstantNode || PTAUtils.isEmptyArray(heap) || PTAUtils.isOfPrimitiveBaseType(heap)) {
                this.ciHeaps.add((AllocNode)heap);
            } else {
                SootMethod mthd = heap.getMethod();
                if (PTAUtils.isStaticInitializer(mthd)) {
                    this.ciHeaps.add((AllocNode)heap);
                } else {
                    remainToSolve.add(heap);
                }
            }
        });
        HashSet<AllocNode> unknownyet = new HashSet<AllocNode>();
        remainToSolve.forEach(heap -> {
            boolean condA = this.mfg.isLeakObject((AllocNode)heap);
            condACnt[0] = condACnt[0] + (condA ? 1 : 0);
            if (!condA) {
                this.ciHeaps.add((AllocNode)heap);
                return;
            }
            boolean condB = this.hasInstanceFieldWithStoreLoad((AllocNode)heap);
            if (!condB) {
                this.ciHeaps.add((AllocNode)heap);
                return;
            }
            Trilean condExtra = this.checkHeap((AllocNode)heap);
            if (condExtra == Trilean.TRUE) {
                this.csHeaps.add((AllocNode)heap);
            } else if (condExtra == Trilean.FALSE) {
                this.ciHeaps.add((AllocNode)heap);
            } else {
                unknownyet.add((AllocNode)heap);
            }
        });
        this.classifyForRemain(unknownyet);
        System.out.println("#Heaps:" + heapCnt);
        System.out.println("#CondA:" + condACnt[0]);
        System.out.println("#CS:" + this.csHeaps.size());
        System.out.println("#CI:" + this.ciHeaps.size());
    }

    private void classifyForRemain(Set<AllocNode> unknownyet) {
        Set<AllocNode> noOutDegree;
        CSDG csdg = new CSDG();
        for (AllocNode heap : unknownyet) {
            Set ifs = this.notSureFields.getOrDefault(heap, Collections.emptySet());
            boolean cs = false;
            boolean existUnknown = false;
            HashSet<AllocNode> tos = new HashSet<AllocNode>();
            for (SparkField sf : ifs) {
                PointsToSet pts = this.pta.reachingObjectsInternal(heap, sf);
                for (AllocNode o : pts.toCIPointsToSet().toCollection()) {
                    if (this.csHeaps.contains(o)) {
                        cs = true;
                        break;
                    }
                    if (this.ciHeaps.contains(o)) continue;
                    tos.add(o);
                    existUnknown = true;
                }
                if (!cs) continue;
                break;
            }
            if (cs) {
                this.csHeaps.add(heap);
                continue;
            }
            if (existUnknown) {
                for (AllocNode to : tos) {
                    csdg.addEdge(heap, to);
                }
                continue;
            }
            this.ciHeaps.add(heap);
        }
        System.out.println("#InitOnCSDG:" + csdg.allNodes().size());
        while (!(noOutDegree = csdg.noOutDegreeNodes()).isEmpty()) {
            for (AllocNode nod : noOutDegree) {
                if (this.csHeaps.contains(nod)) {
                    this.csHeaps.addAll(csdg.predsOf(nod));
                } else {
                    this.ciHeaps.add(nod);
                }
                csdg.removeNode(nod);
            }
        }
        System.out.println("#StillOnCSDG:" + csdg.allNodes().size());
        this.ciHeaps.addAll(csdg.allNodes());
    }
}

