/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.PAG;
import qilin.core.pag.SparkField;
import qilin.pta.toolkits.debloaterx.InterFlowAnalysis;
import qilin.pta.toolkits.debloaterx.XUtility;
import qilin.util.PTAUtils;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;

public class HeapContainerQuery {
    private final PAG pag;
    private final XUtility utility;
    private final Set<SootMethod> invokedMs;
    private final Set<LocalVarNode> params;
    private final InterFlowAnalysis interfa;
    private final AllocNode heap;

    public HeapContainerQuery(XUtility utility, AllocNode heap) {
        this.utility = utility;
        this.pag = utility.getPta().getPag();
        this.heap = heap;
        this.invokedMs = utility.getInvokedMethods(heap);
        this.interfa = utility.getInterFlowAnalysis();
        this.params = this.getParameters();
    }

    private Set<LocalVarNode> getParameters() {
        HashSet<LocalVarNode> ret = new HashSet<LocalVarNode>();
        for (SootMethod m : this.invokedMs) {
            MethodNodeFactory mthdNF = this.pag.getMethodPAG(m).nodeFactory();
            for (int i = 0; i < m.getParameterCount(); ++i) {
                if (!(m.getParameterType(i) instanceof ReferenceType) || PTAUtils.isPrimitiveArrayType(m.getParameterType(i))) continue;
                LocalVarNode param = (LocalVarNode)mthdNF.caseParm(i);
                ret.add(param);
            }
            ret.add((LocalVarNode)mthdNF.caseThis());
        }
        return ret;
    }

    public boolean hasParamsStoredInto(SparkField field) {
        Set<LocalVarNode> tmp = this.interfa.getParamsStoredInto(field);
        return !(tmp = tmp.stream().filter(this.params::contains).collect(Collectors.toSet())).isEmpty();
    }

    public Set<LocalVarNode> getInParamsToCSFields() {
        Set<SparkField> fields = this.utility.getFields(this.heap);
        HashSet<LocalVarNode> ret = new HashSet<LocalVarNode>();
        for (SparkField field : fields) {
            if (!this.isCSField(field)) continue;
            ret.addAll(this.interfa.getParamsStoredInto(field));
        }
        ret = ret.stream().filter(this.params::contains).collect(Collectors.toSet());
        return ret;
    }

    public boolean hasOutMethodsWithRetOrParamValueFrom(SparkField field) {
        Set<Object> tmp = this.interfa.getOutMethodsWithRetOrParamValueFrom(field);
        return !(tmp = tmp.stream().filter(this.invokedMs::contains).collect(Collectors.toSet())).isEmpty();
    }

    public boolean isCSField(SparkField field) {
        boolean hasIn = this.utility.hasNonThisStoreOnField(this.heap, field) || this.hasParamsStoredInto(field);
        boolean hasOut = this.utility.hasNonThisLoadFromField(this.heap, field) || this.hasOutMethodsWithRetOrParamValueFrom(field);
        return hasIn && hasOut;
    }
}

