/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.mahjong.automata;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import qilin.core.pag.AllocNode;
import qilin.core.pag.SparkField;
import qilin.pta.toolkits.common.FieldPointstoGraph;
import sootup.core.types.Type;

public class NFA {
    private static final AllocNode deadState = null;
    private final AllocNode q0;
    private final FieldPointstoGraph fpg;

    public NFA(AllocNode q0, FieldPointstoGraph fpg) {
        this.q0 = q0;
        this.fpg = fpg;
    }

    public Set<AllocNode> getStates() {
        HashSet<AllocNode> states = new HashSet<AllocNode>();
        Stack<AllocNode> stack = new Stack<AllocNode>();
        stack.push(this.q0);
        while (!stack.isEmpty()) {
            AllocNode s = (AllocNode)stack.pop();
            if (states.contains(s)) continue;
            states.add(s);
            this.outEdgesOf(s).forEach(field -> this.nextStates(s, (SparkField)field).stream().filter(obj -> !states.contains(obj)).forEach(stack::push));
        }
        return states;
    }

    public AllocNode getStartState() {
        return this.q0;
    }

    public AllocNode getDeadState() {
        return deadState;
    }

    public Set<AllocNode> nextStates(AllocNode obj, SparkField f) {
        if (this.isDeadState(obj) || !this.fpg.hasFieldPointer(obj, f)) {
            return Collections.singleton(deadState);
        }
        return this.fpg.pointsTo(obj, f);
    }

    public boolean isDeadState(AllocNode obj) {
        return obj == deadState;
    }

    public Set<SparkField> outEdgesOf(AllocNode obj) {
        if (this.isDeadState(obj)) {
            return Collections.emptySet();
        }
        return this.fpg.outFieldsOf(obj);
    }

    public Type outputOf(AllocNode obj) {
        if (this.isDeadState(obj)) {
            return null;
        }
        return obj.getType();
    }
}

