/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.turner;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.builder.callgraph.Edge;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.Parm;
import qilin.core.pag.ValNode;
import qilin.pta.toolkits.turner.DFA;
import qilin.pta.toolkits.turner.OCG;
import qilin.pta.toolkits.turner.TranEdge;
import qilin.util.PTAUtils;
import qilin.util.Pair;
import qilin.util.queue.QueueReader;
import qilin.util.queue.UniqueQueue;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;

public abstract class AbstractMVFG {
    public static Map<SootMethod, AbstractMVFG> method2VFG = new HashMap<SootMethod, AbstractMVFG>();
    protected final PTA prePTA;
    protected final OCG hg;
    protected final SootMethod method;
    protected final Set<Object> sparkNodes = new HashSet<Object>();
    protected final Set<Object> csNodes = new HashSet<Object>();
    protected final Map<Object, Set<TranEdge>> outEdges = new HashMap<Object, Set<TranEdge>>();
    protected final Map<Object, Set<TranEdge>> inEdges = new HashMap<Object, Set<TranEdge>>();
    protected int total_edge_count = 0;

    public static AbstractMVFG findMethodVFG(SootMethod method) {
        return method2VFG.getOrDefault(method, null);
    }

    public AbstractMVFG(PTA prePTA, OCG hg, SootMethod method) {
        this.prePTA = prePTA;
        this.hg = hg;
        this.method = method;
    }

    public Collection<Object> getAllNodes() {
        return this.sparkNodes;
    }

    public int getTotalNodeCount() {
        return this.sparkNodes.size();
    }

    public int getTotalEdgeCount() {
        return this.total_edge_count;
    }

    public Collection<Object> getCSNodes() {
        return this.csNodes;
    }

    protected void addNormalEdge(TranEdge edge) {
        this.sparkNodes.add(edge.getSource());
        this.sparkNodes.add(edge.getTarget());
        ++this.total_edge_count;
        this.outEdges.computeIfAbsent(edge.getSource(), k -> new HashSet()).add(edge);
        this.inEdges.computeIfAbsent(edge.getTarget(), k -> new HashSet()).add(edge);
    }

    protected void addNewEdge(AllocNode from, LocalVarNode to) {
        TranEdge newEdge = new TranEdge(from, to, DFA.TranCond.NEW);
        this.addNormalEdge(newEdge);
        TranEdge newInvEdge = new TranEdge(to, from, DFA.TranCond.INEW);
        this.addNormalEdge(newInvEdge);
    }

    protected void addCSLikelyEdge(AllocNode heap) {
        TranEdge csLikelyEdge = new TranEdge(heap, heap, DFA.TranCond.CSLIKELY);
        this.addNormalEdge(csLikelyEdge);
    }

    protected void addAssignEdge(LocalVarNode from, LocalVarNode to) {
        TranEdge assignEdge = new TranEdge(from, to, DFA.TranCond.ASSIGN);
        this.addNormalEdge(assignEdge);
        TranEdge assignInvEdge = new TranEdge(to, from, DFA.TranCond.IASSIGN);
        this.addNormalEdge(assignInvEdge);
    }

    protected void addStoreEdge(LocalVarNode from, LocalVarNode base) {
        TranEdge storeEdge = new TranEdge(from, base, DFA.TranCond.STORE);
        this.addNormalEdge(storeEdge);
        TranEdge storeInvEdge = new TranEdge(base, from, DFA.TranCond.ISTORE);
        this.addNormalEdge(storeInvEdge);
    }

    protected void addLoadEdge(LocalVarNode base, LocalVarNode to) {
        TranEdge loadEdge = new TranEdge(base, to, DFA.TranCond.LOAD);
        this.addNormalEdge(loadEdge);
        TranEdge loadInvEdge = new TranEdge(to, base, DFA.TranCond.ILOAD);
        this.addNormalEdge(loadInvEdge);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildVFG() {
        LocalVarNode localVarNode;
        void var8_13;
        OnFlyCallGraph callGraph = this.prePTA.getCallGraph();
        PAG pag = this.prePTA.getPag();
        MethodPAG srcmpag = pag.getMethodPAG(this.method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        Object reader = srcmpag.getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            FieldRefNode fr;
            Node from = (Node)((QueueReader)reader).next();
            Node node = (Node)((QueueReader)reader).next();
            if (from instanceof LocalVarNode) {
                if (node instanceof LocalVarNode) {
                    this.addAssignEdge((LocalVarNode)from, (LocalVarNode)node);
                    continue;
                }
                if (!(node instanceof FieldRefNode)) continue;
                fr = (FieldRefNode)node;
                this.addStoreEdge((LocalVarNode)from, (LocalVarNode)fr.getBase());
                continue;
            }
            if (from instanceof AllocNode) {
                if (!(node instanceof LocalVarNode)) continue;
                this.addNewEdge((AllocNode)from, (LocalVarNode)node);
                if (!this.hg.isCSLikely((AllocNode)from)) continue;
                this.addCSLikelyEdge((AllocNode)from);
                continue;
            }
            if (!(from instanceof FieldRefNode)) continue;
            fr = (FieldRefNode)from;
            this.addLoadEdge((LocalVarNode)fr.getBase(), (LocalVarNode)node);
        }
        srcmpag.getExceptionEdges().forEach((k, vs) -> {
            for (Node v : vs) {
                this.addAssignEdge((LocalVarNode)k, (LocalVarNode)v);
            }
        });
        for (Stmt stmt : srcmpag.getInvokeStmts()) {
            LocalVarNode receiver;
            LValue dest;
            AbstractInvokeExpr ie = (AbstractInvokeExpr)stmt.asInvokableStmt().getInvokeExpr().get();
            int numArgs = ie.getArgCount();
            Value[] args = new Value[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                Immediate arg = ie.getArg(i);
                if (!(arg.getType() instanceof ReferenceType) || arg instanceof NullConstant) continue;
                args[i] = arg;
            }
            LocalVarNode retDest = null;
            if (stmt instanceof JAssignStmt && (dest = ((JAssignStmt)stmt).getLeftOp()).getType() instanceof ReferenceType) {
                retDest = pag.findLocalVarNode(this.method, dest, dest.getType());
            }
            if (ie instanceof AbstractInstanceInvokeExpr) {
                AbstractInstanceInvokeExpr iie = (AbstractInstanceInvokeExpr)ie;
                Local base = iie.getBase();
                receiver = pag.findLocalVarNode(this.method, base, base.getType());
            } else {
                receiver = thisRef;
            }
            HashSet<SootMethod> targets = new HashSet<SootMethod>();
            Iterator<Edge> it = callGraph.edgesOutOf(stmt);
            while (it.hasNext()) {
                Edge e = it.next();
                SootMethod tgtmtd = e.tgt();
                targets.add(tgtmtd);
            }
            if (targets.isEmpty()) continue;
            for (int i = 0; i < numArgs; ++i) {
                ValNode argNode;
                if (args[i] == null || !((argNode = pag.findValNode(args[i], this.method)) instanceof LocalVarNode) || !this.satisfyAddingStoreCondition(i, targets)) continue;
                this.addStoreEdge((LocalVarNode)argNode, receiver);
            }
            if (retDest != null && retDest.getType() instanceof ReferenceType && this.statisfyAddingLoadCondition(targets)) {
                this.addLoadEdge(receiver, retDest);
            }
            if (this.statisfyAddingLoadCondition(targets)) {
                LocalVarNode stmtThrowNode = srcnf.makeInvokeStmtThrowVarNode(stmt, this.method);
                this.addLoadEdge(receiver, stmtThrowNode);
            }
            if (!this.satisfyAddingStoreCondition(-1, targets)) continue;
            this.addStoreEdge(receiver, receiver);
        }
        this.addNormalEdge(new TranEdge(thisRef, thisRef, DFA.TranCond.PARAM));
        this.addNormalEdge(new TranEdge(thisRef, thisRef, DFA.TranCond.IPARAM));
        int numParms = this.method.getParameterCount();
        boolean bl = false;
        while (var8_13 < numParms) {
            if (this.method.getParameterType((int)var8_13) instanceof ReferenceType) {
                LocalVarNode param = (LocalVarNode)srcnf.caseParm((int)var8_13);
                this.addNormalEdge(new TranEdge(param, param, DFA.TranCond.PARAM));
                this.addNormalEdge(new TranEdge(param, param, DFA.TranCond.IPARAM));
            }
            ++var8_13;
        }
        if (this.method.getReturnType() instanceof ReferenceType) {
            LocalVarNode localVarNode2 = (LocalVarNode)srcnf.caseRet();
            this.addStoreEdge(localVarNode2, thisRef);
        }
        if ((localVarNode = pag.findLocalVarNode(this.method, new Parm(this.method, -3), (Type)PTAUtils.getClassType("java.lang.Exception"))) != null) {
            this.addStoreEdge(localVarNode, thisRef);
        }
    }

    protected abstract boolean statisfyAddingLoadCondition(Set<SootMethod> var1);

    protected abstract boolean satisfyAddingStoreCondition(int var1, Set<SootMethod> var2);

    public void computeNodesInPrecisionLossPatterns() {
        UniqueQueue workList = new UniqueQueue();
        HashMap state2nodes = new HashMap();
        MethodPAG srcmpag = this.prePTA.getPag().getMethodPAG(this.method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        int numParms = this.method.getParameterCount();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        Set startState = state2nodes.computeIfAbsent(DFA.State.S, k -> new HashSet());
        startState.add(thisRef);
        workList.add(new Pair<LocalVarNode, DFA.State>(thisRef, DFA.State.S));
        for (int i = 0; i < numParms; ++i) {
            if (!(this.method.getParameterType(i) instanceof ReferenceType)) continue;
            LocalVarNode param = (LocalVarNode)srcnf.caseParm(i);
            startState.add(param);
            workList.add(new Pair<LocalVarNode, DFA.State>(param, DFA.State.S));
        }
        if (this.method.getReturnType() instanceof ReferenceType) {
            LocalVarNode mret = (LocalVarNode)srcnf.caseRet();
            startState.add(mret);
            workList.add(new Pair<LocalVarNode, DFA.State>(mret, DFA.State.S));
        }
        LocalVarNode mThrow = (LocalVarNode)srcnf.caseMethodThrow();
        startState.add(mThrow);
        workList.add(new Pair<LocalVarNode, DFA.State>(mThrow, DFA.State.S));
        while (!workList.isEmpty()) {
            Pair pair = (Pair)workList.poll();
            Object currNode = pair.getFirst();
            DFA.State currState = (DFA.State)((Object)pair.getSecond());
            for (TranEdge e : this.outEdges.getOrDefault(currNode, Collections.emptySet())) {
                Set stateNodes;
                Object target = e.getTarget();
                DFA.TranCond tranCond = e.getTranCond();
                DFA.State nextState = DFA.nextState(currState, tranCond);
                if (nextState == DFA.State.ERROR || !(stateNodes = state2nodes.computeIfAbsent(nextState, k -> new HashSet())).add(target)) continue;
                workList.add(new Pair<Object, DFA.State>(target, nextState));
            }
        }
        Set flowNodes = state2nodes.getOrDefault((Object)DFA.State.FLOW, Collections.emptySet());
        Set iflowNodes = state2nodes.getOrDefault((Object)DFA.State.IFLOW, Collections.emptySet());
        for (Object sparkNode : this.sparkNodes) {
            if (!flowNodes.contains(sparkNode) || !iflowNodes.contains(sparkNode)) continue;
            this.csNodes.add(sparkNode);
        }
    }
}

