/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeMap;
import qilin.CoreConfig;
import qilin.core.CorePTA;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.builder.CallGraphBuilder;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.core.solver.Propagator;
import qilin.core.solver.Solver;
import qilin.stat.IEvaluator;
import qilin.stat.SimplifiedEvaluator;
import qilin.util.PTAUtils;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;

public abstract class BasePTA
extends CorePTA {
    protected IEvaluator evaluator = new SimplifiedEvaluator(this);

    public BasePTA(PTAScene scene) {
        super(scene);
    }

    public IEvaluator evaluator() {
        return this.evaluator;
    }

    @Override
    protected PAG createPAG() {
        return new PAG(this);
    }

    @Override
    protected CallGraphBuilder createCallGraphBuilder() {
        return new CallGraphBuilder(this);
    }

    @Override
    public Propagator getPropagator() {
        return new Solver(this);
    }

    @Override
    public void run() {
        this.evaluator.begin();
        this.pureRun();
        this.evaluator.end();
        this.dumpStats();
        System.out.println(this.evaluator());
    }

    protected void dumpStats() {
        if (CoreConfig.v().getOutConfig().dumppts) {
            this.dumpPts(this, !CoreConfig.v().getOutConfig().dumplibpts);
        }
    }

    private void dumpPts(PTA pta, boolean appOnly) {
        String output_dir = CoreConfig.v().getOutConfig().outDir;
        TreeMap<String, Node> nodes = new TreeMap<String, Node>();
        try {
            PrintWriter file = new PrintWriter(new File(output_dir, "pts.txt"));
            file.println("Points-to results:");
            for (ValNode vn : pta.getPag().getValNodes()) {
                if (!(vn instanceof VarNode)) continue;
                SootClass clz = null;
                if (vn instanceof LocalVarNode) {
                    SootMethod sm = ((LocalVarNode)vn).getMethod();
                    if (sm != null && !PTAUtils.isFakeMainMethod(sm)) {
                        clz = (SootClass)this.getView().getClass(sm.getDeclaringClassType()).get();
                    }
                } else if (vn instanceof GlobalVarNode) {
                    GlobalVarNode gvn = (GlobalVarNode)vn;
                    Object variable = gvn.getVariable();
                    if (variable instanceof SootField) {
                        SootField sf = (SootField)variable;
                        clz = (SootClass)this.getView().getClass(sf.getDeclaringClassType()).get();
                    }
                } else if (vn instanceof ContextVarNode) {
                    GlobalVarNode gvn;
                    Object variable;
                    ContextVarNode cv = (ContextVarNode)vn;
                    VarNode varNode = cv.base();
                    if (varNode instanceof LocalVarNode) {
                        LocalVarNode cvbase = (LocalVarNode)varNode;
                        clz = (SootClass)this.getView().getClass(cvbase.getMethod().getDeclaringClassType()).get();
                    } else if (varNode instanceof GlobalVarNode && (variable = (gvn = (GlobalVarNode)varNode).getVariable()) instanceof SootField) {
                        SootField sf = (SootField)variable;
                        clz = (SootClass)this.getView().getClass(sf.getDeclaringClassType()).get();
                    }
                }
                if (appOnly && clz != null && !clz.isApplicationClass()) continue;
                String label = PTAUtils.getNodeLabel(vn);
                nodes.put("[" + label + "]", vn);
                file.print(label + " -> {");
                PointsToSet p2set = pta.reachingObjects(vn);
                if (p2set == null || p2set.isEmpty()) {
                    file.print(" empty }\n");
                    continue;
                }
                Iterator<AllocNode> it = p2set.iterator();
                while (it.hasNext()) {
                    Node n2 = it.next();
                    label = PTAUtils.getNodeLabel(n2);
                    nodes.put("[" + label + "]", n2);
                    file.print(" ");
                    file.print(label);
                }
                file.print(" }\n");
            }
            nodes.forEach((l, n) -> file.println(l + n));
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }
}

