/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.tools;

import java.util.HashSet;
import java.util.Set;
import qilin.core.context.Context;
import qilin.core.pag.AllocNode;
import qilin.core.pag.CallSite;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.Node;
import qilin.core.sets.PointsToSet;
import qilin.core.solver.Propagator;
import qilin.parm.select.DebloatingSelector;
import qilin.parm.select.PipelineSelector;
import qilin.pta.PTAConfig;
import qilin.pta.toolkits.common.DebloatedOAG;
import qilin.pta.toolkits.common.OAG;
import qilin.pta.toolkits.conch.Conch;
import qilin.pta.toolkits.debloaterx.CollectionHeuristic;
import qilin.pta.toolkits.debloaterx.DebloaterX;
import qilin.pta.tools.BasePTA;
import qilin.pta.tools.Spark;
import qilin.pta.tools.StagedPTA;
import qilin.stat.IEvaluator;
import qilin.util.Stopwatch;
import sootup.core.jimple.basic.Local;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;

public class DebloatedPTA
extends StagedPTA {
    protected BasePTA basePTA;
    protected Set<Object> ctxDepHeaps = new HashSet<Object>();
    protected DebloatApproach debloatApproach;

    public DebloatedPTA(BasePTA basePTA, DebloatApproach approach) {
        super(basePTA.getScene());
        this.basePTA = basePTA;
        DebloatingSelector debloatingSelector = new DebloatingSelector(this.ctxDepHeaps);
        basePTA.setContextSelector(new PipelineSelector(basePTA.ctxSelector(), debloatingSelector));
        if (basePTA instanceof StagedPTA) {
            StagedPTA stagedPTA = (StagedPTA)basePTA;
            this.prePTA = stagedPTA.getPrePTA();
        } else {
            this.prePTA = new Spark(basePTA.getScene());
        }
        System.out.println("debloating ....");
        this.debloatApproach = approach;
    }

    @Override
    protected void preAnalysis() {
        Stopwatch sparkTimer = Stopwatch.newAndStart("Spark");
        this.prePTA.pureRun();
        sparkTimer.stop();
        System.out.println(sparkTimer);
        if (this.debloatApproach == DebloatApproach.CONCH) {
            Stopwatch conchTimer = Stopwatch.newAndStart("Conch");
            Conch hc = new Conch(this.prePTA);
            hc.runClassifier();
            this.ctxDepHeaps.addAll(hc.ctxDependentHeaps());
            System.out.println();
            conchTimer.stop();
            System.out.println(conchTimer);
        } else if (this.debloatApproach == DebloatApproach.DEBLOATERX) {
            Stopwatch debloaterXTimer = Stopwatch.newAndStart("DebloaterX");
            DebloaterX debloaterX = new DebloaterX(this.prePTA);
            debloaterX.run();
            Set<AllocNode> mCtxDepHeaps = debloaterX.getCtxDepHeaps();
            for (AllocNode obj : mCtxDepHeaps) {
                this.ctxDepHeaps.add(obj.getNewExpr());
            }
            System.out.println();
            debloaterXTimer.stop();
            System.out.println(debloaterXTimer);
            OAG oag = new OAG(this.prePTA);
            oag.build();
            DebloatedOAG doag1 = new DebloatedOAG(this.prePTA, mCtxDepHeaps);
            doag1.build();
            System.out.println("OAG #node:" + oag.nodeSize() + "; #edge:" + oag.edgeSize());
            System.out.println("DebloaterX OAG #node:" + doag1.nodeSize() + "; #edge:" + doag1.edgeSize());
        } else {
            assert (this.debloatApproach == DebloatApproach.COLLECTION);
            Stopwatch collectionHeuristic = Stopwatch.newAndStart("COLLECTION");
            CollectionHeuristic ch = new CollectionHeuristic(this.prePTA);
            ch.run();
            collectionHeuristic.stop();
            System.out.println(collectionHeuristic);
            for (AllocNode obj : ch.getCtxDepHeaps()) {
                this.ctxDepHeaps.add(obj.getNewExpr());
            }
        }
    }

    @Override
    protected void mainAnalysis() {
        if (!PTAConfig.v().getPtaConfig().preAnalysisOnly) {
            System.out.println("selective pta starts!");
            this.basePTA.run();
        }
    }

    @Override
    public Propagator getPropagator() {
        return this.basePTA.getPropagator();
    }

    @Override
    public Node parameterize(Node n, Context context) {
        return this.basePTA.parameterize(n, context);
    }

    @Override
    public ContextMethod parameterize(SootMethod method, Context context) {
        return this.basePTA.parameterize(method, context);
    }

    @Override
    public AllocNode getRootNode() {
        return this.basePTA.getRootNode();
    }

    @Override
    public IEvaluator evaluator() {
        return this.basePTA.evaluator();
    }

    @Override
    public Context emptyContext() {
        return this.basePTA.emptyContext();
    }

    @Override
    public Context createCalleeCtx(ContextMethod caller, AllocNode receiverNode, CallSite callSite, SootMethod target) {
        return this.basePTA.createCalleeCtx(caller, receiverNode, callSite, target);
    }

    @Override
    public PointsToSet reachingObjects(SootMethod m, Local l) {
        return this.basePTA.reachingObjects(m, l);
    }

    @Override
    public PointsToSet reachingObjects(Node n) {
        return this.basePTA.reachingObjects(n);
    }

    @Override
    public PointsToSet reachingObjects(Context c, SootMethod m, Local l) {
        return this.basePTA.reachingObjects(c, m, l);
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        return this.basePTA.reachingObjects(f);
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        return this.basePTA.reachingObjects(s, f);
    }

    @Override
    public PointsToSet reachingObjects(SootMethod m, Local l, SootField f) {
        return this.basePTA.reachingObjects(m, l, f);
    }

    @Override
    public PointsToSet reachingObjects(Context c, SootMethod m, Local l, SootField f) {
        return this.basePTA.reachingObjects(c, m, l, f);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        return this.basePTA.reachingObjectsOfArrayElement(s);
    }

    public static enum DebloatApproach {
        CONCH,
        DEBLOATERX,
        COLLECTION;

    }
}

